package dna;

import java.io.StringReader;
import java.io.StringWriter;

import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.Unmarshaller;
import org.exolab.castor.xml.ValidationException;

import dna.util.Debug;
import dna.xml.Screen_request;
import dna.xml.Screen_response;

public class ScreenHelper
   implements ExpertListener
{
   private ExpertClientHTTPServer _httpServer = ExpertClientHTTPServer.getGUIServer();
   private ExpertProxy _expertProxy = ExpertProxy.getInstance();
   private Screen_response _screen_response = null;
   private String _callbackStatus = "ok";

   public ScreenHelper()
   {
      _httpServer.addExpertListener(this);
   }

   public void sendScreen_request(Screen_request screen_request)
      throws ScreenException
   {
      StringWriter stringWriter = new StringWriter();
      try
      {
         screen_request.marshal(stringWriter);
         String xml_string = stringWriter.toString();
         _expertProxy.sendToExpert("/screen_request", xml_string);
      }
      catch (MarshalException mex)
      {
         throw new ScreenException("MarshalException in "
            + "ScreenHelper.sendScreen_request: " + mex);
      }
      catch (ValidationException vex)
      {
         throw new ScreenException("ValidationException in "
            + "ScreenHelper.sendScreen_request: " + vex);
      }
   }

   public synchronized Screen_response sendScreen_requestSynchronous(
      Screen_request screen_request, int timeOut) throws ScreenException
   {
      _screen_response = null;
      _callbackStatus = "ok";
      this.sendScreen_request(screen_request);
      Debug.out("Sending screen request." + screen_request, 2);
      try
      {
         Debug.out("Screen request sent, waiting for screen response.", 2);
         this.wait(timeOut);
      }
      catch (InterruptedException ex)
      {
         throw new ScreenException("InterruptedException caught in "
            + "ScreenHelper.sendScreen_requestSynchronous");
      }
      if (_screen_response == null)
         if (_callbackStatus.equals("ok"))
            throw new ScreenException("Time out while waiting for screen "
               + "response.");
         else
            throw new ScreenException(_callbackStatus);
      return _screen_response;
   }

   public synchronized void expertMessage(ExpertXMLMessage the_message)
   {
      String path = the_message.getPath();

      if (path.equals("/screen_response"))
      {
         Debug.out("Screen response received", 2);
         String xml_message = the_message.getXMLMessage();
         Debug.out(xml_message, 2);
         StringReader reader = new StringReader(the_message.getXMLMessage());
         try
         {
            _screen_response = (Screen_response) Unmarshaller.unmarshal(
               Screen_response.class, reader);
         }
         catch (MarshalException ex)
         {
            _callbackStatus = "MasrhalException in "
               + "ScreenHelper.expertMessage";
         }
         catch (ValidationException ex)
         {
            _callbackStatus = "ValidationException in "
               + "ScreenHelper.expertMessage";
         }
         this.notify();
      }
   }
}
