package dna;

import java.io.StringReader;
import java.io.StringWriter;

import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.Unmarshaller;
import org.exolab.castor.xml.ValidationException;

import dna.util.Debug;
import dna.xml.Quick_scale_request;
import dna.xml.Quick_scale_response;

public class ScaleHelper
   implements ExpertListener
{
   private ExpertClientHTTPServer httpServer = ExpertClientHTTPServer.getGUIServer();
   private ExpertProxy expertProxy = ExpertProxy.getInstance();;
   private Quick_scale_response quick_scale_response = null;
   private String callbackStatus = "ok";

   public ScaleHelper()
   {
      httpServer.addExpertListener(this);
   }

   public void sendQuick_scale_request(Quick_scale_request quick_scale_request)
      throws Quick_scaleException
   {
      StringWriter stringWriter = new StringWriter();
      try
      {
         quick_scale_request.marshal(stringWriter);
         String xml_string = stringWriter.toString();
         expertProxy.sendToExpert("/quick_scale_request", xml_string);
      }
      catch (MarshalException mex)
      {
         throw new Quick_scaleException("MarshalException in "
            + "Quick_ScaleHelper.sendQuick_Scale_request: " + mex);
      }
      catch (ValidationException vex)
      {
         throw new Quick_scaleException("ValidationException in "
            + "Quick_ScaleHelper.sendQuick_Scale_request: " + vex);
      }
   }

   public synchronized Quick_scale_response sendQuick_Scale_requestSynchronous(
      Quick_scale_request quick_scale_request, int timeOut)
      throws Quick_scaleException
   {
      quick_scale_response = null;
      callbackStatus = "ok";
      this.sendQuick_scale_request(quick_scale_request);
      Debug.out("Sending quick_scale request.", 2);
      try
      {
         Debug.out(
            "Quick_Scale request sent, waiting for quick_scale response.", 2);
         this.wait(timeOut);
      }
      catch (InterruptedException ex)
      {
         throw new Quick_scaleException("InterruptedException caught in "
            + "Quick_ScaleHelper.sendQuick_Scale_requestSynchronous");
      }
      if (quick_scale_response == null)
         if (callbackStatus.equals("ok"))
            throw new Quick_scaleException(
               "Time out while waiting for quick_scale " + "response.");
         else
            throw new Quick_scaleException(callbackStatus);
      return quick_scale_response;
   }

   public synchronized void expertMessage(ExpertXMLMessage the_message)
   {
      String path = the_message.getPath();

      if (path.equals("/quick_scale_response"))
      {
         Debug.out("Quick_Scale response received", 2);
         String xml_message = the_message.getXMLMessage();
         Debug.out(xml_message, 2);
         StringReader reader = new StringReader(the_message.getXMLMessage());
         try
         {
            quick_scale_response = (Quick_scale_response) Unmarshaller.unmarshal(
               Quick_scale_response.class, reader);
         }
         catch (MarshalException ex)
         {
            callbackStatus = "MasrhalException in "
               + "Quick_ScaleHelper.expertMessage";
         }
         catch (ValidationException ex)
         {
            callbackStatus = "ValidationException in "
               + "Quick_ScaleHelper.expertMessage";
         }
         this.notify();
      }
   }
}
