package dna;

import java.util.ArrayList;
import java.util.Observable;
import java.util.Observer;

import javax.swing.table.AbstractTableModel;

/**
 * To change the template for this generated type comment go to Window -
 * Preferences - Java - Code Generation - Code and Comments
 */
public class SampleScreeningTableModel
   extends AbstractTableModel
   implements Observer
{
   private static SampleScreeningTableModel tableModel = null;
   private int maxSequences = 10;
   private ArrayList data = new ArrayList(maxSequences);
   private static int oscillationCount;
   private SampleScreeningData screeningData;

   public SampleScreeningTableModel()
   {
      extendScreeningData(0, maxSequences);
      tableModel = this;
   }

   public boolean isCellEditable(int row, int col)
   {
      return true;
   }

   public SampleScreeningData getScreeningData(int index)
   {
      return (SampleScreeningData) data.get(index);
   }

   public static SampleScreeningTableModel getReference()
   {
      return tableModel;
   }

   public void setDataArraySize(int count)
   {
      if (count > maxSequences)
      {
         extendScreeningData(maxSequences, count);
         maxSequences = count;
      }

      oscillationCount = count;
      fireTableDataChanged();
   }

   private void extendScreeningData(int start, int end)
   {
      for (int i = start; i < end; i++)
      {
         screeningData = new SampleScreeningData();
         screeningData.addObserver(this);
         data.add(screeningData);
      }
   }

   // AbstractTableModel

   public Class getColumnClass(int c)
   {

      return getValueAt(0, c).getClass();
   }

   public int getColumnCount()
   {
      return SampleScreeningData.getColumnCount();
   }

   public int getRowCount()
   {
      return oscillationCount;
   }

   public String getColumnName(int column)
   {
      return SampleScreeningData.getColumnName(column);
   }

   public Object getValueAt(int row, int col)
   {
      Object value = new Double(-1.0);
      screeningData = (SampleScreeningData) data.get(row);

      switch (col)
      {
         case SampleScreeningData.SCREEN:
            value = screeningData.getScreen();
            break;
         case SampleScreeningData.CELL:
            value = screeningData.getCell();
            break;
         case SampleScreeningData.BAR_CODE:
            value = screeningData.getBarCode();
            break;
         case SampleScreeningData.LOCATION:
            value = screeningData.getLocation();
            break;
         case SampleScreeningData.PREFIX:
            value = screeningData.getPrefix();
            break;
         case SampleScreeningData.RSYM:
            value = screeningData.getSymmetry();
            break;
         case SampleScreeningData.RESO_REQ:
            value = screeningData.getResolution();
            break;
      }

      return value;
   }

   public void setValueAt(Object value, int row, int col)
   {
      float val;
      screeningData = (SampleScreeningData) data.get(row);

      switch (col)
      {
         case SampleScreeningData.SCREEN:
            screeningData.setScreen((Boolean) value);
            break;
         case SampleScreeningData.CELL:
            screeningData.setCell((String) value);
            break;
         case SampleScreeningData.BAR_CODE:
            screeningData.setBarCode((String) value);
            break;
         case SampleScreeningData.LOCATION:
            screeningData.setLocation((String) value);
            break;
         case SampleScreeningData.PREFIX:
            screeningData.setPrefix((String) value);
            break;
         case SampleScreeningData.RSYM:
            screeningData.setSymmetry((String) value);
            break;
         case SampleScreeningData.RESO_REQ:
            screeningData.setResolution((String) value);
            break;
      }
   }

   // Observer

   public synchronized void update(Observable obs, Object col)
   {
      int i;

      for (i = 0; i < maxSequences; i++)
      {
         if ((SampleScreeningData) obs == (SampleScreeningData) data.get(i))
            break;
      }

      fireTableCellUpdated(i, ((Integer) col).intValue());
   }

}
