
package dna;

import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.StringTokenizer;

import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextField;

import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.ValidationException;

import dna.observable.IObservable;
import dna.observable.IObserver;
import dna.observable.ObservableComponent;
import dna.util.BravaisLatticeSelector;
import dna.util.Debug;
import dna.util.DecimalField;
import dna.util.TitleBorder;
import dna.xml.Characterize_crystal_request;
import dna.xml.Collect_reference_request;
import dna.xml.Collect_request;
import dna.xml.Detector;
import dna.xml.Fileinfo;
import dna.xml.Loaded_samples_request;
import dna.xml.Oscillation_sequence;
import dna.xml.Proposal;
import dna.xml.Resolution;
import dna.xml.Sample_reference;
import dna.xml.Screen_request;
import dna.xml.Target;
import dna.xml.types.Spacegroup;

public class SampleScreeningPanel
   extends DNAInitialDataPanel
   implements IObservable, IObserver, ActionListener
{
   private static final int COLLECT = 0;
   private static final int CHARACTERIZE = 1;
   private static int operation;

   private ExpertDataModel edm = ExpertDataModel.getInstance();

   private JPanel selectionPanel = new JPanel();
      private SampleScreeningDataPanel screeningDataPanel = new SampleScreeningDataPanel();
   private SampleScreeningData screeningData;
   private JButton getLoadedSamples = new JButton("Get Sample Changer Contents");
   private JButton selectAllSamples = new JButton("Select All Samples");
   private JButton deselectAllSamples = new JButton("Deselect All Samples");
   private JButton screen = new JButton("Screen");
   private boolean performingScreening = false;

   private ObservableComponent observableComponent = new ObservableComponent();

   private Fileinfo fileinfo = new Fileinfo();
   private Oscillation_sequence oscillation_sequence = new Oscillation_sequence();
   private Collect_request collect_request = new Collect_request();
   private Collect_reference_request collect_reference_request = new Collect_reference_request();
   private Resolution collect_resolution = new Resolution();
   private CollectHelper collectHelper = CollectHelper.getInstance();

   private Characterize_crystal_request characterize_crystal_request = new Characterize_crystal_request();
   private CharacterizeCrystalHelper characterizeCrystalHelper = CharacterizeCrystalHelper.getInstance();
   private Detector detector = new Detector();
   private Target target = new Target();
   private Screen_request screenRequest;
   private boolean achive_reference_images;
   private Sample_reference sample_reference;
   private ScreenHelper screenHelper = new ScreenHelper();
   private DbHelper dbHelper = DbHelper.getInstance();
   private Loaded_samples_request loaded_samples_request;
   private ArrayList <String> panelTitles = new ArrayList <String>();

   public SampleScreeningPanel()
   {
      panelTitles.add("Collect parameters");
      panelTitles.add("Index and strategy parameters");
      setTitles(panelTitles);
      GridBagConstraints c = new GridBagConstraints();
      setLayout(new GridBagLayout());

      selectionPanel.add(screeningDataPanel);

      c.fill = GridBagConstraints.HORIZONTAL;
      c.gridy = GridBagConstraints.RELATIVE;

      initialiseSetupPanels();
      populateSetupPanels();
      populateButtonPanel();

      c.gridy = GridBagConstraints.RELATIVE;
      c.weightx = 1.0;
      c.weighty = 0.0;
      c.gridx = 0;
      c.gridy++;
      add(parametersPanel(), c);

      c.fill = GridBagConstraints.BOTH;
      c.weightx = 1.0;
      c.weighty = 1.0;
      c.insets = new Insets(0, 5, 2, 5); // Top, Left, Bottom, Right
      c.gridx = 0;
      c.gridy++;
      add(screeningDataPanel, c);
      
      c.fill = GridBagConstraints.NONE;
      c.weightx = 1.0;
      c.weighty = 0.0;
      c.gridx = 0;
      c.gridy++;
      add(buttonPanel, c);
      
      edm.addIObserver(this);
   }

   
   private void populateSetupPanels()
   {
      int collectComponentCount = 1;
      int strategyComponentCount = 1;
      
       /* try { Bcm_parameters_response response =
       * collectHelper.sendBcm_parameters_requestSynchronous(request,
       * edm.getStrategyTimeout()); } catch (CollectException e) {
       * Debug.out("Time out making bcm parameters request."); }
       */
      directory.setText(edm.getDirectory());
      addComponent(collectComponentCount++, "Directory", "",
         directory, "Collect parameters");
      addComponent(collectComponentCount++,
            "PUBLIC copy of ref. images", "", saveReferenceImages, "Collect parameters");

      if (edm.isRunNumberOn())
      {
         runNumber.setText(edm.getRunNumber());
         addComponent(collectComponentCount++,
               "Start Run Number", "", runNumber, "Collect parameters");
      }

      time.setText(edm.getTime());
      addComponent(collectComponentCount++, "Exposure Time", "",
            time, "Collect parameters");
      oscillation.setText(edm.getIncrement());
      addComponent(collectComponentCount++, "Oscillation", "",
            oscillation, "Collect parameters");
      resolution.setText(edm.getResolution());
      addComponent(collectComponentCount++, "Resolution", "",
            resolution, "Collect parameters");

      bravaisLattice.addIObserver(edm);
      addComponent(strategyComponentCount++, "Bravais Lattice",
            "", bravaisLattice, "Index and strategy parameters");
      minOscillation.setText(""+edm.getMinOscillation());
      addComponent(strategyComponentCount++,
            "Minimum Desired Oscillation", "", minOscillation, "Index and strategy parameters");
      multiplicity.setText(""+edm.getMultiplicity());
      addComponent(strategyComponentCount++, "Multiplicity", "",
            multiplicity, "Index and strategy parameters");
      addComponent(strategyComponentCount++, "Anomalous", "",
            anomalous, "Index and strategy parameters");
   }

   private void populateButtonPanel()
   {
      GridBagConstraints c = new GridBagConstraints();

      getLoadedSamples.setActionCommand("Get Loaded Samples");
      getLoadedSamples.addActionListener(this);
      selectAllSamples.setActionCommand("Select All Samples");
      selectAllSamples.addActionListener(this);
      deselectAllSamples.setActionCommand("Deselect All Samples");
      deselectAllSamples.addActionListener(this);
      screen.setActionCommand("Screen");
      screen.addActionListener(this);

      buttonPanel.setLayout(new GridBagLayout());
      c.insets = new Insets(3, 5, 0, 5); // Top, Left, Bottom, Right
      c.gridx = GridBagConstraints.RELATIVE;
      c.gridy = 1;
      c.anchor = GridBagConstraints.CENTER;

      if (edm.isSampleChangerScanInUse())
      {
         buttonPanel.add(getLoadedSamples, c);
         getLoadedSamples.setEnabled(true);
      }

      buttonPanel.add(selectAllSamples, c);
      buttonPanel.add(deselectAllSamples, c);
      buttonPanel.add(screen, c);
   }

   public void activate()
   {
      screen.setEnabled(true);
      getLoadedSamples.setEnabled(true);
      selectAllSamples.setEnabled(true);
      deselectAllSamples.setEnabled(true);
      if (performingScreening)
      {
         observableComponent.notifyIObservers(this, new ExpertState(
            ExpertState.RANKING));
         performingScreening = false;
      }
   }

   public void deactivate()
   {
      screen.setEnabled(false);
      getLoadedSamples.setEnabled(false);
      selectAllSamples.setEnabled(false);
      deselectAllSamples.setEnabled(false);
   }

   // IObservable

   public void addIObserver(IObserver anIObserver)
   {
      observableComponent.addIObserver(anIObserver);
   }

   public void deleteIObserver(IObserver anIObserver)
   {
      observableComponent.deleteIObserver(anIObserver);
   }

   public void deleteIObservers()
   {
      observableComponent.deleteIObservers();
   }

   // IObserver

   public void update(Object iObservable, Object arg)
   {
      if (arg instanceof ExpertState)
      {
         ExpertState state = (ExpertState) arg;

         switch (state.getState())
         {
            case ExpertState.IDLE:
            case ExpertState.ABORTED:
               activate();
               break;
            case ExpertState.COLLECTING_REFERENCE_IMAGES:
               deactivate();
               break;
         }
      }
      else if (arg instanceof ExpertDataModel)
      {
         anomalous.setSelected(edm.getAnomalous());
         minOscillation.setText(""+edm.getMinOscillation());
         multiplicity.setText(""+edm.getMultiplicity());
      }
      if (arg instanceof Proposal)
      {
         getLoadedSamples.setEnabled(true);
      }
   }

   // ActionListener

   public void actionPerformed(ActionEvent ae)
   {
      if (ae.getActionCommand().equals("Screen"))
      {
         boolean goAhead = true;
         CheckParametersDialog dialog = null;
         screenRequest = createScreenRequest();

         if (edm.checkScreeningParameters())
         {
            dialog = new CheckParametersDialog(this);
            if (!dialog.isOk())
               goAhead = false;
         }

         edm.setCheckScreeningParameters(false);

         if (goAhead)
         {
            performingScreening = true;
            try
            {
               deactivate();
               StringWriter stringWriter = new StringWriter();
               screenRequest.marshal(stringWriter);
            }
            catch (MarshalException ex)
            {
               Debug.out("MarshalException in SampleScreeningPanel " + ex);
            }
            catch (ValidationException ex)
            {
               Debug.out("ValidationException in SampleScreeningPanel " + ex);
            }

            try
            {
               screenHelper.sendScreen_request(screenRequest);
            }
            catch (ScreenException ex)
            {
               Debug.out("ScreenException in SampleScreeningPanel " + ex);
            }
         }
      }
      else if (ae.getActionCommand().equals("Select All Samples"))
      {
         screeningDataPanel.selectAllSamples();
      }
      else if (ae.getActionCommand().equals("Deselect All Samples"))
      {
         screeningDataPanel.deselectAllSamples();
      }
      else if (ae.getActionCommand().equals("Get Loaded Samples"))
      {
    	 edm.setResolution( Double.parseDouble( resolution.getText() ) );
         try
         {
            deactivate();
            Debug.out("Getting loaded samples for proposal id: "
               + edm.getProposal().getProposalId(), 1);
            loaded_samples_request = new Loaded_samples_request();
            loaded_samples_request.setProposal(edm.getProposal());
            Debug.out("Trying to send loaded_samples_request", 1);
            dbHelper.sendLoaded_samples_request(loaded_samples_request);
         }
         catch (CollectException ex)
         {
            System.out.println("CollectException caught: " + ex.getMessage());
         }
      }
   }

   private Screen_request createScreenRequest()
   {
      screenRequest = new Screen_request();
      int numSamples = screeningDataPanel.getDataArraySize();
      int screenCount = 0;

      screenRequest.setSessionId((edm.getSession()).getSessionId());

      for (int i = 0; i < numSamples; i++)
      {
         screeningData = screeningDataPanel.getScreeningData(i);
         if ((screeningData.getScreen()).booleanValue())
         {
            setCollectionConstants();
            screenRequest.addCharacterize_crystal_request(screenCount,
               createCharacterize_crystal_request());
            screenCount++;
         }
      }
      return screenRequest;
   }

   private void setCollectionConstants()
   {
      fileinfo = new Fileinfo();
      fileinfo.setDirectory(directory.getText());

      if (edm.isRunNumberOn())
      {
         // Do something about this.
         fileinfo.setRun_number(1);
      }
      else
      {
         fileinfo.setRun_number(1);
      }
      achive_reference_images = saveReferenceImages.isSelected();
   }

   private Characterize_crystal_request createCharacterize_crystal_request()
   {
      Target target = new Target();
      // This is hard coded will need fixing.
      target.setSymmetry(Spacegroup.valueOf("unknown"));

      characterize_crystal_request = new Characterize_crystal_request();
      collect_request = new Collect_request();

      if (edm.isPrefixingOn())
         fileinfo.setPrefix(edm.getPrefixPrefix() + screeningData.getPrefix());
      else
         fileinfo.setPrefix(screeningData.getPrefix());
      collect_request.setFileinfo(fileinfo);
      edm.setDirectory(fileinfo.getDirectory());

      sample_reference = new Sample_reference();

      if (screeningData.getBarCode() != null)
      {
         sample_reference.setCode(screeningData.getBarCode());
      }
      try
      {
         if (screeningData.getLocation() != null)
         {
            StringTokenizer tokenizer = new StringTokenizer(
               screeningData.getLocation());

            sample_reference.setContainer_reference(tokenizer.nextToken());
            sample_reference.setSample_location(tokenizer.nextToken());
         }
      }
      catch (Exception ex)
      {
      }

      if (screeningData.getBlSampleId() != null)
      {
         sample_reference.setBlSampleId(screeningData.getBlSampleId().intValue());
      }

      collect_request.setSample_reference(sample_reference);

      collect_reference_request = new Collect_reference_request();

      collect_reference_request.setArchive_reference_images(achive_reference_images);

      oscillation_sequence.setStart(0.0);
      oscillation_sequence.setRange(Double.parseDouble(oscillation.getText()));
      edm.setIncrement(oscillation_sequence.getRange());
      oscillation_sequence.setExposure_time(Double.parseDouble(time.getText()));
      edm.setTime(oscillation_sequence.getExposure_time());
      collect_request.addOscillation_sequence(oscillation_sequence);
      double resolutionValue = Double.parseDouble(screeningData.getResolution());
      if (resolutionValue > 0)
      {
         collect_resolution.setUpper(resolutionValue);
         collect_request.setResolution(collect_resolution);
         edm.setResolution(resolutionValue);
      }
      else
      {
         new ErrorDialog(this, "Resolution must be > 0.",
            "Reference Images Panel");
      }
      collect_reference_request.setCollect_request(collect_request);
      characterize_crystal_request.setCollect_reference_request(collect_reference_request);
      characterize_crystal_request.setTarget(target);
      characterize_crystal_request.setAnomalous(edm.getAnomalous());
      edm.saveDNAConfiguration();

      return characterize_crystal_request;
   }

   SampleScreeningDataPanel getScreeningDataPanel()
   {
      return screeningDataPanel;
   }

   private void activate(JButton button)
   {
      button.setEnabled(true);
   }

   private void deactivate(JButton button)
   {
      button.setEnabled(false);
   }

}
