package dna;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.text.DecimalFormat;
import java.text.FieldPosition;

import javax.swing.DefaultCellEditor;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.ChangeEvent;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.TableColumn;

import dna.observable.IObserver;
import dna.util.Debug;
import dna.util.DecimalField;
import dna.util.LeftRenderer;
import dna.xml.BLSample;
import dna.xml.Crystal;
import dna.xml.DiffractionPlan;
import dna.xml.Loaded_sample;
import dna.xml.Loaded_samples_response;
import dna.xml.Protein;
import dna.xml.Sample_reference;

public class SampleScreeningDataPanel
   extends JPanel
   implements MouseListener, IObserver
{
   private ExpertDataModel edm = ExpertDataModel.getInstance();
   private SampleScreeningTableModel screeningTableModel = new SampleScreeningTableModel();
   private JTable screeningTable = null;
   private DefaultTableColumnModel screeningColumnModel = new DefaultTableColumnModel();
   private TableColumn column = null;
   private LeftRenderer leftRenderer = new LeftRenderer();
   private Loaded_samples_response samples_response = new Loaded_samples_response();

   public SampleScreeningDataPanel()
   {
      screeningTable = new JTable(screeningTableModel);
      screeningTable.setAutoCreateColumnsFromModel(false);
      createTableColumnModel(screeningTableModel, screeningColumnModel);

      setupPanel(screeningTable, "Screening Strategy");
      edm.addIObserver(this);
   }

   private void setupPanel(JTable table, String title)
   {
      setLayout(new BorderLayout());

      table.setPreferredScrollableViewportSize(new Dimension(800, 70));
      table.setDefaultRenderer(String.class, leftRenderer);
      table.setDefaultRenderer(Double.class, leftRenderer);
      table.setDefaultRenderer(Integer.class, leftRenderer);
      setUpIntegerEditor(table);
      setUpDoubleEditor(table);
      JScrollPane scrollPane = new JScrollPane(table);

      add(new JLabel(title), BorderLayout.NORTH);
      add(scrollPane, BorderLayout.CENTER);
   }

   private void createTableColumnModel(AbstractTableModel tableModel,
      DefaultTableColumnModel columnModel)
   {
      for (int modelColumnNumber = 0; modelColumnNumber < SampleScreeningData.NUMBER_OF_COLUMNS; modelColumnNumber++)
      {
         column = new TableColumn(modelColumnNumber);
         column.setHeaderValue(tableModel.getColumnName(modelColumnNumber));
         switch (modelColumnNumber)
         {
            case SampleScreeningData.CELL:
               column.setMinWidth(250);
               column.setMaxWidth(250);
               break;
            case SampleScreeningData.PREFIX:
               column.setMinWidth(150);
               break;
            case SampleScreeningData.BAR_CODE:
               column.setMinWidth(125);
               column.setMaxWidth(125);
               break;
            case SampleScreeningData.LOCATION:
               column.setMinWidth(125);
               column.setMaxWidth(125);
               break;
            case SampleScreeningData.RSYM:
            case SampleScreeningData.RESO_REQ:
               column.setMinWidth(60);
               column.setMaxWidth(60);
               break;
            case SampleScreeningData.SCREEN:
               column.setMinWidth(40);
               column.setMaxWidth(40);
               break;
         }
         columnModel.addColumn(column);
      }

      screeningTable.setColumnModel(columnModel);
   }

   public SampleScreeningData getScreeningData(int index)
   {
      return screeningTableModel.getScreeningData(index);
   }

   public void setDataArraySize(int count)
   {
      screeningTableModel.setDataArraySize(count);
   }

   public int getDataArraySize()
   {
      return screeningTableModel.getRowCount();
   }

   private void setUpDoubleEditor(JTable table)
   {
      final DecimalField doubleField = new DecimalField(0.0, 16);
      doubleField.addMouseListener(this);
      DefaultCellEditor doubleEditor = new DefaultCellEditor(doubleField)
      {
         // Override DefaultCellEditor's getCellEditorValue method
         // to return a Double, not a String:
         public Object getCellEditorValue()
         {
            return new Double(doubleField.getValue());
         }
      };
      table.setDefaultEditor(Double.class, doubleEditor);
   }

   private void setUpIntegerEditor(JTable table)
   {
      final DecimalField integerField = new DecimalField(16, 16, 0);
      integerField.addMouseListener(this);
      DefaultCellEditor integerEditor = new DefaultCellEditor(integerField)
      {
         // Override DefaultCellEditor's getCellEditorValue method
         // to return an Integer, not a String:
         public Object getCellEditorValue()
         {
            return new Integer((int) integerField.getValue());
         }
      };
      table.setDefaultEditor(Integer.class, integerEditor);
   }

   private void initColumnSizes(JTable table, StrategyTableModel model)
   {
      TableColumn column = null;
      Component comp = null;
      int headerWidth = 0;
      int cellWidth = 0;

      for (int i = 0; i < StrategyData.getColumnCount(); i++)
      {
         column = table.getColumnModel().getColumn(i);

         try
         {
            comp = column.getHeaderRenderer().getTableCellRendererComponent(
               null, column.getHeaderValue(), false, false, 0, 0);
            headerWidth = comp.getPreferredSize().width;
         }
         catch (NullPointerException e)
         {
         }

         cellWidth = 8;
         column.setPreferredWidth(Math.max(headerWidth, cellWidth));
      }
   }

   // MouseListener

   public void mouseClicked(MouseEvent e)
   {
   }

   public void mouseEntered(MouseEvent e)
   {
   }

   public void mouseExited(MouseEvent e)
   {
      screeningTable.clearSelection();
      screeningTable.editingStopped(new ChangeEvent(this));
   }

   public void mousePressed(MouseEvent e)
   {
   }

   public void mouseReleased(MouseEvent e)
   {
   }

   // IObserver

   public void update(Object iObservable, Object arg)
   {
      if (arg instanceof ExpertState)
      {
         ExpertState state = (ExpertState) arg;

         switch (state.getState())
         {
            case ExpertState.COLLECTING_REFERENCE_IMAGES:
            case ExpertState.INDEXING:
            case ExpertState.CALCULATING_STRATEGY:
            case ExpertState.CHARACTERIZING:
            {
               setDataArraySize(0);
            }
               break;
         }
      }
      // else if (arg instanceof Proposal)
      // {
      // Proposal proposal = (Proposal) arg;
      // SampleScreeningData screen;
      // /*
      // * Replace this code when missing executive database operations are in
      // * place. Until the simulate by creating array of samples.
      // *
      // * */
      // try
      // {
      // loaded_samples_request = new Loaded_samples_request();
      // loaded_samples_request.setProposal(proposal);
      // Debug.out("Trying to send loaded_samples_request", 1);
      // dbHelper.sendLoaded_samples_request(loaded_samples_request);
      // samples_response = null;
      // }
      // catch (CollectException ex)
      // {
      // System.out.println("CollectException caught: " + ex.getMessage());
      // }
      // }
   }

   public void updateSamples(Loaded_samples_response the_samples_response,
      boolean setScreen)
   {
      Debug.out("In updateSamples!", 1);
      samples_response = the_samples_response;
      int sampleCount = samples_response.getLoaded_sampleCount();
      for (int i = 0; i < sampleCount; i++)
      {
         setDataArraySize(i + 1);
         updateTableData(getScreeningData(i),
            samples_response.getLoaded_sample(i), setScreen);
      }
   }

   private void updateTableData(SampleScreeningData screen,
      Loaded_sample loaded_sample, boolean setScreen)
   {
      BLSample blSample = loaded_sample.getBLSample();
      Protein protein = loaded_sample.getProtein();
      Crystal crystal = loaded_sample.getCrystal();
      DiffractionPlan diffractionPlan = loaded_sample.getDiffractionPlan();
      Sample_reference sampleReference = loaded_sample.getSample_reference();
      StringBuffer cell = new StringBuffer();
      DecimalFormat format = new DecimalFormat("0.000 ");
      DecimalFormat format2 = new DecimalFormat("0.0 ");
      FieldPosition f = new FieldPosition(0);
      screen.setBlSampleId(blSample.getBlSampleId());
      screen.setScreen(new Boolean(setScreen));
      format.format(crystal.getCell_a(), cell, f);
      format.format(crystal.getCell_b(), cell, f);
      format.format(crystal.getCell_c(), cell, f);
      format2.format(crystal.getCell_alpha(), cell, f);
      format2.format(crystal.getCell_beta(), cell, f);
      format2.format(crystal.getCell_gamma(), cell, f);
      screen.setCell(cell.toString());
      screen.setPrefix(protein.getAcronym() + "-" + blSample.getName());
      if (crystal.getSpaceGroup() != null)
         screen.setSymmetry(crystal.getSpaceGroup());
      if (sampleReference != null)
      {
         if (sampleReference.getCode() != null)
         {
            screen.setBarCode(sampleReference.getCode());
         }

         if (sampleReference.getContainer_reference() != null)
         {
            screen.setLocation(sampleReference.getContainer_reference() + " "
               + sampleReference.getSample_location());
         }
         else
         {
            screen.setLocation("Id: " + blSample.getContainerId());
         }
      }
      else
      {
         screen.setBarCode(blSample.getCode());
      }
      if (diffractionPlan != null)
      {
         StringBuffer resolution = new StringBuffer();
         if ( diffractionPlan.getMinimalResolution() > 0.5 )
         {
        	 format2.format(diffractionPlan.getMinimalResolution(), resolution, f);
        	 screen.setResolution(resolution.toString());
         }
         else
         {
        	 screen.setResolution(edm.getResolution());
         }
      }
      else
      {
         screen.setResolution(edm.getResolution());
      }
   }

   public void selectAllSamples()
   {
      updateSamples(samples_response, true);
   }

   public void deselectAllSamples()
   {
      updateSamples(samples_response, false);
   }
}
