package dna;

import java.util.Observable;

public class SampleScreeningData
   extends Observable
{
   static final int SCREEN = 0;
   static final int PREFIX = 1;
   static final int CELL = 2;
   static final int RSYM = 3;
   static final int RESO_REQ = 4;
   static final int BAR_CODE = 5;
   static final int LOCATION = 6;
   static final int NUMBER_OF_COLUMNS = 7;

   private static final String COLUMN_NAMES[] =
      {new String("Screen"), new String("Prefix"), new String("Cell"),
         new String("Symmetry"), new String("Resolution"),
         new String("Bar Code"), new String("Location")};

   private Boolean screen;
   private String prefix = new String();
   private String cell = new String();
   private String symmetry = new String();
   private String resolution = new String();
   private String barCode = new String();
   private String location = new String();
   private Integer blSampleId = null;

   public SampleScreeningData()
   {
   }

   public static int getColumnCount()
   {
      return NUMBER_OF_COLUMNS;
   }

   public static String getColumnName(int column)
   {
      return COLUMN_NAMES[column];
   }

   // Object getters

   public Boolean getScreen()
   {
      return screen;
   }

   public String getPrefix()
   {
      return prefix;
   }

   public String getCell()
   {
      return cell;
   }

   public String getSymmetry()
   {
      return symmetry;
   }

   public String getResolution()
   {
      return resolution;
   }

   public String getBarCode()
   {
      return barCode;
   }

   public String getLocation()
   {
      return location;
   }

   public Integer getBlSampleId()
   {
      return blSampleId;
   }

   // Object setters

   public void setScreen(Boolean screen)
   {
      this.screen = screen;
      setChanged();
      notifyObservers(new Integer(SCREEN));
   }

   public void setPrefix(String prefix)
   {
      this.prefix = prefix;
      setChanged();
      notifyObservers(new Integer(PREFIX));
   }

   public void setCell(String cell)
   {
      this.cell = cell;
      setChanged();
      notifyObservers(new Integer(CELL));
   }

   public void setSymmetry(String symmetry)
   {
      this.symmetry = symmetry;
      setChanged();
      notifyObservers(new Integer(RSYM));
   }

   public void setResolution(String resolution)
   {
      this.resolution = resolution;
      setChanged();
      notifyObservers(new Integer(RESO_REQ));
   }

   public void setBarCode(String barCode)
   {
      this.barCode = barCode;
      setChanged();
      notifyObservers(new Integer(BAR_CODE));
   }

   public void setLocation(String location)
   {
      this.location = location;
      setChanged();
      notifyObservers(new Integer(LOCATION));
   }

   public void setBlSampleId(int blSampleId)
   {
      this.blSampleId = new Integer(blSampleId);
   }
}
