package dna;

import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;

import javax.swing.JButton;

import dna.observable.IObservable;
import dna.observable.IObserver;
import dna.observable.ObservableComponent;
import dna.util.Debug;
import dna.xml.Characterize_crystal_request;
import dna.xml.Collect_reference_request;
import dna.xml.Collect_reference_response;
import dna.xml.Collect_request;
import dna.xml.Detector;
import dna.xml.Fileinfo;
import dna.xml.Oscillation_sequence;
import dna.xml.Resolution;
import dna.xml.Target;
import dna.xml.types.Spacegroup;

public class ReferenceImagesPanel
   extends DNAInitialDataPanel
   implements IObservable, IObserver, ActionListener //, Runnable
{
   private static final int COLLECT = 0;
   private static final int CHARACTERIZE = 1;
   private static int operation;

   private ExpertDataModel edm = ExpertDataModel.getInstance();

   private ObservableComponent observableComponent = new ObservableComponent();

   private Fileinfo fileinfo = new Fileinfo();
   private Oscillation_sequence oscillation_sequence = new Oscillation_sequence();
   private Collect_request collect_request = new Collect_request();
   private Collect_reference_request collect_reference_request = new Collect_reference_request();
   private CollectHelper collectHelper = CollectHelper.getInstance();
   private Resolution collect_resolution = new Resolution();
//   private Bcm_parameters_request request = new Bcm_parameters_request();

   private Characterize_crystal_request characterize_crystal_request = new Characterize_crystal_request();
   private CharacterizeCrystalHelper characterizeCrystalHelper = CharacterizeCrystalHelper.getInstance();
   private Detector detector = new Detector();
   private Target target = new Target();
   private ArrayList <String> panelTitles = new ArrayList <String>();

   public ReferenceImagesPanel()
   {
      panelTitles.add("Collect parameters");
      panelTitles.add("Index and strategy parameters");
      setTitles(panelTitles);
      GridBagConstraints c = new GridBagConstraints();
      setLayout(new GridBagLayout());
      
      c.fill = GridBagConstraints.HORIZONTAL;
      c.gridy = GridBagConstraints.RELATIVE;

      initialiseSetupPanels();
      populateSetupPanels();
      populateButtonPanel();
      
      c.weightx = 1.0;
      c.weighty = 1.0;
      add (parametersPanel(), c);
      c.gridx = 0;
      add(buttonPanel, c);

      addIObserver(AutoIndexSolution.getReference());
      edm.addIObserver(this);
   }
   
  private void populateSetupPanels()
  {
      int collectComponentCount = 1;
      int strategyComponentCount = 1;
   
		/*
		 * try { Bcm_parameters_response response =
		 * collectHelper.sendBcm_parameters_requestSynchronous(request,
		 * edm.getStrategyTimeout()); } catch (CollectException e) {
		 * Debug.out("Time out making bcm parameters request."); }
		 */
		directory.setText(edm.getDirectory());
      addComponent(collectComponentCount++, "Directory", "",
         directory, "Collect parameters");
		prefix.setText(edm.getPrefix());
		addComponent(collectComponentCount++, "Prefix", edm
				.getPrefixPrefix(), prefix, "Collect parameters");
		addComponent(collectComponentCount++,
				"PUBLIC copy of ref. images", "", saveReferenceImages, "Collect parameters");

		if (edm.isRunNumberOn())
		{
			runNumber.setText(edm.getRunNumber());
			addComponent(collectComponentCount++,
					"Start Run Number", "", runNumber, "Collect parameters");
		}

		time.setText(edm.getTime());
		addComponent(collectComponentCount++, "Exposure Time", "",
				time, "Collect parameters");
		oscillation.setText(edm.getIncrement());
		addComponent(collectComponentCount++, "Oscillation", "",
				oscillation, "Collect parameters");
		resolution.setText(edm.getResolution());
		addComponent(collectComponentCount++, "Resolution", "",
				resolution, "Collect parameters");

		bravaisLattice.addIObserver(edm);
		addComponent(strategyComponentCount++, "Bravais Lattice",
				"", bravaisLattice, "Index and strategy parameters");
		minOscillation.setText(""+edm.getMinOscillation());
		addComponent(strategyComponentCount++,
				"Minimum Desired Oscillation", "", minOscillation, "Index and strategy parameters");
		multiplicity.setText(""+edm.getMultiplicity());
		addComponent(strategyComponentCount++, "Multiplicity", "",
				multiplicity, "Index and strategy parameters");
		addComponent(strategyComponentCount++, "Anomalous", "",
				anomalous, "Index and strategy parameters");

	}

   private void populateButtonPanel()
   {
      GridBagConstraints c = new GridBagConstraints();

      collect.setActionCommand("Collect");
      collect.addActionListener(this);
      characterize.setActionCommand("Characterize");
      characterize.addActionListener(this);

      buttonPanel.setLayout(new GridBagLayout());
      c.insets = new Insets(3, 5, 3, 5); // Top, Left, Bottom, Right
      c.gridx = GridBagConstraints.RELATIVE;
      c.gridy = 1;
      c.anchor = GridBagConstraints.CENTER;

      if (edm.isCollectOnlyOn())
         buttonPanel.add(collect, c);
      buttonPanel.add(characterize, c);
   }

   private void activate(JButton button)
   {
      button.setEnabled(true);
   }

   private void deactivate(JButton button)
   {
      button.setEnabled(false);
   }


   // IObservable

   public void addIObserver(IObserver anIObserver)
   {
      observableComponent.addIObserver(anIObserver);
   }

   public void deleteIObserver(IObserver anIObserver)
   {
      observableComponent.deleteIObserver(anIObserver);
   }

   public void deleteIObservers()
   {
      observableComponent.deleteIObservers();
   }

   // IObserver

   public void update(Object iObservable, Object arg)
   {
      if (arg instanceof ExpertState)
      {
         ExpertState state = (ExpertState) arg;

         switch (state.getState())
         {
            case ExpertState.IDLE:
            case ExpertState.ABORTED:
            {
               activate(collect);
               activate(characterize);
               break;
            }
            case ExpertState.COLLECTING_REFERENCE_IMAGES:
            case ExpertState.CHARACTERIZING:
            {
               deactivate(collect);
               deactivate(characterize);
               break;
            }
            case ExpertState.SAMPLE_RANKING_CHARACTERIZING_SINGLE_CRYSTAL:
            {
                deactivate(collect);
                deactivate(characterize);
                directory.setText(edm.getDirectory());
                prefix.setText(edm.getPrefix());
                if (edm.isRunNumberOn())
                {
                   runNumber.setText(edm.getRunNumber());
                }
                time.setText(edm.getTime());
                oscillation.setText(edm.getIncrement());
                resolution.setText(edm.getResolution());
                break;
            }
         }
      }
      else if (arg instanceof ExpertDataModel)
      {
         anomalous.setSelected(edm.getAnomalous());
         //minOscillation.setText(""+edm.getMinOscillation());
         //multiplicity.setText(""+edm.getMultiplicity());
     }
   }

   // ActionListener

   public void actionPerformed(ActionEvent ae)
   {
	   boolean goAhead = true;
	   
	   if ( edm.checkReferenceImageParameters() )
	   {
		   CheckParametersDialog dialog = new CheckParametersDialog(this);
		   if ( ! dialog.isOk() ) goAhead = false;
	   }

	   edm.setCheckReferenceImageParameters( false );

	   if ( goAhead )
	   {
		   edm.setAnomalous(anomalous.isSelected());
		   if (edm.isRunNumberOn())
		   {
			   runNum = Integer.parseInt(runNumber.getText());
		   }
		   else
		   {
			   runNum = 1;
		   }
		   edm.setRunNumber(runNum);
		   edm.setResolution(Double.parseDouble(resolution.getText()));
		   edm.setTime(Double.parseDouble(time.getText()));
		   edm.setFileinfo(directory.getText(), prefix.getText(), runNum, null);
           edm.setMinOscillation(Double.parseDouble(minOscillation.getText()));
           edm.setMultiplicity(Double.parseDouble(multiplicity.getText()));
		   
		   createCollectReferenceRequest();

		   if (ae.getActionCommand().equals("Collect"))
		   {
			   operation = COLLECT;
			   observableComponent.notifyIObservers(this, new ExpertState(
					   ExpertState.COLLECTING_REFERENCE_IMAGES));
			   //new Thread(this).start();
		         try
		         {
		            collectHelper.sendCollect_reference_request( collect_reference_request );
		         }
		         catch (CollectException ex)
		         {
		            MessagePanel messagePanel = MessagePanel.getInstance();
		            messagePanel.appendText("Error caught in Reference Images");
		            messagePanel.appendText(ex.getMessage());
		            new ErrorDialog(this, ex, "ReferenceImages");
		         }
			   ExpertDataModel.saveDNAConfiguration();
		   }
		   else if (ae.getActionCommand().equals("Characterize"))
		   {
			   operation = CHARACTERIZE;
			   observableComponent.notifyIObservers(this, new ExpertState(
					   ExpertState.CHARACTERIZING));
			   createCharacterizeCrystalRequest();
			   //new Thread(this).start();
		         try
		         {
		            characterizeCrystalHelper.sendCharacterize_crystal_request( characterize_crystal_request );
		         }
		         catch (CharacterizeCrystalException ex)
		         {
		            MessagePanel messagePanel = MessagePanel.getInstance();
		            messagePanel.appendText("Error caught in Characterizing");
		            messagePanel.appendText(ex.getMessage());
		            new ErrorDialog(this, ex, "CharacterizeCrystal");
		         }
			   ExpertDataModel.saveDNAConfiguration();
		   }
	   }
   }

   private void createCollectReferenceRequest()
   {
      fileinfo.setDirectory(directory.getText());
      if (edm.isPrefixingOn())
         fileinfo.setPrefix(edm.getPrefixPrefix() + prefix.getText());
      else
         fileinfo.setPrefix(prefix.getText());
      collect_request = new Collect_request();
      collect_request.setFileinfo(fileinfo);

      collect_reference_request = new Collect_reference_request();

      collect_reference_request.setArchive_reference_images(saveReferenceImages.isSelected());

      if (edm.isRunNumberOn())
      {
         fileinfo.setRun_number(Integer.parseInt(runNumber.getText()));
      }
      else
      {
         fileinfo.setRun_number(1);
      }

      oscillation_sequence.setStart(0.0);
      oscillation_sequence.setRange(Double.parseDouble(oscillation.getText()));
      oscillation_sequence.setExposure_time(Double.parseDouble(time.getText()));
      collect_request.addOscillation_sequence(oscillation_sequence);
      double resolutionValue = Double.parseDouble(resolution.getText());
      if (resolutionValue > 0)
      {
         collect_resolution.setUpper(resolutionValue);
         collect_request.setResolution(collect_resolution);
      }
      else
      {
         new ErrorDialog(this, "Resolution must be > 0.",
            "Reference Images Panel");
      }
      // Set the session id if available...
      if (edm.getSession() != null)
      {
         collect_request.setSessionId((edm.getSession()).getSessionId());
      }

      collect_reference_request.setCollect_request(collect_request);
   }

   private void createCharacterizeCrystalRequest()
   {
      characterize_crystal_request.setCollect_reference_request(collect_reference_request);
      target.setSymmetry(Spacegroup.valueOf(bravaisLattice.getText()));
      edm.setAnomalous(anomalous.isSelected());
      characterize_crystal_request.setAnomalous(edm.getAnomalous());
      characterize_crystal_request.setTarget(target);
      characterize_crystal_request.setMultiplicity(edm.getMultiplicity());
      characterize_crystal_request.setUser_desired_minimum_phi_oscillation(edm.getMinOscillation());
   }
}
   // Runnable
/*
   public void run()
   {
      if (operation == COLLECT)
      {
         try
         {
            Collect_reference_response collect_reference_response = collectHelper.sendCollect_reference_requestSynchronous(
               collect_reference_request, edm.getReferenceImagesTimeout());
         }
         catch (CollectException ex)
         {
            MessagePanel messagePanel = MessagePanel.getInstance();
            messagePanel.appendText("Error caught in Reference Images");
            messagePanel.appendText(ex.getMessage());
            new ErrorDialog(this, ex, "ReferenceImages");
         }
         finally
         {
            observableComponent.notifyIObservers(this, new ExpertState(
               ExpertState.IDLE));
         }
      }
      else if (operation == CHARACTERIZE)
      {
         try
         {
            int timeout = edm.getReferenceImagesTimeout()
               + edm.getAutoIndexTimeout() + edm.getStrategyTimeout();
            characterizeCrystalHelper.sendCharacterize_crystal_requestSynchronous(
               characterize_crystal_request, timeout);
         }
         catch (CharacterizeCrystalException ex)
         {
            MessagePanel messagePanel = MessagePanel.getInstance();
            messagePanel.appendText("Error caught in Characterizing");
            messagePanel.appendText(ex.getMessage());
            new ErrorDialog(this, ex, "CharacterizeCrystal");
         }
         finally
         {
            observableComponent.notifyIObservers(this, new ExpertState(
               ExpertState.IDLE));
         }
      }
   }
*/