package dna;

import java.io.File;

import javax.swing.JFileChooser;

import dna.observable.ObservableComponent;

public class ReferenceFileChooser
   extends JFileChooser
{
   private ExtensionFileFilter[] fileFilter = new ExtensionFileFilter[2];
   private ObservableComponent observableComponent = new ObservableComponent();
   private File[] filenames;
   private int status;
   private String approveButtonText = "Select";

   public ReferenceFileChooser(boolean quitButtonOn)
   {
      String[] extension =
         {"mar", "img"};
      String[] description =
         {"*.mar*", "*.img*"};

      for (int i = 0; i < description.length; i++)
      {
         fileFilter[i] = new ExtensionFileFilter(extension[i], description[i]);
         addChoosableFileFilter(fileFilter[i]);
      }
      setApproveButtonText(approveButtonText);
   }
}
