package dna;

import java.util.ArrayList;
import java.util.Observable;
import java.util.Observer;
import java.util.Vector;

import javax.swing.table.AbstractTableModel;

import dna.xml.DataRankProjectDNA;
import dna.xml.MagDRProject;

public class RankingTableModel
   extends AbstractTableModel
   implements Observer
{
   private static RankingTableModel tableModel = null;
   private int maxSequences = 10;
   private ArrayList data = new ArrayList(maxSequences);
   private static int oscillationCount;
   private RankingData rankingData;

   public RankingTableModel()
   {
      extendRankingData(0, maxSequences);
      tableModel = this;
   }

   public boolean isCellEditable(int row, int col)
   {
	   boolean value = false;
	   if (col == RankingData.COLLECT)
		   value = true;
	   return value;
   }

   public RankingData getRankingData(int index)
   {
      return (RankingData) data.get(index);
   }

   public static RankingTableModel getReference()
   {
      return tableModel;
   }

   public void setDataArraySize(int count)
   {
      if (count > maxSequences)
      {
         extendRankingData(maxSequences, count);
         maxSequences = count;
      }

      oscillationCount = count;
      fireTableDataChanged();
   }

   private void extendRankingData(int start, int end)
   {
      for (int i = start; i < end; i++)
      {
         rankingData = new RankingData();
         rankingData.addObserver(this);
         data.add(rankingData);
      }
   }

   // AbstractTableModel

   public Class getColumnClass(int c)
   {
      return getValueAt(0, c).getClass();
   }

   public int getColumnCount()
   {
      return RankingData.getColumnCount();
   }

   public int getRowCount()
   {
      return oscillationCount;
   }

   public String getColumnName(int column)
   {
      return RankingData.getColumnName(column);
   }

   public Object getValueAt(int row, int col)
   {
      Object value = new Double(-1.0);
      rankingData = (RankingData) data.get(row);

      switch (col)
      {
       	 case RankingData.COLLECT:
    	    value = rankingData.isCollect();
    	    break;
         case RankingData.PREFIX:
            value = rankingData.getPrefix();
            break;
         case RankingData.RANK:
            value = "" + (int) rankingData.getRank();
            break;
         case RankingData.INFORMATION:
            value = rankingData.getInformation();
            break;
      }

      return value;
   }

   public void setValueAt(Object value, int row, int col)
   {
      switch (col)
      {
       	 case RankingData.COLLECT:
     	    rankingData.setCollect((Boolean) value);
     	    break;
      }
   }
   // import and export projects

   public void importDataRankProjectDNA(DataRankProjectDNA dataRankProjectDNA)
   {
      RankingData rankingData = null;
      MagDRProject magDRProject = dataRankProjectDNA.getMagDRProject();
      int sampleCount = magDRProject.getDataCrystalCount();
      for (int i = 0; i < sampleCount; i++)
      {
         this.setDataArraySize(i + 1);
         rankingData = (RankingData) data.get(i);
         rankingData.setDataCrystal(magDRProject.getDataCrystal(i));
         rankingData.setCollect(new Boolean(false));
         // System.out.println( "Importing crystal "+i);
      }
      fireTableDataChanged();
   }

   public DataRankProjectDNA exportDataRankProjectDNA()
   {
      RankingData rankingData = null;
      DataRankProjectDNA dataRankProjectDNA = new DataRankProjectDNA();
      MagDRProject magDRProject = new MagDRProject();
      for (int i = 0; i < oscillationCount; i++)
      {
         rankingData = (RankingData) data.get(i);
         magDRProject.addDataCrystal(rankingData.getDataCrystal());
      }
      dataRankProjectDNA.setMagDRProject(magDRProject);
      return dataRankProjectDNA;
   }

   public Vector getSelectedRankingData()
   {
	  RankingData   rankingData = null;
	  Vector selectedRankingData = new Vector(0);
	  for (int i = 0; i < oscillationCount; i++)
	  {
	     rankingData = (RankingData) data.get(i);
	     if ( rankingData.isCollect().booleanValue() )
	     {
	        selectedRankingData.add( rankingData );
	     }
	  }
	  return selectedRankingData; 
   }
   
   // Observer

   public synchronized void update(Observable obs, Object col)
   {
      int i;

      for (i = 0; i < maxSequences; i++)
      {
         if ((RankingData) obs == (RankingData) data.get(i))
            break;
      }

      fireTableCellUpdated(i, ((Integer) col).intValue());
   }

}
