package dna;

import javax.swing.table.AbstractTableModel;

public class RankingResultTableModel extends AbstractTableModel
{

	private String[] columnNames = null;
	private RankingData[] rankingData = null;
	
	public RankingResultTableModel( String[] prefix, RankingData[] rankingData )
	{
		columnNames = new String[ prefix.length+1 ];
		columnNames[0] = "Parameter";
		for ( int i=0; i<prefix.length; i++)
		{
			columnNames[i+1] = prefix[i];
		}
		this.rankingData = rankingData;
	}
	
    public boolean isCellEditable( int row, int col )
	{
		return false;
	}
    public Class getColumnClass(int c)
    {
       return getValueAt(0, c).getClass();
    }

    public int getColumnCount()
    {
       return columnNames.length;
    }

    public String getColumnName(int column)
    {
       return this.columnNames[ column ];
    }


	public Object getValueAt( int row, int col )
	{
		Object value = new Double(-1.0);

		switch ( row )
			{
			case 0:
				if ( col == 0 )
					value = "Status";
				else
					value = rankingData[ col-1 ].getDataCrystal().getScreeningOutput().getStatusDescription();
				break;
			case 1:
				if ( col == 0 )
					value = "Resolution obtained";
				else
					value = rankingData[ col-1 ].getDataCrystal().getScreeningOutput().getResolutionObtained();
				break;
			case 2:
				if ( col == 0 )
					value = "Diffraction rings";
				else
					value = "" + rankingData[ col-1 ].getDataCrystal().getScreeningOutput().getDiffractionRings();
				break;
			case 3:
				if ( col == 0 )
					value = "Mosaicity";
				else
					value = rankingData[ col-1 ].getDataCrystal().getScreeningOutput().getMosaicity();
				break;
			case 4:
				if ( col == 0 )
					value = "No refl. rejected";
				else
					value = rankingData[ col-1 ].getDataCrystal().getScreeningOutput().getRejectedReflections();
				break;
			case 5:
				if ( col == 0 )
					value = "No spots found";
				else
					value = rankingData[ col-1 ].getDataCrystal().getScreeningOutput().getNumSpotsFound();
				break;
			case 6:
				if ( col == 0 )
					value = "No spots used";
				else
					value = rankingData[ col-1 ].getDataCrystal().getScreeningOutput().getNumSpotsUsed();
				break;
			case 7:
				if ( col == 0 )
					value = "No spots rejected";
				else
					value = rankingData[ col-1 ].getDataCrystal().getScreeningOutput().getNumSpotsRejected();
				break;
			case 8:
				if ( col == 0 )
					value = "Beam shift X";
				else
					value = rankingData[ col-1 ].getDataCrystal().getScreeningOutput().getBeamShiftX();
				break;
			case 9:
				if ( col == 0 )
					value = "Beam shift Y";
				else
					value = rankingData[ col-1 ].getDataCrystal().getScreeningOutput().getBeamShiftY();
				break;
			case 10:
				if ( col == 0 )
					value = "Spot dev. R";
				else
					value = rankingData[ col-1 ].getDataCrystal().getScreeningOutput().getSpotDeviationR();
				break;
			case 11:
				if ( col == 0 )
					value = "Spot dev theta";
				else
					value = rankingData[ col-1 ].getDataCrystal().getScreeningOutput().getSpotDeviationTheta();
				break;
			case 12:
				if ( col == 0 )
					value = "Space group";
				else
					value = rankingData[ col-1 ].getDataCrystal().getScreeningOutputLattice().getSpaceGroup();
				break;
			case 13:
				if ( col == 0 )
					value = "Unit cell a";
				else
					value = rankingData[ col-1 ].getDataCrystal().getScreeningOutputLattice().getUnitCell_a();
				break;
			case 14:
				if ( col == 0 )
					value = "Unit cell b";
				else
					value = rankingData[ col-1 ].getDataCrystal().getScreeningOutputLattice().getUnitCell_b();
				break;
			case 15:
				if ( col == 0 )
					value = "Unit cell c";
				else
					value = rankingData[ col-1 ].getDataCrystal().getScreeningOutputLattice().getUnitCell_c();
				break;
			case 16:
				if ( col == 0 )
					value = "Unit cell alpha";
				else
					value = rankingData[ col-1 ].getDataCrystal().getScreeningOutputLattice().getUnitCell_alpha();
				break;
			case 17:
				if ( col == 0 )
					value = "Unit cell beta";
				else
					value = rankingData[ col-1 ].getDataCrystal().getScreeningOutputLattice().getUnitCell_beta();
				break;
			case 18:
				if ( col == 0 )
					value = "Unit cell gamma";
				else
					value = rankingData[ col-1 ].getDataCrystal().getScreeningOutputLattice().getUnitCell_gamma();
				break;
			case 19:
				if ( col == 0 )
					value = "Strategy phi start";
				else
					value = rankingData[ col-1 ].getDataCrystal().getScreeningStrategy().getPhiStart();
				break;
			case 20:
				if ( col == 0 )
					value = "Strategy phi end";
				else
					value = rankingData[ col-1 ].getDataCrystal().getScreeningStrategy().getPhiEnd();
				break;
			case 21:
				if ( col == 0 )
					value = "Strategy phi rotation";
				else
					value = rankingData[ col-1 ].getDataCrystal().getScreeningStrategy().getRotation();
				break;
			case 22:
				if ( col == 0 )
					value = "Strategy no images";
				else
				{
					double phiStart = rankingData[ col-1 ].getDataCrystal().getScreeningStrategy().getPhiStart();
				    double phiEnd   = rankingData[ col-1 ].getDataCrystal().getScreeningStrategy().getPhiEnd();
					double rotation = rankingData[ col-1 ].getDataCrystal().getScreeningStrategy().getRotation();
					value = (int) (( phiEnd - phiStart) / rotation );
				}
				break;
			case 23:
				if ( col == 0 )
					value = "Strategy exp. time per image";
				else
					value = rankingData[ col-1 ].getDataCrystal().getScreeningStrategy().getExposureTime();
				break;
			case 24:
				if ( col == 0 )
					value = "Strategy total exp. time";
				else
				{
					double phiStart = rankingData[ col-1 ].getDataCrystal().getScreeningStrategy().getPhiStart();
					double phiEnd   = rankingData[ col-1 ].getDataCrystal().getScreeningStrategy().getPhiEnd();
					double rotation = rankingData[ col-1 ].getDataCrystal().getScreeningStrategy().getRotation();
					int noImages = (int) ( ( phiEnd - phiStart) / rotation);
					value = rankingData[ col-1 ].getDataCrystal().getScreeningStrategy().getExposureTime() * noImages;
				}
				break;
			case 25:
				if ( col == 0 )
					value = "Strategy resolution";
				else
					value = rankingData[ col-1 ].getDataCrystal().getScreeningStrategy().getResolution();
				break;
			}

		return value;
	}

	public int getRowCount()
    {
       return 26;
    }

}
