package dna;

import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.Toolkit;

import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;


public class RankingResultFrame extends JFrame
{

	private RankingTableModel rankingTableModel = null;
	private JTable rankingResultTable = null;
	private RankingResultTableModel rankingResultTableModel = null;
	private JPanel topPanel = new JPanel();
	private JPanel bottomPanel = new JPanel();
	
	public RankingResultFrame( RankingTableModel rankingTableModel, int[] selectedRows)
	{
		this.rankingTableModel = rankingTableModel;
		String prefix[] = new String[ selectedRows.length ];
		RankingData[] rankingData = new RankingData[ selectedRows.length ];
		for ( int i=0; i<selectedRows.length; i++ )
		{
			prefix[ i ] = (String) rankingTableModel.getValueAt( selectedRows[i], RankingData.PREFIX );
		    rankingData[ i ] = rankingTableModel.getRankingData( selectedRows[i] );
		}
		this.rankingResultTableModel = new RankingResultTableModel( prefix, rankingData );
		rankingResultTable = new JTable( this.rankingResultTableModel );
		JScrollPane scrollPane = new JScrollPane( rankingResultTable );
		//rankingResultTable.setPreferredScrollableViewportSize( new Dimension( 400, 400 ) );
		this.getContentPane().setLayout( new BorderLayout() );
		//this.topPanel.add( scrollPane );
		//this.getContentPane().add( topPanel, BorderLayout.CENTER );
		this.getContentPane().add( scrollPane, BorderLayout.CENTER );
		this.setSize( new Dimension( 200*( selectedRows.length + 1 ) , 460 ) );
		Toolkit tk = Toolkit.getDefaultToolkit();
		Dimension d = tk.getScreenSize();
	    this.setLocation( d.height/4, d.width/4 );
		this.setVisible( true );
	}
}
