package dna;

import java.util.Vector;

import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;

import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JPanel;

import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.Marshaller;
import org.exolab.castor.xml.Unmarshaller;
import org.exolab.castor.xml.ValidationException;

import dna.observable.IObservable;
import dna.observable.IObserver;
import dna.observable.ObservableComponent;
import dna.util.Debug;
import dna.util.TitleBorder;
import dna.xml.Characterize_crystal_request;
import dna.xml.Collect_automatically_request;
import dna.xml.Collect_reference_request;
import dna.xml.Collect_reference_response;
import dna.xml.Collect_request;
import dna.xml.DataExtended;
import dna.xml.DataRankProjectDNA;
import dna.xml.Rank_request;
import dna.xml.DataCrystal;
import dna.xml.Sample_reference;
import dna.xml.Target;
import dna.xml.types.Spacegroup;
import dna.xml.Fileinfo;
import dna.xml.Oscillation_sequence;
import dna.xml.Resolution;

public class RankingPanel 
	extends JPanel 
	implements IObservable, IObserver, ActionListener 
{

	private ExpertDataModel edm = ExpertDataModel.getInstance();
	private DbHelper dbHelper = DbHelper.getInstance();
	private JPanel topButtonPanel = new JPanel();
	private JPanel bottomButtonPanel = new JPanel();
	private RankingDataPanel rankingDataPanel = new RankingDataPanel();
	private ObservableComponent observableComponent = new ObservableComponent();
	private JButton rank = new JButton("Redo Rank");
	private RankingEngineSelector rankingEngineSelector;
	private JButton importProject = new JButton("Import Rank Project");
	private JButton exportProject = new JButton("Export Rank Project");
	private JButton characterizeCrystal = new JButton(
			"Characterize Single Crystal");
	private JButton collectAutomatically = new JButton("Collect Automatically");
	private File selectedFile;
	private CharacterizeCrystalHelper characterizeCrystalHelper = CharacterizeCrystalHelper.getInstance();
	private Characterize_crystal_request characterize_crystal_request = new Characterize_crystal_request();
	private CollectHelper collectHelper = CollectHelper.getInstance();

	public RankingPanel() 
	{
		GridBagConstraints c = new GridBagConstraints();
		setLayout(new GridBagLayout());
		setBorder(new TitleBorder("Sample ranking"));

		populateTopButtonPanel();
		populateBottomButtonPanel();

		c.fill = GridBagConstraints.NONE;
		c.gridx = 1;
		c.gridy = 0;
		c.weightx = 0.0;
		c.weighty = 0.0;
		c.insets = new Insets(0, 5, 0, 5); // Top, Left, Bottom, Right
		add(topButtonPanel, c);

		c.insets = new Insets(0, 5, 0, 5); // Top, Left, Bottom, Right
		c.gridx = 1;
		c.gridy = 1;
		c.weightx = 1.0;
		c.weighty = 1.0;
		c.fill = GridBagConstraints.BOTH;

		add(rankingDataPanel, c);

		c.fill = GridBagConstraints.NONE;
		c.gridx = 1;
		c.gridy = 2;
		c.weightx = 0.0;
		c.weighty = 0.0;
		c.insets = new Insets(0, 5, 2, 5); // Top, Left, Bottom, Right
		add(bottomButtonPanel, c);
		edm.addIObserver(this);
	}

	private void populateTopButtonPanel() 
	{
		GridBagConstraints c = new GridBagConstraints();

		rank.setActionCommand("Rank");
		rank.addActionListener(this);
		importProject.setActionCommand("Import Rank Project");
		importProject.addActionListener(this);
		exportProject.setActionCommand("Export Rank Project");
		exportProject.addActionListener(this);

		topButtonPanel.setLayout(new GridBagLayout());
		c.insets = new Insets(5, 5, 5, 5); // Top, Left, Bottom, Right
		c.gridx = GridBagConstraints.RELATIVE;
		c.gridy = 1;
		c.anchor = GridBagConstraints.CENTER;
		topButtonPanel.add(rank, c);
		topButtonPanel.add(importProject, c);
		topButtonPanel.add(exportProject, c);
	}

	private void populateBottomButtonPanel() 
	{
		GridBagConstraints c = new GridBagConstraints();

		String[][] availableRankEngines = new String[2][6];
		availableRankEngines[0][0] = "DREngineDataCollectionTime";
		availableRankEngines[1][0] = "Data collection time";
		availableRankEngines[0][1] = "DREngineResolutionMosaicity";
		availableRankEngines[1][1] = "Resolution and mosaicity";
		availableRankEngines[0][2] = "DREngineResolutionObtained";
		availableRankEngines[1][2] = "Resolution";
		availableRankEngines[0][3] = "DREngineMosaicity";
		availableRankEngines[1][3] = "Mosaicity";
		availableRankEngines[0][4] = "DREngineDataCollectionNumberImage";
		availableRankEngines[1][4] = "Number of images";
		availableRankEngines[0][5] = "DREngineSpotDeviationR";
		availableRankEngines[1][5] = "Spot deviation";
		//availableRankEngines[3][0] = "DREngineSpotsUsed";
		//availableRankEngines[4][0] = "DREngineSpotsFound";
		//availableRankEngines[5][0] = "DREngineSpotsRejected";
		rankingEngineSelector = new RankingEngineSelector(
			    availableRankEngines,
				this.dbHelper);

		characterizeCrystal.setActionCommand("Characterize Crystal");
		characterizeCrystal.addActionListener(this);
		collectAutomatically.setActionCommand("Collect Automatically");
		collectAutomatically.addActionListener(this);

		bottomButtonPanel.setLayout(new GridBagLayout());
		c.insets = new Insets(5, 5, 5, 5); // Top, Left, Bottom, Right
		c.gridx = GridBagConstraints.RELATIVE;
		c.gridy = 1;
		c.anchor = GridBagConstraints.CENTER;
		bottomButtonPanel.add(rankingEngineSelector, c);
		bottomButtonPanel.add(characterizeCrystal, c);
		bottomButtonPanel.add(collectAutomatically, c);
		// De-activate these button for the moment
		characterizeCrystal.setEnabled(false);
		collectAutomatically.setEnabled(false);
	}

	public void activate() 
	{
		rank.setEnabled(true);
		importProject.setEnabled(true);
		exportProject.setEnabled(true);
		characterizeCrystal.setEnabled(true);
		collectAutomatically.setEnabled(true);
	}

	public void deactivate() 
	{
		rank.setEnabled(false);
		importProject.setEnabled(false);
		exportProject.setEnabled(false);
		characterizeCrystal.setEnabled(false);
		collectAutomatically.setEnabled(false);
	}

	// IObservable

	public void addIObserver(IObserver anIObserver) 
	{
		observableComponent.addIObserver(anIObserver);
	}

	public void deleteIObserver(IObserver anIObserver) 
	{
		observableComponent.deleteIObserver(anIObserver);
	}

	public void deleteIObservers() 
	{
		observableComponent.deleteIObservers();
	}

	// IObserver

	public void update(Object iObservable, Object arg) 
	{
		if (arg instanceof ExpertState) {
			ExpertState state = (ExpertState) arg;

			switch (state.getState()) {
			case ExpertState.IDLE:
			case ExpertState.ABORTED:
				activate();
				break;
			case ExpertState.COLLECTING_REFERENCE_IMAGES:
				deactivate();
				break;
			}
		}
	}

	// ActionListener

	public void actionPerformed(ActionEvent ae) 
	{
		if (ae.getActionCommand().equals("Rank")) {
			try {
				Rank_request rank_request = new Rank_request();
				DataRankProjectDNA dataRankProjectDNA = rankingDataPanel
						.exportDataRankProjectDNA();
				rank_request.setDataRankProjectDNA(dataRankProjectDNA);
				dbHelper.sendRank_request(rank_request);
			} catch (CollectException ex) {
				System.out.println("CollectException caught: "
						+ ex.getMessage());
			}
		} else if (ae.getActionCommand().equals("Import Rank Project")) {
			RankingProjectFileChooser rankingProjectFileChooser = new RankingProjectFileChooser(
					true);

			rankingProjectFileChooser.setCurrentDirectory(new File(edm
					.getDirectory()));

			if (rankingProjectFileChooser.showDialog(getRootPane(), "Select") == JFileChooser.APPROVE_OPTION) {
				if ((selectedFile = rankingProjectFileChooser.getSelectedFile()) != null) {
					// System.out.println( "File selected: " + selectedFile);
					try {

						FileReader project_reader = new FileReader(selectedFile);
						DataRankProjectDNA dataRankProjectDNA = (DataRankProjectDNA) Unmarshaller
								.unmarshal(DataRankProjectDNA.class,
										project_reader);

						rankingDataPanel
								.importDataRankProjectDNA(dataRankProjectDNA);
					} catch (FileNotFoundException fex) {
						Debug.out("Rank data project file " + selectedFile
								+ " not found");
					} catch (MarshalException mex) {
						Debug
								.out("MarshallException whilst parsing data rank project file:"
										+ mex);
					} catch (ValidationException vex) {
						Debug
								.out("ValidationException whilst parsing data rank project file:"
										+ vex);

					}
				}
			}
		} else if (ae.getActionCommand().equals("Export Rank Project")) {
			RankingProjectFileChooser rankingProjectFileChooser = new RankingProjectFileChooser(
					true);

			rankingProjectFileChooser.setCurrentDirectory(new File(edm
					.getDirectory()));

			if (rankingProjectFileChooser.showDialog(getRootPane(), "Select") == JFileChooser.APPROVE_OPTION) {
				if ((selectedFile = rankingProjectFileChooser.getSelectedFile()) != null) {
					// System.out.println( "File selected: " + selectedFile);

					try {
						FileWriter writer = new FileWriter(selectedFile);
						DataRankProjectDNA dataRankProjectDNA = rankingDataPanel
								.exportDataRankProjectDNA();
						Marshaller.marshal((Object) dataRankProjectDNA, writer);
					} catch (FileNotFoundException fex) {
						Debug.out("Rank project file " + selectedFile
								+ " not found.");
					} catch (IOException ioex) {
						Debug
								.out("Error creating writer for rank project file "
										+ selectedFile);
					} catch (MarshalException mex) {
						Debug
								.out("MarshallException whilst parsing rank project file "
										+ mex);
					} catch (ValidationException vex) {
						Debug
								.out("ValidationException whilst parsing rank project file "
										+ vex);
					}
				}
			}

		} else if (ae.getActionCommand().equals("Characterize Crystal")) {
			System.out.println("DEBUG: Characterize crystal button pressed");
			Vector selectedRankingData = rankingDataPanel
					.getSelectedRankingData();
			int noSelected = selectedRankingData.size();
			if (noSelected == 0) {
				ErrorDialog errorDialog = new ErrorDialog( this, "No sample selected for single crystal characterization!");
			} else if (noSelected > 1) {
				ErrorDialog errorDialog = new ErrorDialog( this, "More than one sample selected for single crystal characterization!");
			} else {
				deactivate();
				RankingData rankingData = (RankingData) selectedRankingData
						.firstElement();
				DataExtended dataExtended = rankingData.getDataExtended();

				this.characterize_crystal_request = dataExtended
						.getCharacterize_crystal_request();
				
				this.characterize_crystal_request.getCollect_reference_request().getCollect_request().setKeep_sample_loaded( true );
				edm.setCharacterize_crystal_request( this.characterize_crystal_request );
								
				observableComponent.notifyIObservers(this, new ExpertState(
						   ExpertState.SAMPLE_RANKING_CHARACTERIZING_SINGLE_CRYSTAL));
				try {
					characterizeCrystalHelper
							.sendCharacterize_crystal_request(
									this.characterize_crystal_request );
				} catch (Exception ex) {
					MessagePanel messagePanel = MessagePanel.getInstance();
					messagePanel.appendText("Error caught in Characterizing");
					messagePanel.appendText(ex.getMessage());
					new ErrorDialog(this, ex, "CharacterizeCrystal");
				} 
			}

		} else if (ae.getActionCommand().equals("Collect Automatically")) {
			System.out.println("DEBUG: Collect automatically button pressed");
			Vector selectedRankingData = rankingDataPanel.getSelectedRankingData();
			int noSelected = selectedRankingData.size();
			if (noSelected == 0) {
				ErrorDialog errorDialog = new ErrorDialog( this, "No sample(s) selected for automatic data collection!" );
			} else {
				deactivate();
				Collect_automatically_request collect_automatically_request = new Collect_automatically_request();
				for (int i=0; i<noSelected; i++)
				{
					RankingData rankingData = (RankingData) selectedRankingData.elementAt( i );
					DataExtended dataExtended = rankingData.getDataExtended();
		
				    characterize_crystal_request = dataExtended.getCharacterize_crystal_request();
					
					characterize_crystal_request.getCollect_reference_request().getCollect_request().setKeep_sample_loaded( true );
					collect_automatically_request.addCharacterize_crystal_request( characterize_crystal_request );
					
					if (i == 0)
					{
					  edm.setCharacterize_crystal_request( characterize_crystal_request );
					}
				}				
				
				observableComponent.notifyIObservers(this, new ExpertState(
							   ExpertState.SAMPLE_RANKING_COLLECT_AUTOMATICALLY));
				try {
					collectHelper.sendCollect_automatically_request( collect_automatically_request );
				} catch (Exception ex) {
						MessagePanel messagePanel = MessagePanel.getInstance();
						messagePanel.appendText("Error caught in Characterizing");
						messagePanel.appendText(ex.getMessage());
						new ErrorDialog(this, ex, "CharacterizeCrystal");
				} 
			}
		}

	}

	public RankingDataPanel getRankingDataPanel() 
	{
		return rankingDataPanel;
	}


}
