package dna;

import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;

import javax.swing.JButton;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;

import dna.observable.IObservable;
import dna.observable.IObserver;
import dna.observable.ObservableComponent;
import dna.xml.Set_rank_engine_request;

public class RankingEngineSelector
   extends JButton
   implements MouseListener, ActionListener, IObservable
{

   JPopupMenu popup = new JPopupMenu();
   JMenuItem mi;
   Dimension size;
   private DbHelper dbHelper;
   private String[][] rankEngineAvailable = null;

   private ObservableComponent observableComponent = new ObservableComponent();

   public RankingEngineSelector( String[][] rankEngineAvailable, DbHelper the_dbHelper)
   {
      super(rankEngineAvailable[1][0]);
      this.rankEngineAvailable = rankEngineAvailable;
      size = getPreferredSize();
      addMouseListener(this);
      this.dbHelper = the_dbHelper;

      for (int i = 0; i < this.rankEngineAvailable[1].length; i++)
      {
         mi = new JMenuItem(rankEngineAvailable[1][i]);
         mi.setActionCommand(rankEngineAvailable[1][i]);
         mi.addActionListener(this);
         popup.add(mi);
      }
   }

   // MouseListener

   public void mouseClicked(MouseEvent me)
   {
   }

   public void mouseEntered(MouseEvent me)
   {
   }

   public void mouseExited(MouseEvent me)
   {
   }

   public void mousePressed(MouseEvent me)
   {
      // System.out.println("DEBUG: mousePressed");
      popup.show(me.getComponent(), me.getX(), me.getY());
   }

   public void mouseReleased(MouseEvent me)
   {
   }

   // ActionListener

   public void actionPerformed(ActionEvent ae)
   {
      String selection = ae.getActionCommand();
      // System.out.println("DEBUG: selection = "+selection);
      setText(selection);
      setPreferredSize(size);
      //JMenuItem jmi = (JMenuItem) ae.getSource();
      Set_rank_engine_request set_rank_engine_request = new Set_rank_engine_request();
      String rankEngine = null;
      for (int i = 0; i < this.rankEngineAvailable[1].length; i++)
      {
    	  if ( this.rankEngineAvailable[1][i].equals( selection ) )
    	  {
    		  rankEngine = rankEngineAvailable[0][i];
    	  }
      }
      set_rank_engine_request.setRankEngine(rankEngine);
      try
      {
         dbHelper.sendSet_rank_engine_request(set_rank_engine_request);
      }
      catch (CollectException ex)
      {
         System.out.println("CollectException caught: " + ex.getMessage());
      }
      // if (!jmi.getActionCommand().equals(unknown))
      // observableComponent.notifyIObservers(this, jmi.getActionCommand());
      // else
      // observableComponent.notifyIObservers(this, null);
   }

   // IObservable

   public void addIObserver(IObserver anIObserver)
   {
      observableComponent.addIObserver(anIObserver);
   }

   public void deleteIObserver(IObserver anIObserver)
   {
      observableComponent.deleteIObserver(anIObserver);
   }

   public void deleteIObservers()
   {
      observableComponent.deleteIObservers();
   }
}
