package dna;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Vector;

import javax.swing.DefaultCellEditor;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.ChangeEvent;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.TableColumn;

import dna.observable.IObserver;
import dna.util.Debug;
import dna.util.DecimalField;
import dna.util.LeftRenderer;
import dna.xml.DataRankProjectDNA;

public class RankingDataPanel
   extends JPanel
   implements MouseListener, IObserver
{
   private ExpertDataModel edm = ExpertDataModel.getInstance();
   private RankingTableModel rankingTableModel = new RankingTableModel();
   private JTable rankingTable = null;
   private DefaultTableColumnModel rankingColumnModel = new DefaultTableColumnModel();
   private TableColumn column = null;
   private LeftRenderer leftRenderer = new LeftRenderer();
   private DbHelper dbHelper = DbHelper.getInstance();

   public RankingDataPanel()
   {
      rankingTable = new JTable(rankingTableModel);
      rankingTable.setAutoCreateColumnsFromModel(false);
      createTableColumnModel(rankingTableModel, rankingColumnModel);
      
      setupPanel(rankingTable, "Ranking Results");
      edm.addIObserver(this);
      rankingTable.addMouseListener( this );
   }

   private void setupPanel(JTable table, String title)
   {

      setLayout(new BorderLayout());

      table.setPreferredScrollableViewportSize(new Dimension(800, 70));
      table.setDefaultRenderer(String.class, leftRenderer);
      table.setDefaultRenderer(Double.class, leftRenderer);
      table.setDefaultRenderer(Integer.class, leftRenderer);
      setUpIntegerEditor(table);
      setUpDoubleEditor(table);
      JScrollPane scrollPane = new JScrollPane(table);

      add(new JLabel(title), BorderLayout.NORTH);
      add(scrollPane, BorderLayout.CENTER);
   }

   private void createTableColumnModel(AbstractTableModel tableModel,
      DefaultTableColumnModel columnModel)
   {

      for (int modelColumnNumber = 0; modelColumnNumber < RankingData.NUMBER_OF_COLUMNS; modelColumnNumber++)
      {
         column = new TableColumn(modelColumnNumber);
         column.setHeaderValue(tableModel.getColumnName(modelColumnNumber));
         switch (modelColumnNumber)
         {
         	case RankingData.COLLECT:
         		column.setMinWidth(40);
         		column.setMaxWidth(40);
         		break;
            case RankingData.RANK:
               column.setMinWidth(40);
               column.setMaxWidth(40);
               break;
            case RankingData.PREFIX:
               column.setMinWidth(300);
               column.setMaxWidth(300);
               break;
            case RankingData.INFORMATION:
               column.setMinWidth(500);
               //column.setMaxWidth(500);
               break;
         }
         columnModel.addColumn(column);
      }

      rankingTable.setColumnModel(columnModel);
   }

   public RankingData getRankingData(int index)
   {
      return rankingTableModel.getRankingData(index);
   }

   public void setDataArraySize(int count)
   {
      rankingTableModel.setDataArraySize(count);
   }

   public int getDataArraySize()
   {
      return rankingTableModel.getRowCount();
   }

   private void setUpDoubleEditor(JTable table)
   {
      final DecimalField doubleField = new DecimalField(0.0, 16);
      doubleField.addMouseListener(this);
      DefaultCellEditor doubleEditor = new DefaultCellEditor(doubleField)
      {
         // Override DefaultCellEditor's getCellEditorValue method
         // to return a Double, not a String:
         public Object getCellEditorValue()
         {
            return new Double(doubleField.getValue());
         }
      };
      table.setDefaultEditor(Double.class, doubleEditor);
   }

   private void setUpIntegerEditor(JTable table)
   {
      final DecimalField integerField = new DecimalField(16, 16, 0);
      integerField.addMouseListener(this);
      DefaultCellEditor integerEditor = new DefaultCellEditor(integerField)
      {
         // Override DefaultCellEditor's getCellEditorValue method
         // to return an Integer, not a String:
         public Object getCellEditorValue()
         {
            return new Integer((int) integerField.getValue());
         }
      };
      table.setDefaultEditor(Integer.class, integerEditor);
   }

   private void initColumnSizes(JTable table, StrategyTableModel model)
   {
      TableColumn column = null;
      Component comp = null;
      int headerWidth = 0;
      int cellWidth = 0;

      for (int i = 0; i < StrategyData.getColumnCount(); i++)
      {
         column = table.getColumnModel().getColumn(i);

         try
         {
            comp = column.getHeaderRenderer().getTableCellRendererComponent(
               null, column.getHeaderValue(), false, false, 0, 0);
            headerWidth = comp.getPreferredSize().width;
         }
         catch (NullPointerException e)
         {
         }

         cellWidth = 8;
         column.setPreferredWidth(Math.max(headerWidth, cellWidth));
      }
   }

   // MouseListener

   public void mouseClicked(MouseEvent e)
   {
	   if ( e.getClickCount() == 1 && e.getButton() == e.BUTTON3 )
	   {
		  RankingResultFrame rankingResultFrame = new RankingResultFrame( rankingTableModel, rankingTable.getSelectedRows() );   
	   }
	   else if ( e.getClickCount() == 2 )
	   {
           //expertCollectPanel.updateProgress(url);
		   //observableComponent.notifyIObservers(this, new ExpertState(
           //        ExpertState.DISPLAY_INDEXING_SOLUTION));
	   }
   }

   public void mouseEntered(MouseEvent e)
   {
   }

   public void mouseExited(MouseEvent e)
   {
      //rankingTable.clearSelection();
      //rankingTable.editingStopped(new ChangeEvent(this));
   }

   public void mousePressed(MouseEvent e)
   {
   }

   public void mouseReleased(MouseEvent e)
   {
   }

   // IObserver

   public void update(Object iObservable, Object arg)
   {
      if (arg instanceof ExpertState)
      {
         ExpertState state = (ExpertState) arg;

         /*
          * switch (state.getState()) { case
          * ExpertState.COLLECTING_REFERENCE_IMAGES: case ExpertState.INDEXING:
          * case ExpertState.CALCULATING_STRATEGY: case
          * ExpertState.CHARACTERIZING: { setDataArraySize(0); } break; }
          */
      }
   }

   public void importDataRankProjectDNA(DataRankProjectDNA dataRankProjectDNA)
   {
      Debug.out("In RankingDataPanel:importDataRankProjectDNA!", 1);
      rankingTableModel.importDataRankProjectDNA(dataRankProjectDNA);
   }

   public DataRankProjectDNA exportDataRankProjectDNA()
   {
      return rankingTableModel.exportDataRankProjectDNA();
   }

   public Vector getSelectedRankingData()
   {
	   return rankingTableModel.getSelectedRankingData();
}
}
