package dna;

import java.io.StringReader;
import java.util.Observable;

import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.Unmarshaller;
import org.exolab.castor.xml.ValidationException;

import dna.util.Debug;
import dna.xml.Characterize_crystal_request;
import dna.xml.DataCrystal;
import dna.xml.DataExtended;

public class RankingData extends Observable
{

	static final int COLLECT = 0;
	static final int RANK = 1;
	static final int PREFIX = 2;
	static final int INFORMATION = 3;
	static final int NUMBER_OF_COLUMNS = 4;

	private static final String COLUMN_NAMES[] = { new String("Collect"),
			new String("Rank"), new String("Prefix"), new String("Information") };
	private DataCrystal dataCrystal = null;
	private Boolean m_isCollect = null;
	private Boolean m_hasRings = null;
	private DataExtended dataExtended = null;

	public RankingData() 
	{
	}

	public static int getColumnCount()
	{
		return NUMBER_OF_COLUMNS;
	}

	public static String getColumnName( int column )
	{
		return COLUMN_NAMES[column];
	}

	// Object getters

	public Boolean isCollect()
	{
		return m_isCollect;
	}

	public String getPrefix()
	{
		return this.dataExtended.getCharacterize_crystal_request()
				.getCollect_reference_request().getCollect_request()
				.getFileinfo().getPrefix();
	}

	public double getRank()
	{
		return dataCrystal.getDataRank().getRankValue();
	}

	public String getInformation()
	{
		return dataCrystal.getDataRank().getRankInformation();
	}

	public DataCrystal getDataCrystal()
	{
		return dataCrystal;
	}

	// Object setters

	public void setCollect( Boolean the_isCollect )
	{
		m_isCollect = the_isCollect;
	}

	public String unescapeXML( String _ostrXMLEscaped )
	{
		String ostrXML = new String(_ostrXMLEscaped);
		ostrXML = ostrXML.replaceAll("&lt;", "<");
		ostrXML = ostrXML.replaceAll("&gt;", ">");
		ostrXML = ostrXML.replaceAll("&amp;", "&");
		return ostrXML;
	}

	public void setDataCrystal( DataCrystal the_dataCrystal )
	{
		this.dataCrystal = the_dataCrystal;
		String dataExtendedXMLEscaped = this.dataCrystal.getDataExtendedXML();
		String dataExtendedXML = this.unescapeXML(dataExtendedXMLEscaped);
		StringReader reader = new StringReader(dataExtendedXML);
		// System.out.println( dataExtendedXML );
		try
		{
			this.dataExtended = (DataExtended) Unmarshaller.unmarshal(
					DataExtended.class, reader);
		} catch (Exception ex)
		{
			System.out.println(dataExtendedXML);
			System.out.println("MarshalException in "
					+ "RankingData.setDataCrystal: " + ex);
		}
		setChanged();
		// notifyObservers(new Integer(CRYSTAL_DATA));
	}

	public DataExtended getDataExtended()
	{
		return this.dataExtended;
	}

}
