package dna;

import java.awt.Color;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;

import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;

/**
 * Displays time through any operation on a progress bar within a JPanel
 * 
 */

public class ProgressPanel
   extends JPanel
{
   private boolean flag;
   private JProgressBar jProgressBar = null;
   private int maxValue = 100;
   private String title = "% Done";
   Border border;
   private Color backgroundColor;
   private Color foregroundColor;
   private static ProgressPanel progressPanel = null;

   public ProgressPanel()
   {
      this(" % Done ", 100);
   }

   public ProgressPanel(String title)
   {
      this(title, 100);
   }

   public ProgressPanel(String title, int maxValue)
   {
      jProgressBar = new JProgressBar();
      setProgressBarBackground(Color.gray);
      setProgressBarForeground(Color.green);
      jProgressBar.setOrientation(JProgressBar.HORIZONTAL);
      jProgressBar.setMinimum(0);
      jProgressBar.setMaximum(maxValue);
      jProgressBar.setBorderPainted(true);
      jProgressBar.setStringPainted(true);
      jProgressBar.setValue(0);
      this.setLayout(new GridBagLayout());
      GridBagConstraints c = new GridBagConstraints();
      c.weightx = 1.0;
      c.gridx = 0;
      c.gridy = GridBagConstraints.RELATIVE;
      c.anchor = GridBagConstraints.SOUTH;
      c.gridwidth = 500;
      c.fill = GridBagConstraints.HORIZONTAL;

      add(jProgressBar, c);

      border = BorderFactory.createEtchedBorder();
      setBorder(BorderFactory.createTitledBorder(border, title,
         TitledBorder.TOP, TitledBorder.CENTER));
      progressPanel = this;
   }

   public static ProgressPanel getInstance()
   {
      if (progressPanel == null)
      {
         progressPanel = new ProgressPanel();
      }
      return progressPanel;
   }

   // Assumes method not called from within event scheduler
   public void setValue(int current)
   {
      final int value = current;
      jProgressBar.setValue(current);
      SwingUtilities.invokeLater(new Runnable()
      {
         public void run()
         {
            jProgressBar.setValue(value);
         }
      });
   }

   public void setMaximum(int fileSize)
   {
      SwingUtilities.invokeLater(new Runnable()
      {
         public void run()
         {
            jProgressBar.setMaximum(maxValue);
         }
      });
   }

   public void setTitle(String string)
   {
      title = string;
   }

   public void terminate()
   {
      SwingUtilities.invokeLater(new Runnable()
      {
         public void run()
         {
            setValue(0);
         }
      });

   }

   public void setProgressBarBackground(Color color)
   {
      backgroundColor = color;
      SwingUtilities.invokeLater(new Runnable()
      {
         public void run()
         {
            jProgressBar.setBackground(backgroundColor);
         }
      });

   }

   public void setProgressBarForeground(Color color)
   {
      foregroundColor = color;
      SwingUtilities.invokeLater(new Runnable()
      {
         public void run()
         {
            jProgressBar.setForeground(foregroundColor);
         }
      });
   }

   public void setBusy(boolean busyFlag)
   {
      flag = busyFlag;
      Thread thread = new Thread(new Runnable()
      {
         public void run()
         {
            int i;
            while (flag)
            {
               for (i = 0; i < 101; i++)
               {
                  try
                  {
                     Thread.sleep(25);
                     setValue(i);
                  }
                  catch (InterruptedException e)
                  {
                  }
               }

               for (i = 101; i >= 0; i--)
               {
                  try
                  {
                     Thread.sleep(25);
                     setValue(i);
                  }
                  catch (InterruptedException e)
                  {
                  }
               }
            }

         }
      });
      thread.start();
   }
}
