package dna;

import java.io.StringReader;

import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.Unmarshaller;
import org.exolab.castor.xml.ValidationException;

import dna.xml.Gui_display_url_request;

public class ProgressHelper
   implements ExpertListener
{
   private ExpertClientHTTPServer httpServer = ExpertClientHTTPServer.getGUIServer();
   private Gui_display_url_request gui_display_url_request = null;
   private String callbackStatus = "ok";
   private ExpertCollectPanel expertCollectPanel = null;

   public ProgressHelper(ExpertCollectPanel expertCollectPanel)
   {
      httpServer.addExpertListener(this);
      this.expertCollectPanel = expertCollectPanel;
   }

   public synchronized void expertMessage(ExpertXMLMessage the_message)
   {
      String path = the_message.getPath();
      String url = null;

      if (path.equals("/gui_display_url_request"))
      {
         String xml_message = the_message.getXMLMessage();
         StringReader reader = new StringReader(the_message.getXMLMessage());
         try
         {
            gui_display_url_request = (Gui_display_url_request) Unmarshaller.unmarshal(
               Gui_display_url_request.class, reader);
            url = gui_display_url_request.getUrl();
            System.out.println("URL requested = "
               + gui_display_url_request.getUrl());
            expertCollectPanel.updateProgress(url);
         }
         catch (MarshalException ex)
         {
            callbackStatus = "MarshalException in "
               + "ProgressHelper.expertMessage";
         }
         catch (ValidationException ex)
         {
            callbackStatus = "ValidationException in "
               + "ProgressHelper.expertMessage";
         }
      }
   }
}
