package dna;

import java.io.StringReader;
import java.io.StringWriter;

import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.Unmarshaller;
import org.exolab.castor.xml.ValidationException;

import dna.util.Debug;
import dna.util.Sleep;
import dna.xml.Bcm_parameters_response;
import dna.xml.Collect_request;
import dna.xml.Collect_response;

public class PXGENCollectHelper
   implements ExpertListener
{
   private ExpertProxy expertProxy = ExpertProxy.getInstance();

   private ExpertClientHTTPServer httpServer;
   private BCM bcm = BCM.getInstance();
   private Collect_request collect_request = new Collect_request();
   private Collect_response collect_response;

   public PXGENCollectHelper()
   {
      httpServer = ExpertClientHTTPServer.getBCMServer();
      httpServer.addExpertListener(this);
   }

   public synchronized void expertMessage(ExpertXMLMessage the_message)
   {
      String path = the_message.getPath();
      StringWriter stringWriter = new StringWriter();

      if (path.equals("/collect_request"))
      {
         String xml_message = the_message.getXMLMessage();
         Debug.out(xml_message, 2);
         StringReader reader = new StringReader(the_message.getXMLMessage());
         try
         {
            collect_request = (Collect_request) Unmarshaller.unmarshal(
               Collect_request.class, reader);

            collect_response = bcm.collect(collect_request);

            collect_response.marshal(stringWriter);
            String xml_string = stringWriter.toString();
            /*
             * Creation of messages in PXGEN++ BCM via Castor marshaling can
             * lead to single line messages formatting into multiple lines
             * containing spaces at the start of lines. For output into the
             * dialogs these spaces need purging.
             */
            xml_string = xml_string.replaceAll("  *", " ");
            expertProxy.sendToExpert("/collect_response", xml_string);
         }
         catch (MarshalException ex)
         {
            System.out.println("Marshal Exception");
         }
         catch (ValidationException ex)
         {
            System.out.println("Validation Exception");
         }
      }
      else if (path.equals("/bcm_parameters_request"))
      {
         try
         {
            Bcm_parameters_response bcm_parameters_response = bcm.getBCMParameters();

            bcm_parameters_response.marshal(stringWriter);
            String xml_string = stringWriter.toString();
            Debug.out("BCM_PARAMETERS\n" + xml_string, 1);
            if (httpServer.isSynchronous(the_message.getXMLMessage()))
            {
               httpServer.replyToExpert(xml_string);
            }
            else
            {
               Sleep.sleep(1000); // If not ES misses response!
               expertProxy.sendToExpert("/bcm_parameters_response", xml_string);
            }
         }
         catch (MarshalException ex)
         {
            System.out.println("Marshal Exception");
         }
         catch (ValidationException ex)
         {
            System.out.println("Validation Exception " + ex.getMessage());
         }
      }
   }
}
