package dna;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;

public class OutputDisplayer
   implements Runnable
{
   private String outputFile;
   private DnaMessageOutput messageOutput;
   private long length = 0;
   private long previousLength = 0;

   public OutputDisplayer(String outputFile, DnaMessageOutput messageOutput)
   {
      this.outputFile = outputFile;
      this.messageOutput = messageOutput;
   }

   public void run()
   {
      BufferedReader reader;
      String line;

      try
      {
         File mosflmOutput = new File(outputFile);
         while (!mosflmOutput.exists())
         {
            try
            {
               Thread.sleep(1000);
            }
            catch (InterruptedException ex)
            {
            }
         }

         reader = new BufferedReader(new FileReader(outputFile));
         while (reader.readLine() != null);

         while (true)
         {
            length = mosflmOutput.length();

            if (length < previousLength)
            {
               if (mosflmOutput.exists())
               {
                  reader.close();
                  reader = new BufferedReader(new FileReader(outputFile));
                  length = previousLength = 0;
               }
               else
               {
                  try
                  {
                     Thread.sleep(1000);
                  }
                  catch (InterruptedException ex)
                  {
                  }
               }
            }
            else
            {
               line = reader.readLine();
               if (line != null)
               {
                  messageOutput.appendText(line);
               }
               else
               {
                  try
                  {
                     Thread.sleep(1000);
                  }
                  catch (InterruptedException ex)
                  {
                  }
               }
               previousLength = length;
            }
         }
      }
      catch (IOException ex)
      {
         System.out.println("Exception : " + ex.getMessage());
      }
   }
}
