package dna;

import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;

import javax.swing.JPanel;
import javax.swing.JTabbedPane;

public class MessagePanel
   extends JPanel
{
   private static MessagePanel messagePanel = null;

   private JTabbedPane pane = new JTabbedPane();
   private ExpertDataModel edm = ExpertDataModel.getInstance();

   private final int EXPERT_MESSAGE_TAB = 0;
   private final int MOSFLM_MESSAGE_TAB = 1;

   private DnaMessageOutput expertOutput = new DnaMessageOutput();
   private DnaMessageOutput mosflmOutput = new DnaMessageOutput();

   private MessagePanel()
   {
      setLayout(new GridBagLayout());
      GridBagConstraints c = new GridBagConstraints();

      ExpertClientHTTPServer.getGUIServer().addExpertListener(expertOutput);

      pane.add(expertOutput, EXPERT_MESSAGE_TAB);
      pane.setTitleAt(EXPERT_MESSAGE_TAB, "Executive Output");
      pane.add(mosflmOutput, MOSFLM_MESSAGE_TAB);
      pane.setTitleAt(MOSFLM_MESSAGE_TAB, "MOSFLM Output");
      String mosflmLogFile = edm.getDPMLogFile();
      (new Thread(new OutputDisplayer(mosflmLogFile, mosflmOutput))).start();

      c.fill = GridBagConstraints.BOTH;
      c.weightx = 1.0;
      c.weighty = 1.0;
      add(pane, c);
      messagePanel = this;
   }

   public static MessagePanel getInstance()
   {
      if (messagePanel == null)
         messagePanel = new MessagePanel();

      return messagePanel;
   }

   public void appendText(String text)
   {
      expertOutput.appendText(text);
   }
}
