package dna;

import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;

import dna.observable.IObservable;
import dna.observable.IObserver;
import dna.observable.ObservableComponent;
import dna.util.Debug;
import dna.util.TitleBorder;
import dna.xml.Proposal;
import dna.xml.Proposal_response;
import dna.xml.Session;

public class LoginPanel
   extends JPanel
   implements ActionListener, IObservable, IObserver
{
   private ExpertDataModel edm = ExpertDataModel.getInstance();
   private ExpertClientHTTPServer httpServer = ExpertClientHTTPServer.getGUIServer();
   private DbHelper dbHelper = DbHelper.getInstance();

   private JPanel setupPanel = new JPanel();
   private JPanel leftSetupPanel = new JPanel();
   private JPanel rightSetupPanel = new JPanel();
   private JPanel buttonPanel1 = new JPanel();
   private JPanel buttonPanel2 = new JPanel();
   private JScrollPane sessionSelectionPane = new JScrollPane();
   private JPanel sessionSelectionPanel = new JPanel();
   private int maxSessions = 20;
   private SessionPanel sessionPanel = null;
   private SessionData sessionData;

   private JTextField proposalCode = new JTextField(5);
   private JTextField proposalNumber = new JTextField(5);
   private JButton submit = new JButton("Submit");
   private JButton select = new JButton("Select");
   private JButton create = new JButton("Create new session");
   private Proposal_response proposal_response = new Proposal_response();
   private Proposal proposal;
   private Session[] sessionArray;
   private int sessionCount = 0;

   private String callbackStatus = "ok";

   private ObservableComponent observableComponent = new ObservableComponent();

   public LoginPanel()
   {
      GridBagConstraints c = new GridBagConstraints();
      setLayout(new GridBagLayout());

      sessionPanel = new SessionPanel(sessionCount);

      initialiseSetupPanels();
      populateSetupPanels();
      sessionSelectionPane.setBorder(new TitleBorder("Session Selection"));
      populateButtonPanel1();
      populateButtonPanel2();

      c.insets = new Insets(0, 5, 0, 5); // Top, Left, Bottom, Right
      c.gridx = 1;
      c.gridy = 0;
      c.weightx = 1.0;
      c.weighty = 0.0;
      c.fill = GridBagConstraints.HORIZONTAL;
      add(setupPanel, c);
      
      c.gridx = 1;
      c.gridy = 1;
      c.weightx = 0.0;
      c.weighty = 0.0;      
      c.fill = GridBagConstraints.NONE;
      add(buttonPanel1, c);

      c.gridx = 1;
      c.gridy = 2;
      c.weightx = 1.0;
      c.weighty = 1.0;
      c.fill = GridBagConstraints.BOTH;
      sessionSelectionPane.setViewportView(sessionPanel);
      add(sessionSelectionPane, c);

      c.gridx = 1;
      c.gridy = 3;
      c.weightx = 0.0;
      c.weighty = 0.0;
      c.fill = GridBagConstraints.NONE;
      add(buttonPanel2, c);
      addIObserver(edm);
   }

   private void initialiseSetupPanels()
   {
      setupPanel.setBorder(new TitleBorder("User Proposal Selection"));
      setupPanel.setLayout(new GridBagLayout());
      leftSetupPanel.setLayout(new GridBagLayout());
      rightSetupPanel.setLayout(new GridBagLayout());
   }

   private void populateSetupPanels()
   {
      GridBagConstraints c = new GridBagConstraints();
      int componentCount = 1;

      addSetupComponent(componentCount++, "Proposal code (e.g. fx, mx)", "",
         proposalCode);
      addSetupComponent(componentCount++, "Proposal number (e.g. 415)", "",
         proposalNumber);

      c.gridx = GridBagConstraints.RELATIVE;
      c.gridy = 1;

      c.fill = GridBagConstraints.NONE;
      c.weightx = 0.0;
      c.insets = new Insets(5, 2, 0, 2); // Top, Left, Bottom, Right
      setupPanel.add(leftSetupPanel, c);

      c.fill = GridBagConstraints.HORIZONTAL;
      c.weightx = 1.0;
      c.insets = new Insets(0, 2, 0, 2); // Top, Left, Bottom, Right
      setupPanel.add(rightSetupPanel, c);
   }


   private void populateButtonPanel1()
   {
      GridBagConstraints c = new GridBagConstraints();

      submit.setActionCommand("Submit");
      submit.addActionListener(this);

      buttonPanel1.setLayout(new GridBagLayout());
      c.insets = new Insets(5, 5, 5, 5); // Top, Left, Bottom, Right
      c.gridx = GridBagConstraints.RELATIVE;
      c.gridy = 1;
      c.anchor = GridBagConstraints.CENTER;
      buttonPanel1.add(submit, c);
   }

   private void populateButtonPanel2()
   {
      GridBagConstraints c = new GridBagConstraints();

      select.setActionCommand("Select");
      select.addActionListener(this);

      create.setActionCommand("Create");
      create.addActionListener(this);
      create.setEnabled(false);

      buttonPanel2.setLayout(new GridBagLayout());
      c.insets = new Insets(5, 5, 5, 5); // Top, Left, Bottom, Right
      c.gridx = GridBagConstraints.RELATIVE;
      c.gridy = 1;
      c.anchor = GridBagConstraints.CENTER;
      buttonPanel2.add(select, c);
      buttonPanel2.add(create, c);
   }

   private void addSetupComponent(int row, String name, String componentPrefix,
      JComponent component)
   {
      GridBagConstraints c = new GridBagConstraints();
      c.insets = new Insets(0, 2, 7, 5); // Top, Left, Bottom, Right
      c.gridx = GridBagConstraints.RELATIVE;
      c.gridy = row;
      c.anchor = GridBagConstraints.EAST;
      c.fill = GridBagConstraints.NONE;
      leftSetupPanel.add(new JLabel(name), c);
      c.anchor = GridBagConstraints.CENTER;
      c.insets = new Insets(0, 0, 7, 0); // Top, Left, Bottom, Right
      leftSetupPanel.add(new JLabel("="), c);

      if (edm.isPrefixingOn())
      {
         c.insets = new Insets(2, 0, 0, 0); // Top, Left, Bottom, Right
         rightSetupPanel.add(new JLabel(componentPrefix), c);
      }

      c.insets = new Insets(2, 0, 0, 2); // Top, Left, Bottom, Right
      c.anchor = GridBagConstraints.WEST;
      c.fill = GridBagConstraints.HORIZONTAL;
      c.weightx = 1.0;
      rightSetupPanel.add(component, c);
   }

   public void getSessions(Proposal_response the_proposal_response)
   {
      this.proposal_response = the_proposal_response;
      sessionCount = proposal_response.getSessionCount();
      sessionArray = new Session[sessionCount];

      sessionPanel = new SessionPanel(sessionCount);

      for (int i = 0; i < sessionCount; i++)
      {
         Session session = proposal_response.getSession(i);
         sessionPanel.setSession(i, session.getStartDate(),
            session.getEndDate(), session.getBeamLineName(),
            session.getComments());
      }
      sessionSelectionPane.setViewportView(sessionPanel);
      sessionSelectionPane.revalidate();
      sessionSelectionPane.repaint();
    }

   // ActionListener

   public void actionPerformed(ActionEvent ae)
   {
      if (ae.getActionCommand().equals("Submit"))
      {
         try
         {
            deactivate();
            proposal = new Proposal();
            proposal.setCode(proposalCode.getText());
            proposal.setNumber(Integer.parseInt(proposalNumber.getText()));
            dbHelper.sendProposal_request(proposal);
            proposal_response = null;
         }
         catch (NumberFormatException ex)
         {
            ErrorDialog errorDialog = new ErrorDialog( this, "Proposal number containing non-numeric characters!");
            activate();
         }
         catch (CollectException ex)
         {
            System.out.println("CollectException caught: " + ex.getMessage());
            activate();
         }
      }
      else if (ae.getActionCommand().equals("Select"))
      {
         int selected = -1;
         
         for (int i = 0; i < sessionCount; i++)
         {
            sessionData = sessionPanel.getSessionData(i);
            if ((sessionData.getSelect()).booleanValue())
            {
               selected = i;
               break;
            }
         }
         if (selected >= 0)
         {
            Session session = proposal_response.getSession(selected);
            System.out.println(session.getSessionId());
            observableComponent.notifyIObservers(this, session);
            observableComponent.notifyIObservers(this, new ExpertState(
               ExpertState.IDLE));
            observableComponent.notifyIObservers(this, new ExpertState(
               ExpertState.SCREENING));
         }
         else
         {
            new ErrorDialog(
               this,
               "No Session Selected.\n"
                  + "Please select a session or create a new one before continuing.",
               "Session Selection");
         }
      }
   }

   public void activate()
   {
      this.submit.setEnabled(true);
      this.select.setEnabled(true);
      // this.create.setEnabled(true);
   }

   public void deactivate()
   {
      this.submit.setEnabled(false);
      this.select.setEnabled(false);
      this.create.setEnabled(false);
   }

   private void activate(JButton button)
   {
      button.setEnabled(true);
   }

   private void deactivate(JButton button)
   {
      button.setEnabled(false);
   }

   public void update(Object iObservable, Object arg)
   {
      if (arg instanceof ExpertState)
      {
         ExpertState state = (ExpertState) arg;

         switch (state.getState())
         {
            case ExpertState.IDLE:
            case ExpertState.ABORTED:
            {
               activate(submit);
               activate(select);
               break;
            }
         }
      }
   }

   // IObservable

   public void addIObserver(IObserver anIObserver)
   {
      observableComponent.addIObserver(anIObserver);
   }

   public void deleteIObserver(IObserver anIObserver)
   {
      observableComponent.deleteIObserver(anIObserver);
   }

   public void deleteIObservers()
   {
      observableComponent.deleteIObservers();
   }

}
