package dna;

import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.Vector;

import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;

import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.Unmarshaller;
import org.exolab.castor.xml.ValidationException;

import stacgui.ParamTable;
import stacgui.STAC_DatumPanel;
import stacgui.STAC_OrientationPanel;
import stacgui.STAC_StrategyPanel;
import stacgui.Stac_Session;
import stacgui.StacBCM;
import stacgui.StacUtil;
import stacgui.Stac_BCMplugin;
import stacgui.Stac_BCMplugin_base;
import stacgui.STAC_GUI_Button_Panel;

import dna.observable.IObservable;
import dna.observable.IObserver;
import dna.observable.ObservableComponent;
import dna.util.Debug;
import dna.xml.Collect_data_request;
import dna.xml.Collect_data_response;
import dna.xml.Collect_request;
import dna.xml.Collect_response;
import dna.xml.Fileinfo;
import dna.xml.Kappa_collect_settings;
import dna.xml.Kappa_motor_setting;
import dna.xml.Kappa_alignment;
import dna.xml.Kappa_alignment_request;
import dna.xml.Kappa_alignment_response;
import dna.xml.Kappa_possible_alignment;
import dna.xml.Kappa_strategy_request;
import dna.xml.Kappa_strategy_response;
import dna.xml.Kappa_strategy_sweep;
import dna.xml.Oscillation_sequence;
import dna.xml.Resolution;
import dna.xml.Strategy_interpretation;
import dna.xml.Strategy_request;
import dna.xml.Strategy_response;
import dna.xml.Strategy_settings;

class Stac_BCMplugin_DNA
   extends Stac_BCMplugin_base
   implements Stac_BCMplugin
{

   public double getMotorPosition(String arg0) throws Exception
   {
      // TODO Auto-generated method stub
      return 0;
   }

   public void setMotorPosition(String arg0, double arg1) throws Exception
   {
      // TODO Auto-generated method stub

   }

   public void moveMotor(String arg0, double arg1) throws Exception
   {
      // TODO Auto-generated method stub

   }

   public double getMotorSpeed(String arg0) throws Exception
   {
      // TODO Auto-generated method stub
      return 0;
   }

   public double getMotorSpeedLowLimit(String arg0) throws Exception
   {
      // TODO Auto-generated method stub
      return 0;
   }

   public void setMotorSpeed(String arg0, double arg1) throws Exception
   {
      // TODO Auto-generated method stub

   }

   public ParamTable getMotorParams(String arg0) throws Exception
   {
      // TODO Auto-generated method stub
      return null;
   }

   public void moveMotors(ParamTable arg0) throws Exception
   {
      // TODO Auto-generated method stub

   }

   public void moveMotorsSyncronized(ParamTable arg0) throws Exception
   {
      // TODO Auto-generated method stub

   }

   public void initMotors() throws Exception
   {
      // TODO Auto-generated method stub

   }

   public double loadMotorPosition(String arg0, String arg1)
   {
      // TODO Auto-generated method stub
      return 0;
   }

   public void saveMotorPositions(ParamTable arg0, String arg1)
   {
      // TODO Auto-generated method stub

   }

   public boolean checkDatumTrans(Point3d arg0, Point3d arg1)
   {
      // TODO Auto-generated method stub
      return false;
   }

   public double convertMotorPosition_Plugin2Stac(String arg0, double arg1)
   {
      // TODO Auto-generated method stub
      return 0;
   }

   public double convertMotorPosition_Stac2Plugin(String arg0, double arg1)
   {
      // TODO Auto-generated method stub
      return 0;
   }

   public void read_specdef(String arg0, ParamTable arg1)
   {
      // TODO Auto-generated method stub

   }

   public void getCalibration(ParamTable arg0, Vector3d[] arg1)
   {
      // TODO Auto-generated method stub

   }

   public void setCalibration(ParamTable arg0, Vector3d[] arg1)
   {
      // TODO Auto-generated method stub

   }

}

class KappaStrategyHelper
   extends StrategyHelper
   implements ExpertListener
{
   private Kappa_alignment_response _kappa_alignment_response = null;
   private Kappa_strategy_response _kappa_strategy_response = null;
   private Object _kappa_response = null;

   // public void sendStrategy_request(Kappa_alignment_request strategy_request)
   public void sendStrategy_request(Object strategy_request)
      throws StrategyException
   {
      StringWriter stringWriter = new StringWriter();
      String xml_string = "";
      String xml_type = "";
      try
      {
         if (strategy_request instanceof Kappa_alignment_request)
         {
            ((Kappa_alignment_request) strategy_request).marshal(stringWriter);
            xml_string = stringWriter.toString();
            xml_type = "/kappa_alignment_request";
         }
         else if (strategy_request instanceof Kappa_strategy_request)
         {
            ((Kappa_strategy_request) strategy_request).marshal(stringWriter);
            xml_string = stringWriter.toString();
            xml_type = "/kappa_strategy_request";
         }
         else if (strategy_request instanceof Collect_data_request)
         {
            ((Collect_data_request) strategy_request).marshal(stringWriter);
            xml_string = stringWriter.toString();
            xml_type = "/collect_data_request";
         }
         Debug.out(xml_string, 2);
         _expertProxy.sendToExpert(xml_type, xml_string);
      }
      catch (MarshalException ex)
      {
         throw new StrategyException(
            "MarshalException in KappaStrategyHelper.sendStrategy_request");
      }
      catch (ValidationException ex)
      {
         throw new StrategyException(
            "ValidationException in KappaStrategyHelper.sendStrategy_request");
      }
   }

   public synchronized Object sendStrategy_requestSynchronous(
      Object strategy_request, int timeOut) throws StrategyException
   {
      if (strategy_request instanceof Kappa_alignment_request)
      {
         _kappa_alignment_response = null;
      }
      else if (strategy_request instanceof Kappa_strategy_request)
      {
         _kappa_strategy_response = null;
      } else
      {
          _kappa_response = null;
      } 
      _callbackStatus = "ok";
      this.sendStrategy_request(strategy_request);
      Debug.out("Sending Kappa request.", 2);
      try
      {
         Debug.out("Kappa request sent, waiting for response.", 2);
         this.wait(timeOut);
      }
      catch (InterruptedException ex)
      {
         throw new StrategyException("InterruptedException caught in "
            + "KappaStrategyHelper.sendStrategy_requestSynchronous");
      }
      Object _response = null;
      if (strategy_request instanceof Kappa_alignment_request)
      {
         _response = _kappa_alignment_response;
      }
      else if (strategy_request instanceof Kappa_strategy_request)
      {
         _response = _kappa_strategy_response;
      } else {
    	 _response = _kappa_response;
      }
      if (_response == null)
         if (_callbackStatus.equals("ok"))
            throw new StrategyException(
               "Time out while waiting for Kappa response.");
         else
            throw new StrategyException(_callbackStatus);

      return _response;
   }

   public synchronized void expertMessage(ExpertXMLMessage the_message)
   {
      String path = the_message.getPath();

      if (path.equals("/kappa_alignment_response")
    		  || path.equals("/kappa_strategy_response")
    		  || path.equals("/collect_data_response"))
      {
         String xml_message = the_message.getXMLMessage();
         StringReader reader = new StringReader(the_message.getXMLMessage());

         try
         {
            if (path.equals("/kappa_alignment_response"))
            {
               _kappa_alignment_response = (Kappa_alignment_response) Unmarshaller.unmarshal(
                  Kappa_alignment_response.class, reader);
            }
            else if (path.equals("/kappa_strategy_response")) {
               _kappa_strategy_response = (Kappa_strategy_response) Unmarshaller.unmarshal(
                  Kappa_strategy_response.class, reader);
            }
            else
            { // if (path.equals("/kappa_strategy_response")) {
               _kappa_response =  Unmarshaller.unmarshal(
                  Collect_data_response.class, reader);
            };

         }
         catch (MarshalException mex)
         {
            Debug.out("MarshallException:" + mex);
            _callbackStatus = "MasrhalException in "
               + "KappaStrategyHelper.expertMessage";
         }
         catch (ValidationException vex)
         {
            Debug.out("ValidationException: " + vex);
            _callbackStatus = "ValidationException in "
               + "KappaStrategyHelper.expertMessage";
         }

         this.notify();
      }
   }
}


public class KappaStrategyPanel
   extends JPanel
   implements IObservable, IObserver, ActionListener, Runnable, STAC_GUI_Button_Panel
{
   private static final int CALCULATE_ORIENTATION = 0;
   private static final int CALCULATE_STRATEGIES = 1;
   private static final int COLLECT = 2;
   private static final int INTEGRATE = 3;
   private static final int CALCULATE_OPTIMAL_ORIENTATION = 4;

   private ExpertDataModel edm = ExpertDataModel.getInstance();

   // pane to store the kappa Tabs
   private JTabbedPane kappaStrategyPane = new JTabbedPane();

   // kappa Tabs
   private JPanel desiredOrientationPanel = new JPanel();
   private JPanel possibleVectorsPanel = new JPanel();
   private JPanel availableStrategiesPanel = new JPanel();

   // Orientation Tab
   private StacUtil STACutils = new StacUtil();
   private Stac_Session stacSession = new Stac_Session();
   private StacBCM STACbcm = new StacBCM(stacSession);
   private STAC_OrientationPanel reorientWidget = new STAC_OrientationPanel(
      STACutils, STACbcm, this);
   private JButton calcOrientation = new JButton("Calculate Possible Datums");

   // Vector Tab
   private STAC_DatumPanel datumWidget = new STAC_DatumPanel(STACutils,
      STACbcm, null);
   private JButton calcStrategies = new JButton("Calculate Strategies");

   // Strategy Tab
   private STAC_StrategyPanel strategyWidget = new STAC_StrategyPanel();
   private JButton collect = new JButton("Collect Data");
   private JButton integrate = new JButton("Collect & Integrate Data");

   // private KAPPAalignmentHelper kappaAlignment = new KAPPAalignmentHelper();
   private KappaStrategyHelper kappaStrategy = new KappaStrategyHelper();
   private Kappa_alignment_request kappa_alignment_request = new Kappa_alignment_request();
   private Kappa_strategy_request kappa_strategy_request = new Kappa_strategy_request();

   private StrategyHelper strategy = new StrategyHelper();
   private Strategy_request strategy_request = new Strategy_request();
   private Strategy_settings settings = new Strategy_settings();

   private StrategyDataPanel strategyDataPanel = new StrategyDataPanel();
   private JButton calculate = new JButton("Calculate Strategy");
   private JScrollPane pane;
   private JPanel buttonPanel = new JPanel();
   private static int operation;
   private int runNumber = 1;

   //private Fileinfo fileinfo = new Fileinfo();
   //private Oscillation_sequence oscillation_sequence = new Oscillation_sequence();
   //private Collect_request collect_request = new Collect_request();
   //private Collect_data_request collect_data_request = new Collect_data_request();
   //private CollectHelper collectHelper = new CollectHelper();
   //private Resolution collect_resolution = new Resolution();

   private boolean dataCollected = false;
   
   private ObservableComponent observableComponent = new ObservableComponent();

   private StrategyPanel SimpleStrategyPanel = null;
   
   public void setSimpleStrategyPanel(StrategyPanel strategyPanel) {
	   SimpleStrategyPanel=strategyPanel;
   }
   
   public KappaStrategyPanel()
   {

      setLayout(new BoxLayout(this, BoxLayout.PAGE_AXIS));

      // strategyDataPanel.addIObserver(this);
      add(kappaStrategyPane);

      kappaStrategyPane.addTab("Desired orientation", desiredOrientationPanel);
      desiredOrientationPanel.setLayout(new BoxLayout(desiredOrientationPanel,
         BoxLayout.PAGE_AXIS));
      desiredOrientationPanel.add(reorientWidget);
      desiredOrientationPanel.add(Box.createRigidArea(new Dimension(10, 10)));
      desiredOrientationPanel.add(calcOrientation);
      calcOrientation.setActionCommand("CalculateOrientation");
      calcOrientation.addActionListener(this);
      desiredOrientationPanel.add(Box.createRigidArea(new Dimension(10, 10)));

      kappaStrategyPane.addTab("Datums", possibleVectorsPanel);
      possibleVectorsPanel.setLayout(new BoxLayout(possibleVectorsPanel,
         BoxLayout.PAGE_AXIS));
      possibleVectorsPanel.add(datumWidget);
      possibleVectorsPanel.add(Box.createRigidArea(new Dimension(10, 10)));
      possibleVectorsPanel.add(calcStrategies);
      calcStrategies.setActionCommand("CalculateStrategies");
      calcStrategies.addActionListener(this);
      possibleVectorsPanel.add(Box.createRigidArea(new Dimension(10, 10)));

      kappaStrategyPane.addTab("Strategies", availableStrategiesPanel);
      availableStrategiesPanel.setLayout(new BoxLayout(
         availableStrategiesPanel, BoxLayout.PAGE_AXIS));
      availableStrategiesPanel.add(strategyWidget);
      JPanel strategyButtonPanel = new JPanel();
      availableStrategiesPanel.add(Box.createRigidArea(new Dimension(10, 10)));
      availableStrategiesPanel.add(strategyButtonPanel);
      strategyButtonPanel.setLayout(new BoxLayout(strategyButtonPanel,
         BoxLayout.LINE_AXIS));
      strategyButtonPanel.add(collect);
      collect.setActionCommand("Collect");
      collect.addActionListener(this);
      strategyButtonPanel.add(Box.createRigidArea(new Dimension(10, 10)));
      strategyButtonPanel.add(integrate);
      integrate.setActionCommand("Integrate");
      integrate.addActionListener(this);
      availableStrategiesPanel.add(Box.createRigidArea(new Dimension(10, 10)));

   }

   private void populateButtonPanel()
   {
      GridBagConstraints c = new GridBagConstraints();
      buttonPanel.setLayout(new GridBagLayout());
      c.insets = new Insets(5, 5, 5, 5); // Top, Left, Bottom, Right
      calculate.setActionCommand("Calculate");
      calculate.addActionListener(this);
      collect.setActionCommand("Collect");
      collect.addActionListener(this);
      integrate.setActionCommand("Integrate");
      integrate.addActionListener(this);

      c.gridx = GridBagConstraints.RELATIVE;
      c.gridy = 1;
      c.anchor = GridBagConstraints.EAST;

      buttonPanel.add(calculate, c);
      buttonPanel.add(collect, c);
      buttonPanel.add(integrate, c);
   }

   private void activate(JButton button)
   {
      button.setEnabled(true);
   }

   private void deactivate(JButton button)
   {
      button.setEnabled(false);
   }

   // IObservable

   public void addIObserver(IObserver anIObserver)
   {
      observableComponent.addIObserver(anIObserver);
   }

   public void deleteIObserver(IObserver anIObserver)
   {
      observableComponent.deleteIObserver(anIObserver);
   }

   public void deleteIObservers()
   {
      observableComponent.deleteIObservers();
   }

   // IObserver

   public void update(Object iObservable, Object arg)
   {
      Resolution resolution = new Resolution();

      if (arg instanceof ExpertState)
      {
         ExpertState state = (ExpertState) arg;
         switch (state.getState())
         {
            case ExpertState.IDLE:
            case ExpertState.ABORTED:
               activate(calculate);
               activate(collect);
               activate(integrate);
               // else
               // deactivate(scale);
               break;
            case ExpertState.COLLECTING_REFERENCE_IMAGES:
            case ExpertState.INDEXING:
            case ExpertState.CALCULATING_STRATEGY:
            case ExpertState.CHARACTERIZING:
               deactivate(calculate);
               deactivate(collect);
               deactivate(integrate);
               // deactivate(scale);
               break;
            case ExpertState.COLLECTING_DATA:
               dataCollected = true;
               deactivate(calculate);
               deactivate(collect);
               deactivate(integrate);
               // deactivate(scale);
               break;
               
         }
      }
      else if (arg instanceof Resolution)
      {
         resolution = (Resolution) arg;
         deactivate(collect);
         deactivate(integrate);
         edm.setClearStrategyResolution(false);
         if (strategy_request.getStrategy_settings() == null)
         {
            settings.setResolution(resolution);
            strategy_request.setStrategy_settings(settings);
         }
         else
         {
            settings = strategy_request.getStrategy_settings();
            settings.setResolution(resolution);
            strategy_request.setStrategy_settings(settings);
         }

      }
      else if (arg == null)
      {
         deactivate(collect);
         deactivate(integrate);
      }
   }

   // ActionListener
   public void Button_actionAdapter (ActionEvent e) {
	      if (e.getSource()==reorientWidget.jButtonOptAlign)
	      {
	         operation = CALCULATE_OPTIMAL_ORIENTATION;
	         new Thread(this).start();
	      }	  
   }
   public void actionPerformed(ActionEvent ae)
   {
      if (ae.getActionCommand().equals("CalculateOrientation"))
      {
         operation = CALCULATE_ORIENTATION;
         new Thread(this).start();
      }
      else if (ae.getActionCommand().equals("CalculateStrategies"))
      {
         operation = CALCULATE_STRATEGIES;
         new Thread(this).start();
      }
      else if (ae.getActionCommand().equals("Collect"))
      {
         operation = COLLECT;
         new Thread(this).start();
//         collectThread=new Thread(this);
  //       collectThread.start();
      }
      else if (ae.getActionCommand().equals("Integrate"))
      {
         operation = INTEGRATE;
         new Thread(this).start();
      }
   }

   // Runnable

   public void run()
   {
      Oscillation_sequence sequence;

      //collect_data_request = new Collect_data_request();
      boolean setIntegrate=false;
      boolean optOrient=false;

      switch (operation)
      {
         case CALCULATE_OPTIMAL_ORIENTATION:
        	 optOrient=true;
         case CALCULATE_ORIENTATION:
            try
            {
                Vector orientations = null;
            	if (optOrient) {
            		orientations = new Vector(0);
            		orientations.addElement("SPECIAL");
            		orientations.addElement("OptAlign");
            	}
            	else
            		orientations = reorientWidget.getOrientationRequest();

               observableComponent.notifyIObservers(this, new ExpertState(
                  ExpertState.CALCULATING_STRATEGY));

               kappa_alignment_request.setComment("First test parameter passed");
               kappa_alignment_request.removeAllDesired_orientation();
               for (int i = 0; i < orientations.size();)
               {
                  Kappa_alignment desiredOrientation = new Kappa_alignment();
                  desiredOrientation.setV1((String) orientations.elementAt(i++));
                  desiredOrientation.setV2((String) orientations.elementAt(i++));
                  kappa_alignment_request.addDesired_orientation(desiredOrientation);
               }

               Kappa_alignment_response alignment_response = (Kappa_alignment_response) kappaStrategy.sendStrategy_requestSynchronous(
                  kappa_alignment_request, edm.getStrategyTimeout());

               if (alignment_response != null)
               {
                  updatePanel(alignment_response);
               }

            }
            catch (StrategyException ex)
            {
               MessagePanel messagePanel = MessagePanel.getInstance();
               messagePanel.appendText("Error caught in Strategy");
               messagePanel.appendText(ex.getMessage());
               new ErrorDialog(this, ex, "Strategy");
            }
            finally
            {
               observableComponent.notifyIObservers(this, new ExpertState(
                  ExpertState.IDLE));
            }
            break;
         case CALCULATE_STRATEGIES:
            try
            {
               Vector datums = datumWidget.getDatumRequest();

               observableComponent.notifyIObservers(this, new ExpertState(
                  ExpertState.CALCULATING_STRATEGY));

               kappa_strategy_request.setComment("Kappa Strategy req passed");
               kappa_strategy_request.removeAllDesired_datum();
               for (int i = 0; i < datums.size();)
               {
                  Kappa_possible_alignment desiredDatum = new Kappa_possible_alignment();
                  desiredDatum.setV1((String) datums.elementAt(i++));
                  desiredDatum.setV2((String) datums.elementAt(i++));
                  desiredDatum.setOmega(((Double) datums.elementAt(i++)).doubleValue());
                  desiredDatum.setKappa(((Double) datums.elementAt(i++)).doubleValue());
                  desiredDatum.setPhi(((Double) datums.elementAt(i++)).doubleValue());
                  desiredDatum.setTrans((String) datums.elementAt(i++));
                  desiredDatum.setRank(((Double) datums.elementAt(i++)).doubleValue());
                  kappa_strategy_request.addDesired_datum(desiredDatum);
               }

               /*
                * If the resolution hasn't been altered clear it in the settins.
                * Don't want values hanging over from previous strategy
                * calculations.
                */
               if (edm.getClearStrategyResolution())
               {
                  settings.setResolution(null);
                  strategy_request.setStrategy_settings(settings);
               }
               kappa_strategy_request.setStandard_request(strategy_request);

               Kappa_strategy_response strategy_response = (Kappa_strategy_response) kappaStrategy.sendStrategy_requestSynchronous(
                  kappa_strategy_request, edm.getStrategyTimeout());

               if (strategy_response != null)
               {
                  updatePanel(strategy_response);
                  if (SimpleStrategyPanel instanceof StrategyPanel)
                	  SimpleStrategyPanel.updateStrategyDataPanel(strategy_response.getStandard_response());
               }
            }
            catch (StrategyException ex)
            {
               MessagePanel messagePanel = MessagePanel.getInstance();
               messagePanel.appendText("Error caught in Strategy");
               messagePanel.appendText(ex.getMessage());
               new ErrorDialog(this, ex, "Strategy");
            }
            finally
            {
               observableComponent.notifyIObservers(this, new ExpertState(
                  ExpertState.IDLE));
            }
            break;
         case -1:
            try
            {
               /*
                * If the resolution hasn't been altered clear it in the settins.
                * Don't want values hanging over from previous strategy
                * calculations.
                */
               if (edm.getClearStrategyResolution())
               {
                  settings.setResolution(null);
                  strategy_request.setStrategy_settings(settings);
               }

               observableComponent.notifyIObservers(this, new ExpertState(
                  ExpertState.CALCULATING_STRATEGY));
               Strategy_response strategy_response = strategy.sendStrategy_requestSynchronous(
                  strategy_request, edm.getStrategyTimeout());

               if (strategy_response != null)
               {
                  updateStrategyDataPanel(strategy_response);
               }
            }
            catch (StrategyException ex)
            {
               MessagePanel messagePanel = MessagePanel.getInstance();
               messagePanel.appendText("Error caught in Strategy");
               messagePanel.appendText(ex.getMessage());
               new ErrorDialog(this, ex, "Strategy");
            }
            finally
            {
               observableComponent.notifyIObservers(this, new ExpertState(
                  ExpertState.IDLE));
            }
            break;

         case INTEGRATE:
        	 setIntegrate=true;
        	 //collect_data_request.setIntegrate(true);
         case COLLECT:
        	 try
        	 {
        		 Vector sweeps = new Vector();
        		 //foreach selected sweep
        		 //if no sweep has been selected, collect all
        		 Vector strategies = strategyWidget.getStrategyRequest();
        		 
        		 for(int i=0;i<strategies.size();i++){
        			 ParamTable strategySweep=(ParamTable)strategies.elementAt(i);
        			 
        			 Fileinfo fileinfo = new Fileinfo();
        			 Collect_request collect_request = new Collect_request();
        			 Collect_data_request collect_data_request = new Collect_data_request();
        			 Resolution collect_resolution = new Resolution();
        			 
        			 fileinfo.setDirectory(edm.getDirectory());
        			 fileinfo.setPrefix(edm.getPrefix());
        			 if (edm.isRunNumberOn())
        			 {
        				 runNumber = edm.getValueOfRunNumber()+i;
        				 //edm.setRunNumber(runNumber+1+i);
        			 }
        			 else
        			 {
        				 runNumber = 1+i;
        			 }
        			 fileinfo.setRun_number(runNumber);
        			 collect_data_request = new Collect_data_request();
        			 collect_request = new Collect_request();
        			 collect_request.setFileinfo(fileinfo);
        			 
        		     StrategyData expt=(StrategyData)strategySweep.getFirstValue("strategy_data");
        			 
        			 Oscillation_sequence[] oscillation_sequence = new Oscillation_sequence[1];
        			 {
        				 oscillation_sequence[0] = new Oscillation_sequence();
        				 oscillation_sequence[0].setStart(strategySweep.getFirstDoubleValue("OmegaStart"));
        				 oscillation_sequence[0].setRange(strategySweep.getFirstDoubleValue("Incr"));
        				 oscillation_sequence[0].setOverlap(0);//expt.getValueOfOverlap());
        				 oscillation_sequence[0].setExposure_time(strategySweep.getFirstDoubleValue("Time"));
        				 oscillation_sequence[0].setNumber_of_images(strategySweep.getFirstIntegerValue("Images"));
        				 oscillation_sequence[0].setNumber_of_passes(expt.getValueOfPasses());
        				 oscillation_sequence[0].setStart_image_number(strategySweep.getFirstIntegerValue("1st img"));
        				 Resolution tmp_resolution = new Resolution();
        				 tmp_resolution.setUpper(strategySweep.getFirstDoubleValue("Resolution"));
        				 collect_request.setResolution(tmp_resolution);
        			 }
        			 
        			 collect_request.setOscillation_sequence(oscillation_sequence);
        			 
        			 //kappa settings
        			 Kappa_collect_settings kappa_settings = new Kappa_collect_settings();
        			 //kappa
        			 Kappa_motor_setting kappa_motors = new Kappa_motor_setting();
        			 kappa_motors.setMotorName("Kappa");
        			 kappa_motors.setMotorValue(strategySweep.getFirstDoubleValue("Kappa"));
        			 kappa_settings.addMotorSettings(kappa_motors);
        			 //phi
        			 kappa_motors = new Kappa_motor_setting();
        			 kappa_motors.setMotorName("Phi");
        			 kappa_motors.setMotorValue(strategySweep.getFirstDoubleValue("Phi"));
        			 kappa_settings.addMotorSettings(kappa_motors);
        			 //X
        			 kappa_motors = new Kappa_motor_setting();
        			 kappa_motors.setMotorName("X");
        			 kappa_motors.setMotorValue(strategySweep.getFirstDoubleValue("X"));
        			 kappa_settings.addMotorSettings(kappa_motors);
        			 //Y
        			 kappa_motors = new Kappa_motor_setting();
        			 kappa_motors.setMotorName("Y");
        			 kappa_motors.setMotorValue(strategySweep.getFirstDoubleValue("Y"));
        			 kappa_settings.addMotorSettings(kappa_motors);
        			 //Z
        			 kappa_motors = new Kappa_motor_setting();
        			 kappa_motors.setMotorName("Z");
        			 kappa_motors.setMotorValue(strategySweep.getFirstDoubleValue("Z"));
        			 kappa_settings.addMotorSettings(kappa_motors);
        			 
        			 collect_request.setKappa_collect_settings(kappa_settings);
        			 
        			 collect_resolution.setUpper(edm.getValueOfResolution());
        			 
        			 collect_data_request.setCollect_request(collect_request);
        			 if (setIntegrate)
        				 collect_data_request.setIntegrate(true);
        			 
            		 // Set the session id if available...
            		 if ( edm.getSession()!= null )
            		 {
            			 collect_request.setSessionId( ( edm.getSession( ) ).getSessionId( ) );
            		 }
            		 sweeps.addElement(collect_data_request);
        		 }
        		 
    			 /*
    			  * FIXME: This should be here. But before it is put back in we
    			  * need a proper means to set IDLE again when done.
    			  * observableComponent.notifyIObservers( this, new
    			  * ExpertState(ExpertState.COLLECTING_DATA));
    			  */
        		 
        		 for (int i=0;i<sweeps.size();i++) {
        			 //send the sweep to be collected
       			     observableComponent.notifyIObservers( this, new
       	    			  ExpertState(ExpertState.COLLECTING_DATA));
        			 try {
        				 Collect_data_request collect_data_request = (Collect_data_request)sweeps.elementAt(i);
        				 Collect_data_response collect_data_response = (Collect_data_response) kappaStrategy.sendStrategy_requestSynchronous(
        						 collect_data_request, 
        						 24*60*60*1000);
        						 //(int) (collect_data_request.getCollect_request().getOscillation_sequence(0).getNumber_of_images()*
        							//	 collect_data_request.getCollect_request().getOscillation_sequence(0).getExposure_time()*5000));
        				 if (edm.isRunNumberOn())
        					 edm.setRunNumber(edm.getValueOfRunNumber()+1);
        			 }
        			 catch (StrategyException ex)
        			 {
        				 MessagePanel messagePanel = MessagePanel.getInstance();
        				 messagePanel.appendText("Error caught in Strategy");
        				 messagePanel.appendText(ex.getMessage());
        				 new ErrorDialog(this, ex, "Strategy");
        			 }        			 
        		 }
        	 }
        	 catch (NumberFormatException ex)
        	 {
        		 System.out.println("Error converting reference image data");
        	 }
//        	 catch (CollectException ex)
//        	 {
//        		 System.out.println("CollectException caught: " + ex.getMessage());
//        	 }
        	 /*
        	  * FIXME: The collect is asynchronous and the IDLE needs to be set
        	  * when the expert sends a message back to indicate that the collect
        	  * is complete, NOT here.
        	  */ 
        	 finally {
        	   observableComponent.notifyIObservers( this, new
        	   ExpertState(ExpertState.IDLE));
        	 }
        	 break;
      }
   }

   public void updateStrategyDataPanel(Strategy_response strategy_response)
   {
      StrategyData expt;
      Oscillation_sequence sequence;

      Strategy_interpretation strategy_interpretation = strategy_response.getStrategy_interpretation();
      if (strategy_interpretation != null)
      {
         Oscillation_sequence[] oscillation_sequence = strategy_interpretation.getOscillation_sequence();

         strategyDataPanel.setDataArraySize(oscillation_sequence.length);
         for (int i = 0; i < oscillation_sequence.length; i++)
         {
            sequence = oscillation_sequence[i];
            expt = strategyDataPanel.getDnaData(i);
            updateTableData(expt, sequence, runNumber + i);
            expt = strategyDataPanel.getStrategyData(i);
            updateTableData(expt, sequence, runNumber + i);
         }
      }
      else
         Debug.out("NULL strategy interpretation");
   }

   public void updatePanel(Kappa_alignment_response _response)
   {
      System.out.println(_response.getComment());
      
      if (_response.getComment().startsWith("SPECIAL")) {
    	  Vector list=new Vector(0);
          for (int i = 0; i < _response.getPossible_orientationCount(); i++)
          {
             Kappa_possible_alignment col = _response.getPossible_orientation(i);
             String v1 = col.getV1();
             String v2 = col.getV2();
             String comment = col.getTrans();
             list.addElement(v1);
             list.addElement(v2);
             list.addElement(comment);
          }
          reorientWidget.addOrientationRequest(list);
    	  
    	  
      } else {
      

      // clear the table
      datumWidget.clearTable();
      // fill the table
      for (int i = 0; i < _response.getPossible_orientationCount(); i++)
      {
         Kappa_possible_alignment col = _response.getPossible_orientation(i);
         String v1 = col.getV1();
         String v2 = col.getV2();
         Double omega = new Double(col.getOmega());
         Double kappa = new Double(col.getKappa());
         Double phi = new Double(col.getPhi());
         String trans = col.getTrans();
         Double rank = new Double(col.getRank());

         Vector cols = new Vector();
         cols.addElement(v1);
         cols.addElement(v2);
         cols.addElement(omega);
         cols.addElement(kappa);
         cols.addElement(phi);
         cols.addElement(trans);
         cols.addElement(rank);
         datumWidget.addTableRow(cols);

      }
      // change the tab
      if (kappaStrategyPane.getSelectedComponent() == desiredOrientationPanel)
      {
         kappaStrategyPane.setSelectedComponent(possibleVectorsPanel);
      }
      }
   }

   public void updatePanel(Kappa_strategy_response _response)
   {
      System.out.println(_response.getComment());

      // clear the table
      strategyWidget.clearTable();
      // fill the table
      Strategy_response strd_strategy = _response.getStandard_response();
      StrategyData expt=null;
      Oscillation_sequence sequence;
      Strategy_interpretation strategy_interpretation = strd_strategy.getStrategy_interpretation();

      double incr = 1;
      double time = 1;
      double res = 0;

      try
      {
         Oscillation_sequence[] oscillation_sequence = strategy_interpretation.getOscillation_sequence();
         sequence = oscillation_sequence[0];
         expt = new StrategyData();
         updateTableData(expt, sequence, 1);

         incr = expt.getIncrement().doubleValue();
         time = expt.getTime().doubleValue();
         res = expt.getResolution().doubleValue();
      }
      catch (Exception e)
      {
      }

      for (int i = 0; i < _response.getGenerated_sweepCount(); i++)
      {
         Kappa_strategy_sweep col = _response.getGenerated_sweep(i);

         int strategyID = col.getStrategyID();
         double omegaStart = col.getOmegaStart();
         double omegaEnd = col.getOmegaEnd();
         double kappa = col.getKappa();
         double phi = col.getPhi();
         double completion = col.getCompleteness();
         double rank = col.getRank();

         ParamTable cols = new ParamTable();
         cols.setSingleValue("ID", new Integer(strategyID));
         cols.setSingleValue("OmegaStart", new Double((int)omegaStart));
         cols.setSingleValue("Incr", new Double(incr));
         cols.setSingleValue("Time", new Double(time));
         cols.setSingleValue("Images", new Integer((int)((omegaEnd - (int)omegaStart)
            / incr+1)));
         cols.setSingleValue("1st img", new Integer(1));
         cols.setSingleValue("Resolution", new Double(res));
         cols.setSingleValue("Kappa", new Double(kappa));
         cols.setSingleValue("Phi", new Double(phi));
         cols.setSingleValue("Completeness", new Double(completion));
         cols.setSingleValue("rank", new Double(rank));
         cols.setSingleValue("strategy_data",expt);
         strategyWidget.addTableRow(cols);

      }
      // change the tab
      if (kappaStrategyPane.getSelectedComponent() == possibleVectorsPanel)
      {
         kappaStrategyPane.setSelectedComponent(availableStrategiesPanel);
      }
   }

   private void updateTableData(StrategyData expt,
      Oscillation_sequence sequence, int runNumber)
   {
      expt.setStartPhi(sequence.getStart());
      expt.setIncrement(sequence.getRange());
      expt.setOverlap(sequence.getOverlap());
      expt.setTime(sequence.getExposure_time());
      expt.setNImages(sequence.getNumber_of_images());
      expt.setPasses(sequence.getNumber_of_passes());
      expt.setTemplateStart(sequence.getStart_image_number());
      expt.setRunNumber(runNumber);
      expt.setResolution(edm.getCalculatedResolution().getUpper());
   }

}
