
package dna;

import java.io.StringReader;
import java.io.StringWriter;

import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.Unmarshaller;
import org.exolab.castor.xml.ValidationException;

import dna.util.Debug;
import dna.xml.Feedback_request;
import dna.xml.Feedback_response;

public class FeedbackHelper
   implements ExpertListener
{
   private ExpertClientHTTPServer httpServer = ExpertClientHTTPServer.getGUIServer();
   private ExpertProxy expertProxy = ExpertProxy.getInstance();
   private Feedback_response feedback_response = null;
   private String callbackStatus = "ok";

   public FeedbackHelper()
   {
      httpServer.addExpertListener(this);
   }

   public void sendFeedback_request(Feedback_request feedback_request)
      throws FeedbackException
   {
      StringWriter stringWriter = new StringWriter();
      try
      {
         feedback_request.marshal(stringWriter);
         String xml_string = stringWriter.toString();
         feedback_request.marshal(stringWriter);
         Debug.out("/feedback_request" + xml_string);
         expertProxy.sendToExpert("/feedback_request", xml_string);
      }
      catch (MarshalException mex)
      {
         throw new FeedbackException("MarshalException in "
            + "FeedbacklHelper.sendFeedback_request: " + mex);
      }
      catch (ValidationException vex)
      {
         throw new FeedbackException("ValidationException in "
            + "FeedbackHelper.sendFeedback_request: " + vex);
      }
   }

   public synchronized void expertMessage(ExpertXMLMessage the_message)
   {
      String path = the_message.getPath();

      if (path.equals("/feedback_response"))
      {
         String xml_message = the_message.getXMLMessage();
         StringReader reader = new StringReader(the_message.getXMLMessage());
         Debug.out("PXGEN ExpertGUIHelper got message : " + path + ": "
            + xml_message);

         try
         {
            feedback_response = (Feedback_response) Unmarshaller.unmarshal(
               Feedback_response.class, reader);
         }
         catch (MarshalException ex)
         {
            callbackStatus = "MasrhalException in "
               + "FeedbackHelper.expertMessage";
         }
         catch (ValidationException ex)
         {
            callbackStatus = "ValidationException in "
               + "FeedbackHelper.expertMessage";
         }
         this.notify();

      }
   }
}
