package dna;

import java.io.File;

import javax.swing.filechooser.FileFilter;

/**
 * A class to implement File filtering for a File chooser
 */
public class ExtensionFileFilter
   extends FileFilter
{
   private String extension;
   private String description;

   public ExtensionFileFilter(String extension, String description)
   {
      this.extension = extension;
      this.description = description;
   }

   public String getDescription()
   {
      return description;
   }

   public boolean accept(File file)
   {
      if (file.isDirectory())
      {
         return true;
      }
      String name = file.getName();

      if (name.lastIndexOf(extension) >= 0)
         return true;
      return false;
   }
}
