
package dna;

import dna.observable.IObservable;
import dna.observable.IObserver;
import dna.observable.ObservableComponent;

public class ExpertState
   implements IObserver, IObservable
{
   private ObservableComponent observableComponent = new ObservableComponent();

   public static final int ERROR = -1;
   public static final int IDLE = 0;
   public static final int ABORTED = 1;
   public static final int COLLECTING_REFERENCE_IMAGES = 2;
   public static final int INDEXING = 3;
   public static final int CALCULATING_STRATEGY = 4;
   public static final int COLLECTING_DATA = 5;
   public static final int DISPLAY_INDEXING_SOLUTION = 6;
   public static final int DISPLAY_STRATEGY = 7;
   public static final int CHARACTERIZING = 8;
   public static final int LOGGING_IN = 9;
   public static final int SCREENING = 10;
   public static final int RANKING = 11;
   public static final int INTEGRATING_DATA = 12;
   public static final int SAMPLE_RANKING_CHARACTERIZING_SINGLE_CRYSTAL = 13;   
   public static final int SAMPLE_RANKING_COLLECT_AUTOMATICALLY = 14;   

   private int state = IDLE;

   public ExpertState()
   {
      this.state = IDLE;
   }

   public ExpertState(int state)
   {
      this.state = state;
   }

   public int getState()
   {
      return state;
   }

   // IObserver

   public void update(Object iObservable, Object arg)
   {
      if (arg instanceof ExpertState)
      {
         int oldState = this.state;
         ExpertState state = (ExpertState) arg;
         this.state = state.getState();
         // The state has changed, notify observers.
         if (this.state != oldState)
         {
            observableComponent.notifyIObservers(this, new ExpertState(
               this.state));
         }
      }
   }

   // IObservable

   public void addIObserver(IObserver anIObserver)
   {
      observableComponent.addIObserver(anIObserver);
   }

   public void deleteIObserver(IObserver anIObserver)
   {
      observableComponent.deleteIObserver(anIObserver);
   }

   public void deleteIObservers()
   {
      observableComponent.deleteIObservers();
   }

}
