package dna;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringReader;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.ProtocolException;
import java.net.URL;

import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.Unmarshaller;
import org.exolab.castor.xml.ValidationException;

import dna.util.Debug;
import dna.xml.Dna_status;
import dna.xml.Loaded_samples_response;
import dna.xml.Proposal_response;

public class ExpertProxy
{
   private static ExpertProxy _instance = null;
   private String _expertHostName;
   private int _expertPort;
   private HttpURLConnection urlc;
   private String _callbackStatus = "ok";
   private String illegalChars = "'\r'";

   private ExpertProxy()
   {
      ExpertDataModel edm = ExpertDataModel.getInstance();
      _expertHostName = edm.getExpertSystemHostName();
      _expertPort = edm.getExpertSystemPortNumber();
   }

   public static ExpertProxy getInstance()
   {
      if (_instance == null)
         _instance = new ExpertProxy();
      return _instance;
   }

   public synchronized Object talkToExpert(String path, String xml_message)
   {

      Dna_status dna_status = null;
      Proposal_response proposal_response = null;
      Loaded_samples_response loaded_samples_response = null;
      Object object = null;

      sendToExpert(path, xml_message);

      try
      {
         BufferedReader reader = new BufferedReader(new InputStreamReader(
            urlc.getInputStream()));
         String reply;
         reply = reader.readLine();
         int start = reply.indexOf(">");

         StringReader stringReader = new StringReader(reply.substring(
            start + 1, reply.length()));
         try
         {
            if (path.equals("/dna_status_request"))
            {
               dna_status = (Dna_status) Unmarshaller.unmarshal(
                  Dna_status.class, stringReader);
               object = dna_status;
            }
            else if (path.equals("/proposal_request"))
            {
               proposal_response = (Proposal_response) Unmarshaller.unmarshal(
                  Proposal_response.class, stringReader);
               object = proposal_response;
            }
            else if (path.equals("/loaded_samples_request"))
            {
               loaded_samples_response = (Loaded_samples_response) Unmarshaller.unmarshal(
                  Loaded_samples_response.class, stringReader);
               object = loaded_samples_response;
            }
         }
         catch (MarshalException mex)
         {
            Debug.out("MarshallException:" + mex);
            _callbackStatus = "MarhhalException in Helper";
         }
         catch (ValidationException vex)
         {
            Debug.out("ValidationException: " + vex);
            _callbackStatus = "ValidationException in Helper";
         }

         /*
          * System.out.println("Returned from ES " +
          */
      }
      catch (IOException ioex)
      {
         System.out.println("Error reading back from ES " + ioex.getMessage());
      }

      return object;
   }

   public synchronized void sendToExpert(String path, String xml_message)
   {
      URL expertURL;
      // HttpURLConnection urlc;
      PrintWriter POSTWriter;
      StringCleaner stringCleaner = new StringCleaner(illegalChars);
      Debug.out("OPENING EXPERT " + path, 2);
      xml_message = stringCleaner.getCleanString(xml_message);

      try
      {
         expertURL = new URL("http://" + _expertHostName + ":" + _expertPort
            + path);
         Debug.out("OPENING EXPERT " + expertURL, 2);
         urlc = (HttpURLConnection) expertURL.openConnection();
         Debug.out("OPENING EXPERT OK", 2);

         // Sets the request method to POST, and enable to send data
         urlc.setDoInput(true);
         urlc.setDoOutput(true);
         urlc.setRequestMethod("POST");
         urlc.setAllowUserInteraction(false);

         // Set default Content-type and content length for POST requests
         urlc.setRequestProperty("Content-Type", "text/xml");
         // ERROR
         urlc.setRequestProperty("Content-Length",
            Integer.toString(xml_message.length()));

         // Gets the output stream and POSTs data
         OutputStream POSTStream = urlc.getOutputStream();
         POSTWriter = new PrintWriter(POSTStream);
         POSTWriter.println(xml_message);
         POSTWriter.flush();
         POSTWriter.close();

         Debug.out("Sending to expert : " + xml_message, 2);

         // Get the response code
         try
         {
            int rc = urlc.getResponseCode();
            Debug.out("ResponseCode = " + rc, 2);
         }
         catch (IOException ioex)
         {
            Debug.out("IOException sending " + xml_message
               + " to expert system.", 2);
         }
      }
      catch (MalformedURLException ex)
      {
         Debug.out("Malformed URL for expert system");
      }
      catch (ProtocolException pex)
      {
         Debug.out("ProtocolException opening expert system connection");
      }
      catch (IOException ioex)
      {
         Debug.out("IOException opening expert system connection");
         Debug.out("Message " + ioex.getMessage());
      }
   }

}
