package dna;

import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;

import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;

import dna.observable.IObserver;
import dna.observable.ObservableComponent;
import dna.util.Debug;
import dna.util.TitleBorder;
import dna.xml.Bcm_parameters_request;
import dna.xml.Bcm_parameters_response;

public class ExpertPanel
   extends JSplitPane
   implements IObserver
{
   private JTabbedPane pane = new JTabbedPane();

   private int loginTab;
   private int referenceImagesTab;
   private int sampleScreeningTab;
   private int rankingTab;
   private int autoIndexTab;
   private int strategyTab = -1;
   private int resultsTab;
   private boolean characterizing = false;

   private ExpertDataModel edm = ExpertDataModel.getInstance();

   private LoginPanel login = new LoginPanel();
   private SampleScreeningPanel sampleScreening = new SampleScreeningPanel();
   private RankingPanel ranking = new RankingPanel();
   private ReferenceImagesPanel referenceImages = new ReferenceImagesPanel();
   private StrategyDataPanel strategyData = new StrategyDataPanel();
   private AutoIndexPanel indexImages = new AutoIndexPanel();
   private StrategyPanel collectionStrategy = new StrategyPanel();
   private KappaStrategyPanel collectionKappaStrategy;
   private ExpertCollectPanel results = new ExpertCollectPanel();
   private DbResponsesHandler dbResponsesHandler = new DbResponsesHandler(
      login, sampleScreening, ranking);
   private ExecutiveSystemStatusPanel executiveSystemStatusPanel = ExecutiveSystemStatusPanel.getInstance();
   private ExecutiveSystemStatusResponsesHandler esStatusResponsesHandler = new ExecutiveSystemStatusResponsesHandler(
      executiveSystemStatusPanel);
   private CharacterizeResponsesHandler characterizeResponsesHandler;
   private Bcm_parameters_request request = new Bcm_parameters_request();

   private ExpertState expertState = new ExpertState();
   private ExpertButtonPanel expertButtonPanel;
   private MessagePanel messagePanel = MessagePanel.getInstance();
   private JPanel topPanel = new JPanel();
   private JPanel bottomPanel = new JPanel();
   private CollectHelper collectHelper = CollectHelper.getInstance();
   private ExpertGUIMenu expertGUIMenu = ExpertGUIMenu.getInstance();
   
   private ObservableComponent observableComponent = new ObservableComponent();

   public ExpertPanel(boolean quitButtonOn)
   {
      super(JSplitPane.VERTICAL_SPLIT);

      if (edm.getKappaAvailable())
      {
         collectionKappaStrategy = new KappaStrategyPanel();
         collectionKappaStrategy.setSimpleStrategyPanel(collectionStrategy);
      }

      characterizeResponsesHandler = new CharacterizeResponsesHandler(
         indexImages, collectionStrategy, collectionKappaStrategy);
      collectHelper.setJComponent( this );
      
      Expert.start();
      
      ExpertClientHTTPServer.getGUIServer().addExpertListener(
         characterizeResponsesHandler);
      ExpertClientHTTPServer.getGUIServer().addExpertListener(
         dbResponsesHandler);
      ExpertClientHTTPServer.getGUIServer().addExpertListener(
         esStatusResponsesHandler);
      
      expertButtonPanel = new ExpertButtonPanel(quitButtonOn, this);

      setBorder(new TitleBorder("DNA - automateD collectioN of datA"));
      topPanel.setLayout(new GridBagLayout());
      bottomPanel.setLayout(new GridBagLayout());
      GridBagConstraints c = new GridBagConstraints();

      login.addIObserver(expertState);
      sampleScreening.addIObserver(expertState);
      referenceImages.addIObserver(expertState);
      indexImages.addIObserver(expertState);
      collectHelper.addIObserver(expertState);
      characterizeResponsesHandler.addIObserver(expertState);
      expertGUIMenu.addIObserver(this);

      if (edm.getKappaAvailable())
      {
         collectionKappaStrategy.addIObserver(expertState);
      }
      collectionStrategy.addIObserver(expertState);
      expertButtonPanel.addIObserver(expertState);
      executiveSystemStatusPanel.addIObserver(collectionStrategy);
      //characterizeResponsesHandler.addIObserver(expertState);
      //collectResponsesHandler.addIObserver(expertState);
      //dbResponsesHandler.addIObserver(expertState);
      ranking.addIObserver(expertState);

      expertState.addIObserver(login);
      expertState.addIObserver(sampleScreening);
      expertState.addIObserver(referenceImages);
      expertState.addIObserver(sampleScreening);
      expertState.addIObserver(strategyData);
      if (edm.getKappaAvailable())
      {
         expertState.addIObserver(collectionKappaStrategy);
      }
      expertState.addIObserver(collectionStrategy);
      expertState.addIObserver(indexImages);
      expertState.addIObserver(ranking);
      expertState.addIObserver(this);

      if (edm.isDatabaseAvailable())
      {
         if (edm.isLoginPanelAvailable())
         {
	         pane.addTab("Login to Database", login);
	         loginTab = pane.indexOfComponent(login);
         }
         pane.addTab("Sample Screening", sampleScreening);
         sampleScreeningTab = pane.indexOfComponent(sampleScreening);
         pane.addTab("Sample Ranking", ranking);
         rankingTab = pane.indexOfComponent(ranking);
         if ( ! edm.isScreeningAvailable())
         {
             pane.setEnabledAt( sampleScreeningTab, false);
             pane.setEnabledAt( rankingTab, false);
         }
      }
      pane.addTab("Collect Reference Images", referenceImages);
	  referenceImagesTab = pane.indexOfComponent(referenceImages);
      if ( edm.isDatabaseAvailable() && (! edm.isScreeningAvailable()) )
      {
          pane.setSelectedIndex(referenceImagesTab);
      }
      pane.addTab("Auto Index", indexImages);
      autoIndexTab = pane.indexOfComponent(indexImages);

      if (edm.getBCMKappaInUse() && edm.getKappaAvailable())
      {
         pane.addTab("Kappa Strategy", collectionKappaStrategy);
         strategyTab = pane.indexOfComponent(collectionKappaStrategy);
      }
      else
      {
         pane.addTab("Strategy", collectionStrategy);
         strategyTab = pane.indexOfComponent(collectionStrategy);
      }
      pane.addTab("Results", results);
      resultsTab = pane.indexOfComponent(results);

      c.weightx = 1.0;
      c.weighty = 1.0;
      c.gridx = GridBagConstraints.RELATIVE;
      c.gridy = 0;
      c.fill = GridBagConstraints.BOTH;
      c.anchor = GridBagConstraints.NORTH;
      topPanel.add(pane, c);

      c.insets = new Insets(3, 0, 0, 0);
      c.weightx = 1.0;
      c.weighty = 0.0;
      c.gridx = 0;
      c.gridy = 0;
      c.fill = GridBagConstraints.BOTH;
      c.anchor = GridBagConstraints.WEST;
      bottomPanel.add(executiveSystemStatusPanel, c);

      c.insets = new Insets(0, 0, 0, 0);
      c.weightx = 0.0;
      c.gridx = 1;
      c.fill = GridBagConstraints.NONE;
      c.anchor = GridBagConstraints.EAST;
      bottomPanel.add(expertButtonPanel, c);

      c.gridwidth = 2;
      c.weighty = 1.0;
      c.gridx = 0;
      c.gridy = 1;
      c.fill = GridBagConstraints.BOTH;
      bottomPanel.add(messagePanel, c);

      this.setTopComponent(topPanel);
      this.setBottomComponent(bottomPanel);
/*      
      try
      {
         Bcm_parameters_response response = collectHelper.sendBcm_parameters_requestSynchronous(request, edm.getStrategyTimeout());
      }
      catch (CollectException e)
      {
         Debug.out("Time out making bcm parameters request.");
      }
 */    
  }

   private void enableForIndexing()
   {
      if (edm.isDatabaseAvailable())
      {
         pane.setEnabledAt(loginTab, false);
         pane.setEnabledAt(sampleScreeningTab, false);
      }
      pane.setEnabledAt(referenceImagesTab, false);
      pane.setEnabledAt(autoIndexTab, true);
      pane.setEnabledAt(strategyTab, false);
      pane.setEnabledAt(resultsTab, true);
   }

   private void enableForCollect()
   {
      enableForStrategy();
   }

   private void enableForStrategy()
   {
      if (edm.isDatabaseAvailable())
      {
         pane.setEnabledAt(loginTab, false);
         pane.setEnabledAt(sampleScreeningTab, false);
      }
      pane.setEnabledAt(referenceImagesTab, false);
      pane.setEnabledAt(autoIndexTab, false);
      pane.setEnabledAt(strategyTab, true);
      pane.setEnabledAt(resultsTab, true);
   }

   private void enableForReferencing()
   {
      if (edm.isDatabaseAvailable())
      {
         pane.setEnabledAt(loginTab, false);
         pane.setEnabledAt(sampleScreeningTab, false);
      }
      pane.setEnabledAt(referenceImagesTab, true);
      pane.setEnabledAt(autoIndexTab, false);
      pane.setEnabledAt(strategyTab, false);
      pane.setEnabledAt(resultsTab, true);
   }

   /**
    * update the panel to the currently selected strategy type
    * 
    */
   private void switchStrategy()
   {
      int selected = pane.getSelectedIndex();
      if (strategyTab != -1)
      {
         pane.remove(strategyTab);
         if (edm.getBCMKappaInUse() && edm.getKappaAvailable())
         {
            pane.insertTab("Kappa Strategy", null, collectionKappaStrategy, "",
               strategyTab);
         }
         else
         {
            pane.insertTab("Strategy", null, collectionStrategy, "",
               strategyTab);
         }
         pane.setSelectedIndex(selected);
      }
   }

   // IObserver

   /**
    * receives update requests: arg - ExpertState check the ES stage arg -
    * "update_strategy_panel" user changed the strategy type
    */
   public void update(Object iObservable, Object arg)
   {
      if (arg instanceof ExpertState)
      {
         ExpertState state = (ExpertState) arg;
         switch (state.getState())
         {
            case ExpertState.IDLE:
            case ExpertState.ABORTED:
               characterizing = false;
               if (edm.isDatabaseAvailable())
               {
                  pane.setEnabledAt(loginTab, true);
                  pane.setEnabledAt(sampleScreeningTab, true);
               }
               pane.setEnabledAt(referenceImagesTab, true);
               pane.setEnabledAt(autoIndexTab, true);
               pane.setEnabledAt(strategyTab, true);
               pane.setEnabledAt(resultsTab, true);
               break;
            case ExpertState.COLLECTING_REFERENCE_IMAGES:
               enableForReferencing();
               characterizing = false;
               break;
            case ExpertState.INDEXING:
               characterizing = false;
               enableForIndexing();
               break;
            case ExpertState.CALCULATING_STRATEGY:
               characterizing = false;
               enableForStrategy();
               break;
            case ExpertState.COLLECTING_DATA:
               characterizing = false;
               enableForCollect();
               break;
            case ExpertState.CHARACTERIZING:
               enableForReferencing();
               characterizing = true;
               break;
            case ExpertState.SAMPLE_RANKING_CHARACTERIZING_SINGLE_CRYSTAL:
               enableForReferencing();
               characterizing = true;
               break;            	
            case ExpertState.SAMPLE_RANKING_COLLECT_AUTOMATICALLY:
                enableForCollect();
                characterizing = false;
                break;            	
            case ExpertState.DISPLAY_INDEXING_SOLUTION:
               if (characterizing)
               {
                  pane.setSelectedIndex(autoIndexTab);
                  enableForIndexing();
               }
               break;
            case ExpertState.DISPLAY_STRATEGY:
               if (characterizing)
               {
                  pane.setSelectedIndex(strategyTab);
                  enableForStrategy();
               }
               break;
            case ExpertState.LOGGING_IN:
               characterizing = false;
               pane.setSelectedIndex(loginTab);

               break;
            case ExpertState.SCREENING:
               characterizing = false;
               pane.setSelectedIndex(sampleScreeningTab);
               break;
            case ExpertState.RANKING:
               pane.setSelectedIndex(rankingTab);
               break;
         }
      }
      else if (arg instanceof String)
      {
         if (((String) arg).equalsIgnoreCase("update_strategy_panel"))
         {
            switchStrategy();
         }
         else if (((String) arg).equalsIgnoreCase("disable_screening_ranking_panels"))
         {
             pane.setEnabledAt( sampleScreeningTab, false);
             pane.setEnabledAt( rankingTab, false);
             pane.setSelectedIndex(referenceImagesTab);
         }
         else if (((String) arg).equalsIgnoreCase("enable_screening_ranking_panels"))
         {
             pane.setEnabledAt( sampleScreeningTab, true);
             pane.setEnabledAt( rankingTab, true);
         }
      }
   }
}
