package dna;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import javax.swing.JCheckBoxMenuItem;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;

import dna.observable.IObservable;
import dna.observable.IObserver;
import dna.observable.ObservableComponent;

public class ExpertGUIMenu implements ActionListener, IObservable
{

	private static ExpertGUIMenu instance = null;
    private ExpertDataModel edm = ExpertDataModel.getInstance();
	private JMenuBar menuBar = new JMenuBar();
	private JMenu fileMenu = new JMenu( "File" );
	private JMenuItem exitItem = new JMenuItem( "Exit" );
	private JMenu screeningMenu = new JMenu( "Screening" );
	private JCheckBoxMenuItem screeningItem = new JCheckBoxMenuItem( "Screening/Ranking" );
	private ObservableComponent observableComponent = new ObservableComponent();

	private ExpertGUIMenu()
	{
		
	}
	
	static public ExpertGUIMenu getInstance()
	{
		if ( instance == null)
		{
			instance = new ExpertGUIMenu();
		}
		return instance;
	}
	
	public void setFrame(JFrame frame) 
	{
		frame.setJMenuBar(menuBar);
		exitItem.addActionListener(this);
		fileMenu.add(exitItem);
		menuBar.add(fileMenu);
		
		if ( ! edm.isScreeningAvailable() )
		{
			screeningMenu.add( screeningItem );
			screeningItem.addActionListener( this );
			menuBar.add( screeningMenu );
			
		}
	}

	public void actionPerformed( ActionEvent evt )
	{
		String arg = evt.getActionCommand();
		if (arg.equals( "Exit" ))
			System.exit(0);
		else if (arg.equals( "Screening/Ranking" ))
		{
			System.out.println( screeningItem.isSelected() );
			if ( screeningItem.isSelected() )
				observableComponent.notifyIObservers(this,
                    "enable_screening_ranking_panels" );
			else
				observableComponent.notifyIObservers(this, 
                	"disable_screening_ranking_panels" );
		}
	}

	   // IObservable

	   public void addIObserver(IObserver anIObserver)
	   {
	      observableComponent.addIObserver(anIObserver);
	   }

	   public void deleteIObserver(IObserver anIObserver)
	   {
	      observableComponent.deleteIObserver(anIObserver);
	   }

	   public void deleteIObservers()
	   {
	      observableComponent.deleteIObservers();
	   }

}
