package dna;

import java.awt.Color;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;

import javax.swing.JFrame;
import javax.swing.UIManager;

import dna.util.Debug;
import dna.util.LocalProperties;
import dna.util.WindowSize;

public class ExpertGUI
   extends JFrame
{
   private static ExpertGUI frame = new ExpertGUI("DNA Expert System");

   public ExpertGUI(String title)
   {
      super(title);
      UIManager.put("Label.foreground", Color.black);
      ExpertDataModel.parseDNAConfiguration();
      getContentPane().add(new ExpertPanel(true));      
   }

   // Main method

   public static void main(String[] args)
   {
      for (int i = 0; i < args.length; i++)
      {
         Debug.check(args[i]);
      }
      
      ExpertGUIMenu menu = ExpertGUIMenu.getInstance();
      menu.setFrame( frame );
      
      setSize();
      frame.show();
      frame.addWindowListener(new WindowAdapter()
      {
         public void windowClosing(WindowEvent ev)
         {
            Expert.stop();
            System.exit(0);
         }
      });
   }

   private static void setSize()
   {
      double fraction = 0.7;
      int width = 800, height = 600;
      String property1, property2;

      if ((property1 = LocalProperties.get("dna.fraction")) != null)
      {
         try
         {
            fraction = Double.parseDouble(property1);
         }
         catch (NumberFormatException nfex)
         {
            Debug.out("Error parsing fractional size for DNA GUI.\n"
               + "Default assumed " + fraction);
         }
         finally
         {
            frame.setSize(new WindowSize(fraction));
         }
      }
      else
      {
         if ((property1 = LocalProperties.get("dna.width")) != null
            && (property2 = LocalProperties.get("dna.height")) != null)
         {
            try
            {
               width = Integer.parseInt(property1);
               height = Integer.parseInt(property2);
            }
            catch (NumberFormatException nfex)
            {
               Debug.out("Error parsing window size for DNA GUI.\n"
                  + "Default assumed " + width + " " + height);
            }
            finally
            {
               frame.setSize(width, height);
            }
         }
      }
   }
}
