
package dna;

import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;

import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.Marshaller;
import org.exolab.castor.xml.Unmarshaller;
import org.exolab.castor.xml.ValidationException;

import stacgui.StacBCM;
import stacgui.Stac_Session;

import dna.observable.IObservable;
import dna.observable.IObserver;
import dna.observable.ObservableComponent;
import dna.util.BravaisLatticeSelector;
import dna.util.Debug;
import dna.util.LocalProperties;
import dna.xml.Bcm_parameters_request;
import dna.xml.Bcm_parameters_response;
import dna.xml.Beam;
import dna.xml.Characterize_crystal_request;
import dna.xml.Collect_reference_request;
import dna.xml.Collect_reference_response;
import dna.xml.Collect_request;
import dna.xml.Default_values;
import dna.xml.Detector;
import dna.xml.Fileinfo;
import dna.xml.Oscillation_sequence;
import dna.xml.Proposal;
import dna.xml.Resolution;
import dna.xml.Server_data;
import dna.xml.Session;
import dna.xml.System_defaults;
import dna.xml.User_defaults;

public class ExpertDataModel
   implements IObserver, IObservable
{
   private static String dnaSystemDefaultsFile = LocalProperties.get("dna.system_defaults");
   private static String dnaUserDefaultsFile = LocalProperties.get("dna.user_defaults");
   private static int referenceImagesTimeout = 120000;
   private static int autoIndexTimeout = 120000;
   private static int strategyTimeout = 120000;

   private ObservableComponent observableComponent = new ObservableComponent();

   private static ExpertDataModel edm = null;
   private static System_defaults system_defaults = new System_defaults();
   private static User_defaults user_defaults = new User_defaults();
   private static Server_data server_data = new Server_data();
   private static Default_values default_values = new Default_values();
   private static Fileinfo fileinfo = new Fileinfo();
   private boolean anomalous = false;
   private double minOscillation = 0.1;
   private double multiplicity = 2.0;
   private String spaceGroup = null;
   private static Oscillation_sequence oscillationSequence;
   private static Server_data system_defaults_server_data;
   private boolean prefixingOn = false;
   private boolean collectOnlyOn = false;
   private String prefixPrefix = "ref-";
   private boolean runNumberOn = false;
   private boolean passesOn = false;
   private String detectors = "adsc marccd mar";
   private boolean databaseAvailable = false;
   private boolean loginPanelAvailable = true;
   private boolean screeningAvailable = true;
   private boolean sampleChangerScannable = false;
   private boolean sampleChangerScanInUse = false;
   private String dnahome = "";
   private String dnaname = "";
   private String file_separator = "";
   private Resolution calculatedResolution = new Resolution();
   private Proposal proposal = null;
   private Session session = null;
   private boolean clearStrategyResolution = true;
   private static boolean kappaAvailable = false;
   private boolean checkScreeningParameters = true;
   private boolean checkReferenceImageParameters = true;
   private boolean checkDataCollectionParameters = false;

   private ExpertDataModel()
   {
      // Get the file separator character, needed for
      // building the path to the ES start and stop scripts.
      file_separator = System.getProperty("file.separator");

      String string = LocalProperties.get("dna.home");
      if (string != null)
         dnahome = string;
      else
         throw new RuntimeException("Error - property dna.home not defined");

      string = LocalProperties.get("dna.name");
      if (string != null)
         dnaname = string;
      else
         throw new RuntimeException("Error - property dna.name not defined");

      string = LocalProperties.get("dna.referenceImagesPrefixPrefix");
      if (string != null)
         prefixPrefix = string;

      string = LocalProperties.get("dna.prefixingOn");
      if (string != null)
         if (string.equals("true"))
            prefixingOn = true;

      string = LocalProperties.get("dna.collectOnlyOn");
      if (string != null)
         if (string.equals("true"))
            collectOnlyOn = true;

      string = LocalProperties.get("dna.runNumber");
      if (string != null)
         if (string.equals("on"))
            runNumberOn = true;

      string = LocalProperties.get("dna.passes");
      if (string != null)
         if (string.equals("on"))
            passesOn = true;

      string = LocalProperties.get("dna.detectors");
      if (string != null)
         detectors = string;

      string = LocalProperties.get("dna.databaseAvailable");
      if (string != null)
         if (string.equals("true"))
            databaseAvailable = true;

      string = LocalProperties.get("dna.loginPanelAvailable");
      if (string != null)
         if (string.equals("false"))
            loginPanelAvailable = false;

      string = LocalProperties.get("dna.screeningAvailable");
      if (string != null)
         if (string.equals("false"))
            screeningAvailable = false;

      //string = LocalProperties.get("dna.kappaAvailable");
      //if (string != null)
      //   if (string.equals("true"))
      //      kappaAvailable = true;

      string = LocalProperties.get("dna.sampleChangerScanInUse");
      if (string != null)
         if (string.equals("true"))
            sampleChangerScanInUse = true;

      string = LocalProperties.get("dna.checkDataCollectionParameters");
      if (string != null)
         if (string.equals("true"))
            checkDataCollectionParameters = true;
   }

   public static ExpertDataModel getInstance()
   {
      if (edm == null)
      {
         edm = new ExpertDataModel();
         parseDNAConfiguration();
         initialiseTimeouts();
         determineKappaAvailibility();
      }

      return edm;
   }

   private static void determineKappaAvailibility()
   {
	  kappaAvailable = system_defaults_server_data.getBcm_kappa_in_use();
	  
	  if (kappaAvailable)
	  {
		  try
		  {  
			  Stac_Session stacSession = new Stac_Session(false);
			  StacBCM stacBCM = new StacBCM(stacSession);
		  }
		  catch (RuntimeException e)
		  {
			  Debug.out("STAC is not configured properly. Kappa functions are disabled.\n"
					  + "Check the java properties file and try again.");
			  kappaAvailable=false;
		  }
		  catch (NoClassDefFoundError e)
		  {
			  Debug.out("STAC is not available. Kappa functions are disabled.\n"
					  + "Check the java properties file and try again.");
			  kappaAvailable=false;
		  }
	  }
   }

   public static void parseDNAConfiguration()
   {
      try
      {
         getInstance();

         FileReader system_defaults_reader = new FileReader(
            dnaSystemDefaultsFile);
         system_defaults = (System_defaults) Unmarshaller.unmarshal(
            System_defaults.class, system_defaults_reader);
         system_defaults_server_data = system_defaults.getServer_data();

         // server_data = system_defaults.getServer_data();
      }
      catch (FileNotFoundException fex)
      {
         Debug.out("Executive DNA system defaults configuration file "
            + dnaSystemDefaultsFile + " not found");
      }
      catch (MarshalException mex)
      {
         Debug.out("MarshallException whilst parsing Executive DNA "
            + "system defaults configuration file:" + mex);
      }
      catch (ValidationException vex)
      {
         Debug.out("ValidationException whilst parsing Executive DNA "
            + "system defaults configuration file");
      }

      try
      {
         getInstance();

         FileReader user_defaults_reader = new FileReader(dnaUserDefaultsFile);
         user_defaults = (User_defaults) Unmarshaller.unmarshal(
            User_defaults.class, user_defaults_reader);

         default_values = user_defaults.getDefault_values();
         fileinfo = default_values.getFileinfo();
         oscillationSequence = default_values.getOscillation_sequence();
         server_data = user_defaults.getServer_data();
      }
      catch (FileNotFoundException fex)
      {
         Debug.out("Executive DNA user defaults configuration file "
            + dnaUserDefaultsFile + " not found");
      }
      catch (MarshalException mex)
      {
         Debug.out("MarshallException whilst parsing Executive DNA "
            + "user defaults configuration file:" + mex);
      }
      catch (ValidationException vex)
      {
         Debug.out("ValidationException whilst parsing Executive DNA "
            + "user defaults configuration file");
      }
   }

   public static void saveDNAConfiguration()
   {
      try
      {
         getInstance();
         FileWriter writer = new FileWriter(dnaUserDefaultsFile);
         Marshaller.marshal((Object) user_defaults, writer);

         //
         // The system default should should not be saved.
         //
         //FileWriter writer2 = new FileWriter(dnaSystemDefaultsFile);
         //Marshaller.marshal((Object) system_defaults, writer2);
      }
      catch (FileNotFoundException fex)
      {
         Debug.out("Executive DNA user defaults configuration file "
            + dnaSystemDefaultsFile + " not found");
      }
      catch (IOException ioex)
      {
         Debug.out("Error creating writer for DNA user defaults configuration file "
            + dnaSystemDefaultsFile);
      }
      catch (MarshalException mex)
      {
         Debug.out("MarshallException whilst parsing Executive DNA "
            + "user defaults configuration file:" + mex);
      }
      catch (ValidationException vex)
      {
         Debug.out("ValidationException whilst parsing Executive DNA "
            + "user defauls configuration file");
      }
   }

   private static void initialiseTimeouts()
   {
      referenceImagesTimeout = initialiseTimeout("dna.referenceImagesTimeout",
         referenceImagesTimeout);
      autoIndexTimeout = initialiseTimeout("dna.autoIndexTimeout",
         autoIndexTimeout);
      strategyTimeout = initialiseTimeout("dna.strategyTimeout",
         strategyTimeout);
   }

   private static int initialiseTimeout(String name, int defaultTimeout)
   {
      String s;
      int timeout = defaultTimeout;

      s = LocalProperties.get(name);
      if (s != null)
      {
         try
         {
            timeout = Integer.parseInt(s);
         }
         catch (NumberFormatException nfex)
         {
            Debug.out("Error getting " + name + " timeout");
         }
      }

      return timeout;
   }

   // Setter and Getters

   private void setFileinfo( Fileinfo fileinfo2 )
   {
   	  this.setFileinfo( fileinfo2.getDirectory(), fileinfo2.getPrefix(), 
   			  fileinfo2.getRun_number() , fileinfo2.getSuffix() );
   }

   public void setFileinfo(String directory, String prefix, int runNumber,
      String suffix)
   {
      fileinfo.setDirectory(directory);
      fileinfo.setPrefix(prefix);
      fileinfo.setRun_number(runNumber);
      fileinfo.setSuffix(suffix);
      observableComponent.notifyIObservers(this, this);
   }

   public void setCalculatedResolution(Resolution calculatedResolution)
   {
      this.calculatedResolution = calculatedResolution;
   }

   public Resolution getCalculatedResolution()
   {
      return calculatedResolution;
   }

   public void setRunNumber(int runNumber)
   {
      fileinfo.setRun_number(runNumber);
      observableComponent.notifyIObservers(this, this);
   }

   public String getSampleIdentifier()
   {
      return default_values.getSample_identifier();
   }

   public void setSampleIdentifier(String sampleIdentifier)
   {
      default_values.setSample_identifier(sampleIdentifier);
   }

   public String getComment()
   {
      return default_values.getComment();
   }

   public void setComment(String comment)
   {
      default_values.setComment(comment);
   }

   public String getDirectory()
   {
      return fileinfo.getDirectory();
   }

   public void setDirectory(String directory)
   {
      fileinfo.setDirectory(directory);
   }

   public String getPrefix()
   {
      return fileinfo.getPrefix();
   }

   public String getRunNumber()
   {
      return Integer.toString(fileinfo.getRun_number());
   }

   public int getValueOfRunNumber()
   {
      return fileinfo.getRun_number();
   }

   public boolean getAnomalous()
   {
      return anomalous;
   }

   /*
    * This method is synchronised to keep consistency when setting the anomalous
    * flags in the GUI from different threads. Please donot remove this
    * synchronization.
    */
   public synchronized void setAnomalous(boolean anomalous)
   {
      this.anomalous = anomalous;
      observableComponent.notifyIObservers(this, this);
   }

   public String getSuffix()
   {
      return fileinfo.getSuffix();
   }

   public String getIncrement()
   {
      return Double.toString(oscillationSequence.getRange());
   }

   public void setIncrement(double increment)
   {
      oscillationSequence.setRange(increment);
   }

   public String getTime()
   {
      return Double.toString(oscillationSequence.getExposure_time());
   }

   public void setTime(double time)
   {
      oscillationSequence.setExposure_time(time);
   }

   public double getMinOscillation()
   {
      return minOscillation;
   }

   /*
    * This method is synchronised to keep consistency when setting the minimum
    * oscillation in the GUI from different threads. Please donot remove this
    * synchronization.
    */
   public synchronized void setMinOscillation(double minOscillation)
   {
      this.minOscillation = minOscillation;
   }

   public double getMultiplicity()
   {
      return multiplicity;
   }
   
   /*
    * This method is synchronised to keep consistency when setting the multiplicity
    * in the GUI from different threads. Please donot remove this
    * synchronization.
    */
   public synchronized void setMultiplicity(double multiplicity)
   {
      this.multiplicity = multiplicity;
   }

   public String getResolution()
   {
      return Double.toString(default_values.getResolution());
   }

   public double getValueOfResolution()
   {
      return default_values.getResolution();
   }

   public void setResolution(double resolution)
   {
      default_values.setResolution(resolution);
   }

   public void setExpertSystemHostName(String name)
   {
      server_data.setExpert_system_host_name(name);
   }

   public void setDPMLogFile(String logFile)
   {
      server_data.setDpm_log_file(logFile);
   }

   public void setDPMExecutable(String executable)
   {
      server_data.setMosflm_executable(executable);
   }

   public int getExpertSystemPortNumber()
   {
      return server_data.getExpert_system_port_number();
   }

   public void setGUIPortNumber(String port)
   {
      server_data.setGui_port_number(Integer.parseInt(port));
   }

   public int getGUIPortNumber()
   {
      return server_data.getGui_port_number();
   }

   public String getBCMHostName()
   {
      return server_data.getBcm_host_name();
   }

   public int getBCMPortNumber()
   {
      return server_data.getBcm_port_number();
   }

   public void setBCMKappaInUse(boolean kappaInUse)
   {
      server_data.setBcm_kappa_in_use(kappaInUse);
   }

   public boolean getBCMKappaInUse()
   {
      return server_data.getBcm_kappa_in_use();
   }

   public void setKappaAvailable(boolean kappaAvailable)
   {
      this.kappaAvailable = kappaAvailable;
   }

   public boolean getKappaAvailable()
   {
      return kappaAvailable;
   }

   public int getReferenceImagesTimeout()
   {
      return referenceImagesTimeout;
   }

   public int getAutoIndexTimeout()
   {
      return autoIndexTimeout;
   }

   public int getStrategyTimeout()
   {
      return strategyTimeout;
   }

   public void setSpaceGroup(String spaceGroup)
   {
      this.spaceGroup = spaceGroup;
   }

   public String getSpaceGroup()
   {
      return spaceGroup;
   }

   public void setDetector(Detector detector)
   {
      default_values.setDetector(detector);
   }

   public Detector getDetector()
   {
      return default_values.getDetector();
   }

   public void setBeam(Beam the_beam)
   {
      default_values.setBeam(the_beam);
   }

   public Beam getBeam()
   {
      Beam beam = default_values.getBeam();
      if (beam == null)
      {
         beam = new Beam();
         beam.setX(90.0);
         beam.setY(90.0);
      }
      return beam;
   }

   public String getESStartScript()
   {
      String esStartScript = dnahome + file_separator + "scripts"
         + file_separator + "start_executive_system";
      Debug.out("Path to ES startup script: " + esStartScript, 2);
      return esStartScript;
   }

   public String getESStopScript()
   {
      String esStopScript = dnahome + file_separator + "scripts"
         + file_separator + "stop_executive_system";
      Debug.out("Path to ES stop script: " + esStopScript, 2);
      return esStopScript;
   }

   public String getDPMLogFile()
   {
      return server_data.getDpm_log_file();
   }

   public String getDPMExecutable()
   {
      return server_data.getMosflm_executable();
   }

   public boolean isRunNumberOn()
   {
      return runNumberOn;
   }

   public boolean isPrefixingOn()
   {
      return prefixingOn;
   }

   public boolean isCollectOnlyOn()
   {
      return collectOnlyOn;
   }

   public boolean isDatabaseAvailable()
   {
      return databaseAvailable;
   }
   
   public boolean isLoginPanelAvailable()
   {
   	  return loginPanelAvailable;
   }

   public boolean isScreeningAvailable()
   {
   	  return screeningAvailable;
   }
   
   public boolean isSampleChangerScanInUse()
   {
      return sampleChangerScanInUse;
   }

   public boolean isPassesOn()
   {
      return passesOn;
   }

   public String getPrefixPrefix()
   {
      return prefixPrefix;
   }

   public String getDetectors()
   {
      return detectors;
   }

   public String getExpertSystemHostName()
   {
      return server_data.getExpert_system_host_name();
   }

   public void setExpertSystemPortNumber(String port)
   {
      server_data.setExpert_system_port_number(Integer.parseInt(port));
   }

   public void setProposal(Proposal proposal)
   {
      this.proposal = proposal;
   }

   public Proposal getProposal()
   {
      return proposal;
   }

   public Session getSession()
   {
      return session;
   }

   public boolean getClearStrategyResolution()
   {
      return clearStrategyResolution;
   }

   public void setClearStrategyResolution(boolean clearStrategyResolution)
   {
      this.clearStrategyResolution = clearStrategyResolution;
   }

   public String getDnaName()
   {
      return dnaname;
   }

   public boolean checkScreeningParameters()
   {
      boolean value = false;
      if (checkDataCollectionParameters)
         if (this.checkScreeningParameters)
            value = true;
      return value;
   }

   public void setCheckScreeningParameters(boolean the_value)
   {
      this.checkScreeningParameters = the_value;
   }

   public boolean checkReferenceImageParameters()
   {
      boolean value = false;
      if (checkDataCollectionParameters)
         if (this.checkReferenceImageParameters)
            value = true;
      return value;
   }

   public void setCheckReferenceImageParameters(boolean the_value)
   {
      this.checkReferenceImageParameters = the_value;
   }

   public void setCharacterize_crystal_request( Characterize_crystal_request ccr )
   {
   	  // Fills in all relevant data for a characterize_crystal_request
   	  this.setAnomalous( ccr.getAnomalous() );
   	  // this.setTarget( ccr.getTarget() );
   	  Collect_reference_request crr = ccr.getCollect_reference_request();
   	  //this.setArchive_reference_images( crr.getArchive_reference_images() );
   	  Collect_request cr = crr.getCollect_request();
   	  Fileinfo fileinfo = cr.getFileinfo();
   	  this.setFileinfo( fileinfo );
   	  this.setResolution( cr.getResolution().getUpper() );
   	  Oscillation_sequence os = cr.getOscillation_sequence( 0 );
   	  this.setIncrement( os.getRange() );
   	  this.setTime( os.getExposure_time() );
   }


   // IObservable

   public void addIObserver(IObserver anIObserver)
   {
      observableComponent.addIObserver(anIObserver);
   }

   public void deleteIObserver(IObserver anIObserver)
   {
      observableComponent.deleteIObserver(anIObserver);
   }

   public void deleteIObservers()
   {
      observableComponent.deleteIObservers();
   }

   // IObserver

   public void update(Object iObservable, Object arg)
   {
      if (iObservable instanceof BravaisLatticeSelector)
      {
         spaceGroup = (String) arg;
      }
      else if (arg instanceof Proposal)
      {
         proposal = (Proposal) arg;
         observableComponent.notifyIObservers(this, proposal);
      }
      else if (arg instanceof Session)
      {
         this.session = (Session) arg;
      }
   }


}
