package dna;

import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.io.IOException;
import java.net.URL;

import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;

public class ExpertCollectPanel
   extends JPanel
{
   private JEditorPane html = null;
   private JScrollPane pane = null;

   public ExpertCollectPanel()
   {
      setLayout(new GridBagLayout());
      GridBagConstraints c = new GridBagConstraints();
      c.fill = GridBagConstraints.BOTH;
      c.gridx = 0;
      c.gridy = 0;
      c.gridwidth = 1;
      c.gridheight = 1;
      c.weightx = 1;
      c.weighty = 1;

      new ProgressHelper(this);

      html = new JEditorPane();
      html.setEditable(false);
      pane = new JScrollPane(html, JScrollPane.VERTICAL_SCROLLBAR_ALWAYS,
         JScrollPane.HORIZONTAL_SCROLLBAR_ALWAYS);
      if (pane != null)
         add(pane, c);

      html.addHyperlinkListener(new HyperlinkListener()
      {
         public void hyperlinkUpdate(HyperlinkEvent evt)
         {
            if (evt.getEventType() == HyperlinkEvent.EventType.ACTIVATED)
            {
               URL thisPage = html.getPage();
               try
               {
                  html.setPage(evt.getURL());
               }
               catch (IOException e)
               {
                  System.out.println("Page switch failed - revert to old page");
                  try
                  {
                     html.setPage(thisPage);
                  }
                  catch (IOException ioexc)
                  {
                     System.out.println("Failed to revert to old page");
                  }
               }
            }
         }
      });

   }

   public void updateProgress(String url)
   {
      try
      {
         html.setPage(url);
      }
      catch (Exception ex)
      {
         System.out.println("Exception " + ex.getMessage());
      }
   }
}
