package dna;

import java.awt.Color;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;

import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;

import dna.observable.IObservable;
import dna.observable.IObserver;
import dna.observable.ObservableComponent;
import dna.util.Debug;
import dna.util.LocalProperties;
import dna.util.TitleBorder;
import dna.xml.Feedback_request;

public class ExpertButtonPanel
   extends JPanel
   implements ActionListener, IObservable, Runnable
{
   private ExpertDataModel edm = ExpertDataModel.getInstance();
   private ExpertPanel expertPanel = null;
   private ObservableComponent observableComponent = new ObservableComponent();
   private Feedback_request feedback_request = new Feedback_request();
   private FeedbackHelper feedbackHelper = new FeedbackHelper();
   
   static final int kappaOn = 1;
   static final int kappaOff = 2;
   private JPanel kappaPanel = new JPanel();
   ButtonGroup kappaGroup = new ButtonGroup();
   JRadioButton kappaOnButton = new JRadioButton("On");
   JRadioButton kappaOffButton = new JRadioButton("Off");
   
   JButton help = new JButton("Help");
   JButton abort = new JButton("Abort");
   JButton submitFeedback = new JButton("Submit Feedback");

   private Runtime runtime = Runtime.getRuntime();

   public ExpertButtonPanel(boolean quitButtonOn, ExpertPanel expertPanel)
   {
      this.expertPanel = expertPanel;
      
      if (edm.getBCMKappaInUse())
      {
         kappaOnButton.setSelected(true);
      }
      else
      {
         kappaOffButton.setSelected(true);
      }
      kappaOnButton.addActionListener(this);
      kappaOffButton.addActionListener(this);
      kappaPanel.setLayout(new BoxLayout(kappaPanel, BoxLayout.X_AXIS));
      kappaPanel.setBorder(BorderFactory.createEtchedBorder());
      kappaPanel.add(new JLabel("Kappa Strategy"));
      kappaPanel.add(kappaOnButton);
      kappaPanel.add(kappaOffButton);
      kappaGroup.add(kappaOnButton);
      kappaGroup.add(kappaOffButton);
      
      help.addActionListener(this);
      abort.addActionListener(this);
      submitFeedback.addActionListener(this);
      abort.setBackground(Color.RED);
     
      setLayout(new GridBagLayout());
      setBorder(new TitleBorder("Control"));
      GridBagConstraints c = new GridBagConstraints();
      c.gridx = GridBagConstraints.RELATIVE;
      c.insets = new Insets(2, 2, 2, 2);
      c.weightx = 0.0;
      c.gridy = 0;
      
      if (edm.getKappaAvailable())
      {
         c.gridy++;
         add(new JLabel(""), c);
         add(kappaPanel, c);
      }

      c.gridy++;
      add(help, c);
      add(submitFeedback, c);
      c.weightx = 1.0;
      c.anchor = GridBagConstraints.EAST;
      add(abort, c);
   }

   // ActionListener

   public void actionPerformed(ActionEvent e)
   {
      if (e.getActionCommand().equals("Help"))
      {
         String command = LocalProperties.get("dna.help");
         if (command != null)
         {
            runtime = Runtime.getRuntime();
            try
            {
               runtime.exec(command);
            }
            catch (IOException ioex)
            {
               new ErrorDialog(this, "Help command \'" + command
                  + "\' failed to start.\n", ioex, "DNA help");
            }
         }
         else
         {
            new ErrorDialog(this, "Help command not set up.\n"
               + "Someone needs to set the Java property dna.help.", "DNA help");
         }
      }
      else if (e.getActionCommand().equals("Abort"))
      {
         ExpertProxy.getInstance().sendToExpert("/abort", "<abort/>");
         // Notify to reset GUI
         observableComponent.notifyIObservers(this, new ExpertState(
            ExpertState.ABORTED));
      }
      else if (e.getActionCommand().equals("Submit Feedback"))
      {
         SubmitFeedback er = new SubmitFeedback(this);
         if (er.isSubmitFeedbackCreated())
         {
            JCheckBox[] checkBoxList = er.getCheckBoxList();
            Document commentDocument = er.getCommentDocument();
            Document emailDocument = er.getEmailDocument();
            
            try
            {
               int causeCount = 0;
               for (int i = 0; i < checkBoxList.length; i++)
               {
                  if (checkBoxList[i].isSelected())
                  {
                     feedback_request.addCause(causeCount, checkBoxList[i].getName());
                     Debug.out(checkBoxList[i].getName() + " selected");
                     causeCount++;
                  }
               }

               feedback_request.setComments(commentDocument.getText(0, commentDocument.getLength()));
               feedback_request.setContact_email(emailDocument.getText(0, emailDocument.getLength()));
               new Thread(this).start();            
            }
            catch (BadLocationException e1)
            {
               e1.printStackTrace();
            }
         }
      }
      else if (e.getActionCommand().equals("On"))
      {
         edm.setBCMKappaInUse(true);
         if (expertPanel != null)
         {
            expertPanel.update(null, "update_strategy_panel");
         }
         edm.saveDNAConfiguration();
      }
      else if (e.getActionCommand().equals("Off"))
      {
         edm.setBCMKappaInUse(false);
         if (expertPanel != null)
         {
            expertPanel.update(null, "update_strategy_panel");
         }
         edm.saveDNAConfiguration();
      }
   }
   
   public void run()
   {
      Debug.out("In run()");
         try
         {
            feedbackHelper.sendFeedback_request(feedback_request);
         }
         catch (FeedbackException ex)
         {
            MessagePanel messagePanel = MessagePanel.getInstance();
            messagePanel.appendText("Error caught in Submit Feedback");
            messagePanel.appendText(ex.getMessage());
            new ErrorDialog(this, ex, "SubmitFeedback");
         }
      }
   // IObservable

   public void addIObserver(IObserver anIObserver)
   {
      observableComponent.addIObserver(anIObserver);
   }

   public void deleteIObserver(IObserver anIObserver)
   {
      observableComponent.deleteIObserver(anIObserver);
   }

   public void deleteIObservers()
   {
      observableComponent.deleteIObservers();
   }
}