package dna;

import java.io.IOException;

import dna.util.Debug;
import dna.util.Sleep;

public class Expert
{
   private static Runtime runtime = Runtime.getRuntime();
   private static Process process = null;

   public Expert()
   {
   }

   public static void start()
   {
      ExpertDataModel edm = ExpertDataModel.getInstance();
      try
      {
         Expert.stop();
         Sleep.sleep(4000);
         process = runtime.exec(edm.getESStartScript());
         // Sleep.sleep(2000);
         Debug.out("Started the DNA expert system", 1);
      }
      catch (IOException ex)
      {
         Debug.out("Error starting DNA expert system");
      }
   }

   public static void stop()
   {
      ExpertDataModel edm = ExpertDataModel.getInstance();
      try
      {
         runtime.exec(edm.getESStopScript());
         if (process != null)
            process.destroy();
         Debug.out("Stopped the DNA expert system", 1);
      }
      catch (IOException ex)
      {
         Debug.out("Error stopping DNA expert system");
      }
   }
}
