package dna;

import java.io.StringReader;

import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.Unmarshaller;
import org.exolab.castor.xml.ValidationException;

import dna.observable.IObservable;
import dna.observable.IObserver;
import dna.observable.ObservableComponent;
import dna.util.Debug;
import dna.xml.Gui_display_es_status_request;

class ExecutiveSystemStatusResponsesHandler
   implements ExpertListener, IObservable
{
   private ExpertDataModel edm = ExpertDataModel.getInstance();
   private ObservableComponent observableComponent = new ObservableComponent();

   private String _callbackStatus = "ok";
   private ExecutiveSystemStatusPanel esStatusPanel;
   private Gui_display_es_status_request gui_display_es_status_request = null;

   public ExecutiveSystemStatusResponsesHandler(
      ExecutiveSystemStatusPanel esStatusPanel)
   {
      this.esStatusPanel = esStatusPanel;
      addIObserver(edm);
   }

   // ExpertListener

   public synchronized void expertMessage(ExpertXMLMessage the_message)
   {
      String content;
      String path = the_message.getPath();
      String xml_message = the_message.getXMLMessage();
      StringReader reader = new StringReader(the_message.getXMLMessage());

      if (path.equals("/gui_display_es_status_request"))
      {

         Debug.out("Display ES status request received", 1);
         try
         {
            gui_display_es_status_request = (Gui_display_es_status_request) Unmarshaller.unmarshal(
               Gui_display_es_status_request.class, reader);
            if (gui_display_es_status_request.getBcm_status() != null)
               esStatusPanel.setBCMStatus(gui_display_es_status_request.getBcm_status());
            if (gui_display_es_status_request.getDpm_status() != null)
               esStatusPanel.setDPMStatus(gui_display_es_status_request.getDpm_status());
         }
         catch (MarshalException mex)
         {
            Debug.out("MarshallException: " + mex, 2);
            _callbackStatus = "MarshalException in "
               + "DbResponsesHandler.expertMessage";
         }
         catch (ValidationException vex)
         {
            Debug.out("ValidationException: " + vex, 2);
            _callbackStatus = "ValidationException in "
               + "DbResponsesHandler.expertMessage";
         }
      }
   }

   // IObservable

   public void addIObserver(IObserver anIObserver)
   {
      observableComponent.addIObserver(anIObserver);
   }

   public void deleteIObserver(IObserver anIObserver)
   {
      observableComponent.deleteIObserver(anIObserver);
   }

   public void deleteIObservers()
   {
      observableComponent.deleteIObservers();
   }
}
