package dna;

import java.awt.Color;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;

import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

import dna.observable.IObservable;
import dna.observable.IObserver;
import dna.observable.ObservableComponent;
import dna.util.TitleBorder;
import dna.xml.Status;

public class ExecutiveSystemStatusPanel
   extends JPanel
   implements IObservable
{
   private ObservableComponent observableComponent = new ObservableComponent();
   private static ExecutiveSystemStatusPanel essp = null;

   private Runtime runtime = Runtime.getRuntime();
   private static TitleBorder border = new TitleBorder("Feedback");
   private ProgressPanel progress = new ProgressPanel();

   private JPanel bcmPanel = new JPanel();
   private JLabel bcmLabel = new JLabel("Collection status:");
   private JTextField bcmStatus = new JTextField(
      "Unknown - GUI not connected to Executive System");

   private JPanel dpmPanel = new JPanel();
   private JLabel dpmLabel = new JLabel("Processing status:");
   private JTextField dpmStatus = new JTextField(
      "Unknown - GUI not connected to Executive System");
   private boolean bcmIdle = true;
   private boolean dpmIdle = true;
   private int idleCount = 0;
 
 	private ExecutiveSystemStatusPanel()
   {
      bcmStatus.setEditable(false);
      dpmStatus.setEditable(false);
      setBorder(border);
      setLayout(new GridBagLayout());

      GridBagConstraints c = new GridBagConstraints();
      c.gridx = 0;
      c.weightx = 0.0;
      c.fill = GridBagConstraints.NONE;
      c.anchor = GridBagConstraints.WEST;
      
      c.insets = new Insets(0, 5, 0, 5);
      bcmLabel.setFont(new Font("Dialog", Font.BOLD, 14));
      add(bcmLabel, c);

      bcmStatus.setFont(new Font("Dialog", Font.BOLD, 14));
      bcmStatus.setBackground(Color.red);
      c.gridx++;
      c.weightx = 1.0;
      c.fill = GridBagConstraints.HORIZONTAL;
      add(bcmStatus, c);

      dpmLabel.setFont(new Font("Dialog", Font.BOLD, 14));
      c.gridx = 0;
      c.weightx = 0.0;
      c.fill = GridBagConstraints.NONE;
      add(dpmLabel, c);

      dpmStatus.setFont(new Font("Dialog", Font.BOLD, 14));
      dpmStatus.setBackground(Color.red);
      c.gridx++;
      c.weightx = 1.0;
      c.fill = GridBagConstraints.HORIZONTAL;
      add(dpmStatus, c);
   }
   
   public static ExecutiveSystemStatusPanel getInstance()
   {
      if (essp == null)
      {
         essp = new ExecutiveSystemStatusPanel();
      }

      return essp;
   }

   public void setBCMStatus(Status bcm_status)
   {
      bcmStatus.setText(bcm_status.getMessage());
      if (bcm_status.getMessage().equals("Ready"))
      {
         bcmStatus.setBackground(Color.green);
         bcmIdle = true;
      }
      else
      {
         bcmStatus.setBackground(Color.yellow);
         bcmIdle = false;
         idleCount = 0;
      }
   }

   public void setDPMStatus(Status dpm_status)
   {
      dpmStatus.setText(dpm_status.getMessage());
      if (dpm_status.getMessage().equals("Ready"))
      {
         dpmStatus.setBackground(Color.green);
         dpmIdle = true;
      }
      else
      {
         dpmStatus.setBackground(Color.yellow);
         dpmIdle = false;
         idleCount = 0;
      }
   }
   
   public void setSessionInfo()
   {
      ExpertDataModel edm = ExpertDataModel.getInstance();
      if (edm.getProposal() != null)
      {
         String proposalCode = edm.getProposal().getCode();
         int proposalNumber = edm.getProposal().getNumber();
         border.setTitle("Feedback for PROPOSAL : " + proposalCode
            + proposalNumber);
         repaint();
      }
   }

   public void addIObserver(IObserver anIObserver)
   {
      observableComponent.addIObserver(anIObserver);
   }

   public void deleteIObserver(IObserver anIObserver)
   {
      observableComponent.deleteIObserver(anIObserver);
   }

   public void deleteIObservers()
   {
      observableComponent.deleteIObservers();
   }
}
