package dna;

import gnu.regexp.RE;
import gnu.regexp.REException;
import gnu.regexp.REMatch;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.StringReader;

import javax.swing.BorderFactory;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.border.TitledBorder;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultHighlighter;
import javax.swing.text.Document;
import javax.swing.text.Highlighter;

import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.Unmarshaller;
import org.exolab.castor.xml.ValidationException;

import dna.observable.IObservableJPanel;
import dna.util.Debug;
import dna.xml.Gui_message;

class DnaMessageOutput
   extends IObservableJPanel
   implements MouseListener, ExpertListener
{
   private JTextArea textOutput = null;
   private String text = null;
   private JPopupMenu popup;
   private JScrollPane pane;
   private String _callbackStatus = "ok";
   private String find = null;
   private int found = 0;
   private Highlighter.HighlightPainter highlightPainter;
   JMenuItem findNextItem = new JMenuItem("FindNext");

   public DnaMessageOutput()
   {
      initialise(null);
   }

   public DnaMessageOutput(String title)
   {
      initialise(title);
   }

   public void initialise(String title)
   {
      highlightPainter = new DefaultHighlighter.DefaultHighlightPainter(
         Color.RED);
      pane = new JScrollPane();
      textOutput = new JTextArea();
      textOutput.setRows(10);
      // textOutput.setEditable(false);
      textOutput.setFont(new Font("courier", Font.PLAIN, 12));
      pane.setViewportView(textOutput);

      setLayout(new BorderLayout());
      setBorder(BorderFactory.createTitledBorder(
         BorderFactory.createEtchedBorder(), title, TitledBorder.LEFT,
         TitledBorder.TOP, null, Color.black));
      add(pane, BorderLayout.CENTER);
      popup = createPopup();
      textOutput.addMouseListener(this);
   }

   private JPopupMenu createPopup()
   {
      JMenuItem mi;
      popup = new JPopupMenu("Output");

      mi = popup.add(new JMenuItem("Clear"));
      mi.addActionListener(new ActionListener()
      {
         public void actionPerformed(ActionEvent ev)
         {
            textOutput.setText("");
            notifyIObservers(this, "Clear");
         }
      });

      mi = popup.add(new JMenuItem("Find"));
      mi.addActionListener(new ActionListener()
      {
         public void actionPerformed(ActionEvent ev)
         {
            found = -1;
            find = JOptionPane.showInputDialog(getTopLevelAncestor(),
               "Enter pattern to find");
            if (find != null && (find.length() > 0))
            {
               findText(find);
            }
            else
            {
               popupError("No text to find.");
               findNextItem.setEnabled(false);
            }
         }
      });

      findNextItem.setEnabled(false);
      mi = popup.add(findNextItem);
      mi.addActionListener(new ActionListener()
      {
         public void actionPerformed(ActionEvent ev)
         {
            if (find != null && (find.length() > 0))
            {
               findText(find);
            }
            else
            {
               popupError("No text to find.");
            }
         }
      });

      return popup;
   }

   private void popupError(String text)
   {
      new ErrorDialog(this, text, "Message Output");
   }

   private void findText(String find)
   {
      String text = textOutput.getText();

      if (text != null && (text.length() > 0))
      {
         try
         {
            RE re = new RE(find);
            REMatch match = re.getMatch(text, found + 1);

            if (match != null)
            {
               findNextItem.setEnabled(true);
               found = match.getStartIndex();
               Highlighter highlighter = textOutput.getHighlighter();
               Document doc = textOutput.getDocument();
               try
               {
                  highlighter.removeAllHighlights();
                  highlighter.addHighlight(found, found
                     + match.toString().length(), highlightPainter);
               }
               catch (BadLocationException ex)
               {
               }
               textOutput.setCaretPosition(found);
            }
            else
            {
               findNextItem.setEnabled(false);
               popupError("Pattern not found.");
            }
         }
         catch (REException rex)
         {
            popupError(rex.getMessage());
         }
      }
      else
      {
         popupError("No text to search.");
      }
   }

   public void appendText(String text)
   {
      appendAndScrollToEnd(text);
   }

   private void appendAndScrollToEnd(String text)
   {
      if (textOutput != null && text != null)
      {
         int totalLength = textOutput.getDocument().getLength();
         totalLength += text.length();
         ;
         if (totalLength > 99000)
         {
            textOutput.replaceRange("", 1, (totalLength - 99000));
         }
         textOutput.append(text + "\n");
         textOutput.setCaretPosition(textOutput.getDocument().getLength());
      }
   }

   // public static void appendTextLater (String txt)
   // {
   // text = txt;
   // SwingUtilities.invokeLater (new Runnable() {
   // public void run ()
   // {
   // appendText (text);
   // }
   // });
   // }

   // ExpertListener

   public synchronized void expertMessage(ExpertXMLMessage the_message)
   {
      Gui_message gui_message;
      String content;
      String path = the_message.getPath();

      if (path.equals("/message"))
      {
         Debug.out("Message received", 2);
         String xml_message = the_message.getXMLMessage();
         Debug.out(xml_message, 2);
         StringReader reader = new StringReader(the_message.getXMLMessage());
         try
         {
            gui_message = (Gui_message) Unmarshaller.unmarshal(
               Gui_message.class, reader);
            content = gui_message.getContent();
            appendText(content);
         }
         catch (MarshalException ex)
         {
            _callbackStatus = "MasrhalException in "
               + "DnaMessageOutput.expertMessage";
         }
         catch (ValidationException ex)
         {
            _callbackStatus = "ValidationException in "
               + "DnaMessageOutput.expertMessage";
         }
      }
   }

   // MouseListener

   public void mousePressed(MouseEvent me)
   {
      if (me.isPopupTrigger())
         popup.show(textOutput, me.getPoint().x, me.getPoint().y);
   }

   public void mouseReleased(MouseEvent me)
   {
      if (me.isPopupTrigger())
         popup.show(textOutput, me.getPoint().x, me.getPoint().y);
   }

   public void mouseClicked(MouseEvent me)
   {
      if (me.isPopupTrigger())
         popup.show(textOutput, me.getPoint().x, me.getPoint().y);
   }

   public void mouseEntered(MouseEvent me)
   {
   }

   public void mouseExited(MouseEvent me)
   {
   }
}
