package dna;

import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.StringTokenizer;

import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

import dna.util.TitleBorder;
import dna.xml.Beam;
import dna.xml.Detector;

public class DefaultValues
   extends JPanel
{
   private ExpertDataModel edm = ExpertDataModel.getInstance();

   private GridBagConstraints c = new GridBagConstraints();
   private JComboBox detectorType;
   private JTextField xBeam = new JTextField(6);
   private JTextField yBeam = new JTextField(6);

   public DefaultValues()
   {
      setLayout(new GridBagLayout());
      c.insets = new Insets(2, 5, 2, 5); // Top, Left, Bottom, Right
      populate();
      update();
   }

   private void populate()
   {
      setBorder(new TitleBorder("Data Collection Parameters"));
      c.gridx = GridBagConstraints.RELATIVE;
      c.gridy = 1;
      detectorType = createDetectorCombo();
      addElement("Detector type", detectorType);
      c.gridy++;
      addElement("Beam centre X", xBeam);
      c.gridy++;
      addElement("Beam centre Y", yBeam);
   }

   private void addElement(String label, JComponent element)
   {
      c.anchor = GridBagConstraints.EAST;
      add(new JLabel(label), c);
      c.anchor = GridBagConstraints.CENTER;
      add(new JLabel("="), c);
      c.anchor = GridBagConstraints.WEST;
      add(element, c);
   }

   private JComboBox createDetectorCombo()
   {
      JComboBox detectorCombo = new JComboBox();
      StringTokenizer st = new StringTokenizer(edm.getDetectors(), " ");
      String detector;

      while (st.hasMoreTokens())
      {
         detectorCombo.addItem(st.nextToken());
      }

      return detectorCombo;
   }

   public void update()
   {
      detectorType.setSelectedItem((edm.getDetector()).getType());
      xBeam.setText(Double.toString(edm.getBeam().getX()));
      yBeam.setText(Double.toString(edm.getBeam().getY()));
   }

   public boolean saveDataModel()
   {
      boolean success = false;

      Beam beam = new Beam();
      Detector detector = new Detector();

      String beamXString = xBeam.getText();
      String beamYString = yBeam.getText();
      detector.setType((String) detectorType.getSelectedItem());
      edm.setDetector(detector);

      if ((beamXString.length() != 0) && (beamYString.length() != 0))
      {
         try
         {
            beam.setX(Double.parseDouble(beamXString));
            beam.setY(Double.parseDouble(beamYString));
            edm.setBeam(beam);
            success = true;
            ExpertDataModel.saveDNAConfiguration();
         }
         catch (NumberFormatException nfe)
         {
            new ErrorDialog(this, "Beam X and/or Y is not a number.\n"
               + "enter a valid beam position.", "AutoIndex");
         }
      }
      else
      {
         new ErrorDialog(this, "Empty strings in Data Collection Parameters.\n"
            + "All fields must have a value.", "AutoIndex");
      }
      return success;
   }
}
