package dna;

import java.io.StringReader;

import javax.swing.JOptionPane;

import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.Unmarshaller;
import org.exolab.castor.xml.ValidationException;

import dna.observable.IObservable;
import dna.observable.IObserver;
import dna.observable.ObservableComponent;
import dna.util.Debug;
import dna.xml.DataRankProjectDNA;
import dna.xml.Loaded_samples_request;
import dna.xml.Loaded_samples_response;
import dna.xml.Login_info;
import dna.xml.Proposal;
import dna.xml.Proposal_response;
import dna.xml.Rank_response;
import dna.xml.Screen_response;
import dna.xml.Session;
import dna.xml.types.Status_code;

class DbResponsesHandler
   implements ExpertListener, IObservable
{
   private ExpertDataModel edm = ExpertDataModel.getInstance();
   private ObservableComponent observableComponent = new ObservableComponent();

   private String _callbackStatus = "ok";
   private LoginPanel loginPanel;
   private SampleScreeningPanel screeningPanel;
   private RankingPanel rankingPanel;
   private SampleScreeningDataPanel screeningDataPanel;
   private RankingDataPanel rankingDataPanel;
   private Proposal_response proposal_response = null;
   private Loaded_samples_response loaded_samples_response = null;
   private Screen_response screen_response = null;
   private Rank_response rank_response = null;
   private DbHelper dbHelper = DbHelper.getInstance();
   private Loaded_samples_request loaded_samples_request;

   public DbResponsesHandler(LoginPanel loginPanel,
      SampleScreeningPanel screeningPanel, RankingPanel rankingPanel)
   {
      this.loginPanel = loginPanel;
      this.screeningPanel = screeningPanel;
      this.screeningDataPanel = screeningPanel.getScreeningDataPanel();
      this.rankingPanel = rankingPanel;
      this.rankingDataPanel = rankingPanel.getRankingDataPanel();
      addIObserver(edm);
   }

   // ExpertListener

   public synchronized void expertMessage(ExpertXMLMessage the_message)
   {
      String content;
      String path = the_message.getPath();
      String xml_message = the_message.getXMLMessage();
      StringReader reader = new StringReader(the_message.getXMLMessage());

      if (path.equals("/proposal_response"))
      {
         Debug.out("Proposal Response received", 1);
         this.loginPanel.activate();
         try
         {
            proposal_response = (Proposal_response) Unmarshaller.unmarshal(
               Proposal_response.class, reader);
            Status_code code = proposal_response.getStatus().getCode();
            if (code.getType() == Status_code.OK_TYPE)
            {
               loginPanel.getSessions(proposal_response);
               observableComponent.notifyIObservers(this,
                  proposal_response.getProposal());

               edm.setProposal(proposal_response.getProposal());
               edm.setCheckReferenceImageParameters( true );
               edm.setCheckScreeningParameters( true );
               ExecutiveSystemStatusPanel.getInstance().setSessionInfo();
               // observableComponent.notifyIObservers(
               // this,
               // new ExpertState(ExpertState.DISPLAY_PROPOSALING_SOLUTION));
               //
               // This is a fix for bug 1478, i.e. the loaded samples request
               // should
               // be sent automatically if "isSampleChangerScanInUse" is false.
               //
               if (!edm.isSampleChangerScanInUse())
               {
                  try
                  {
                     Debug.out("Getting loaded samples for proposal id: "
                        + edm.getProposal().getProposalId(), 1);
                     loaded_samples_request = new Loaded_samples_request();
                     loaded_samples_request.setProposal(edm.getProposal());
                     Debug.out("Trying to send loaded_samples_request", 1);
                     dbHelper.sendLoaded_samples_request(loaded_samples_request);
                  }
                  catch (CollectException ex)
                  {
                     System.out.println("CollectException caught: "
                        + ex.getMessage());
                  }
               }
            }
         }
         catch (MarshalException mex)
         {
            Debug.out("MarshallException: " + mex, 2);
            _callbackStatus = "MarshalException in "
               + "DbResponsesHandler.expertMessage";
         }
         catch (ValidationException vex)
         {
            Debug.out("ValidationException: " + vex, 2);
            _callbackStatus = "ValidationException in "
               + "DbResponsesHandler.expertMessage";
         }
      }
      else if (path.equals("/login_info_request"))
      {
         Debug.out("Login info request received", 1);
         if ( ! edm.isLoginPanelAvailable() )
         {
	         try
	         {
	            Login_info login_info = (Login_info) Unmarshaller.unmarshal(
	            		Login_info.class, reader);
	            Proposal oldProposal = edm.getProposal();
	            Proposal newProposal = login_info.getProposal();
	            String message = null;
	            if ( oldProposal == null )
	            {
	        		message = "You are logged in as " + newProposal.getCode() + newProposal.getNumber(); 
	            }	
	            else if ( ( ! oldProposal.getCode().equals( newProposal.getCode() ) ) ||
	            	      ( oldProposal.getNumber() != newProposal.getNumber() ) )
	            {
	                message = "You were logged in as " + oldProposal.getCode() + oldProposal.getNumber() + "\n\n" +
	                		"You are now logged in as " + newProposal.getCode() + newProposal.getNumber(); 
	            }
	            if ( message != null )
	            {
	                JOptionPane.showMessageDialog( this.loginPanel.getTopLevelAncestor(), message, 
	                		"DNA login info", JOptionPane.INFORMATION_MESSAGE);
		            edm.setProposal( newProposal );
		            Session session = new Session();
		            session.setSessionId( login_info.getSessionId() );
		            observableComponent.notifyIObservers(this, session);
		            edm.setCheckReferenceImageParameters( true );
		            edm.setCheckScreeningParameters( true );
		            ExecutiveSystemStatusPanel.getInstance().setSessionInfo();
	            }
	         }
	         catch (MarshalException mex)
	         {
	            Debug.out("MarshallException: " + mex, 2);
	            _callbackStatus = "MarshalException in "
	               + "DbResponsesHandler.expertMessage";
	         }
	         catch (ValidationException vex)
	         {
	            Debug.out("ValidationException: " + vex, 2);
	            _callbackStatus = "ValidationException in "
	               + "DbResponsesHandler.expertMessage";
	         }
         }
      }
      else if (path.equals("/loaded_samples_response"))
      {
         Debug.out("Loaded Samples Response received", 1);
         try
         {
            loaded_samples_response = (Loaded_samples_response) Unmarshaller.unmarshal(
               Loaded_samples_response.class, reader);
            screeningDataPanel.updateSamples(loaded_samples_response,
               false);
            screeningPanel.activate();
         }
         catch (MarshalException mex)
         {
            Debug.out("MarshallException: " + mex, 2);
            _callbackStatus = "MarshalException in "
               + "DbResponsesHandler.expertMessage";
         }
         catch (ValidationException vex)
         {
            Debug.out("ValidationException: " + vex, 2);
            _callbackStatus = "ValidationException in "
               + "DbResponsesHandler.expertMessage";
         }
      }
      else if (path.equals("/screen_response"))
      {
         Debug.out("Screen response received", 1);
         try
         {
            screen_response = (Screen_response) Unmarshaller.unmarshal(
               Screen_response.class, reader);
            this.screeningPanel.activate();
         }
         catch (MarshalException mex)
         {
            Debug.out("MarshallException: " + mex, 2);
            _callbackStatus = "MarshalException in "
               + "DbResponsesHandler.expertMessage";
         }
         catch (ValidationException vex)
         {
            Debug.out("ValidationException: " + vex, 2);
            _callbackStatus = "ValidationException in "
               + "DbResponsesHandler.expertMessage";
         }
         observableComponent.notifyIObservers(this, new ExpertState(
	               ExpertState.IDLE));
         this.notify();
      }
      else if (path.equals("/rank_response"))
      {
         Debug.out("rank response received", 1);
         try
         {
            rank_response = (Rank_response) Unmarshaller.unmarshal(
               Rank_response.class, reader);
            DataRankProjectDNA dataRankProjectDNA = rank_response.getDataRankProjectDNA();
            if (dataRankProjectDNA != null)
            {
               this.rankingDataPanel.importDataRankProjectDNA(dataRankProjectDNA);
               this.rankingPanel.activate();
            }
         }
         catch (MarshalException mex)
         {
            Debug.out("MarshallException: " + mex, 2);
            _callbackStatus = "MarshalException in "
               + "DbResponsesHandler.expertMessage";
         }
         catch (ValidationException vex)
         {
            Debug.out("ValidationException: " + vex, 2);
            _callbackStatus = "ValidationException in "
               + "DbResponsesHandler.expertMessage";
         }
      }
   }

   // IObservable

   public void addIObserver(IObserver anIObserver)
   {
      observableComponent.addIObserver(anIObserver);
   }

   public void deleteIObserver(IObserver anIObserver)
   {
      observableComponent.deleteIObserver(anIObserver);
   }

   public void deleteIObservers()
   {
      observableComponent.deleteIObservers();
   }
}
