package dna;

import java.io.StringReader;
import java.io.StringWriter;

import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.Unmarshaller;
import org.exolab.castor.xml.ValidationException;

import dna.util.Debug;
import dna.xml.Loaded_samples_request;
import dna.xml.Loaded_samples_response;
import dna.xml.Proposal;
import dna.xml.Proposal_response;
import dna.xml.Rank_request;
import dna.xml.Screen_response;
import dna.xml.Session;
import dna.xml.Set_rank_engine_request;

public class DbHelper
//implements ExpertListener
{
   private static DbHelper dbHelper = null;
   private ExpertClientHTTPServer httpServer = ExpertClientHTTPServer.getGUIServer();
   private String callbackStatus = "ok";
   private ExpertProxy expertProxy = ExpertProxy.getInstance();
   private Proposal_response proposal_response = null;
   private Loaded_samples_response loaded_samples_response = null;
   private Screen_response screen_response = null;
   private Session[] sessionArray;
   private int sessionCount;
   private String illegalChars = "'\r'";

   private DbHelper()
   {
//	   httpServer.addExpertListener(this);
   }
   
   public static synchronized DbHelper getInstance()
   {
	   if ( dbHelper == null )
	   {
		   DbHelper.dbHelper = new DbHelper();
	   }
	   return DbHelper.dbHelper;	   
   }   

   public void sendProposal_request(Proposal proposal) throws CollectException
   {
      StringWriter stringWriter = new StringWriter();
      try
      {
         proposal.marshal(stringWriter);
         String xml_string = stringWriter.toString();
         expertProxy.sendToExpert("/proposal_request", xml_string);
      }
      catch (MarshalException mex)
      {
         throw new CollectException("MarshalException in "
            + "CollectHelper.sendProposal_request: " + mex);
      }
      catch (ValidationException vex)
      {
         throw new CollectException("ValidationException in "
            + "ProposalHelper.sendProposal_request: " + vex);
      }
   }

   public void sendLoaded_samples_request(
      Loaded_samples_request loaded_samples_request) throws CollectException
   {
      StringWriter stringWriter = new StringWriter();
      try
      {
         loaded_samples_request.marshal(stringWriter);
         String xml_string = stringWriter.toString();
         expertProxy.sendToExpert("/loaded_samples_request", xml_string);
      }
      catch (MarshalException mex)
      {
         throw new CollectException("MarshalException in "
            + "CollectHelper.sendSample_request: " + mex);
      }
      catch (ValidationException vex)
      {
         throw new CollectException("ValidationException in "
            + "ProposalHelper.sendSample_request: " + vex);
      }
   }

   public Screen_response sendScreen_request(Proposal proposal)
      throws CollectException
   {
      StringWriter stringWriter = new StringWriter();
      try
      {
         proposal.marshal(stringWriter);
         String xml_string = stringWriter.toString();

         screen_response = (Screen_response) expertProxy.talkToExpert(
            "/screen_request", xml_string);
      }
      catch (MarshalException mex)
      {
         throw new CollectException("MarshalException in "
            + "CollectHelper.sendSample_request: " + mex);
      }
      catch (ValidationException vex)
      {
         throw new CollectException("ValidationException in "
            + "ProposalHelper.sendSample_request: " + vex);
      }
      return screen_response;
   }

   public void sendRank_request(Rank_request rank_request)
      throws CollectException
   {
      StringWriter stringWriter = new StringWriter();
      try
      {
         rank_request.marshal(stringWriter);
         String xml_string = stringWriter.toString();
         expertProxy.sendToExpert("/rank_request", xml_string);
      }
      catch (MarshalException mex)
      {
         throw new CollectException("MarshalException in "
            + "CollectHelper.sendSample_request: " + mex);
      }
      catch (ValidationException vex)
      {
         throw new CollectException("ValidationException in "
            + "ProposalHelper.sendSample_request: " + vex);
      }
   }

   public void sendSet_rank_engine_request(
      Set_rank_engine_request set_rank_engine_request) throws CollectException
   {
      StringWriter stringWriter = new StringWriter();
      try
      {
         set_rank_engine_request.marshal(stringWriter);
         String xml_string = stringWriter.toString();
         expertProxy.sendToExpert("/set_rank_engine_request", xml_string);
      }
      catch (MarshalException mex)
      {
         throw new CollectException("MarshalException in "
            + "CollectHelper.sendSample_request: " + mex);
      }
      catch (ValidationException vex)
      {
         throw new CollectException("ValidationException in "
            + "ProposalHelper.sendSample_request: " + vex);
      }
   }
   
}
