// *****************************************************************************
// Copyright (C) 2000-2005
// CCLRC Daresbury Laboratory, DLS Ltd
// All Rights Reserved.
// *****************************************************************************

package dna;

import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ArrayList;

import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;

import dna.util.BravaisLatticeSelector;
import dna.util.Debug;
import dna.util.DecimalField;
import dna.util.TitleBorder;

public abstract class DNAInitialDataPanel extends JPanel
{
/*   protected JPanel collectSetupPanel = new JPanel();
   protected JPanel collectLeftSetupPanel = new JPanel();
   protected JPanel collectRightSetupPanel = new JPanel();
   protected JPanel strategySetupPanel = new JPanel();
   protected JPanel strategyLeftSetupPanel = new JPanel();
   protected JPanel strategyRightSetupPanel = new JPanel();
   */
   protected JPanel buttonPanel = new JPanel();

   protected JTextField directory = new JTextField(15);
   protected JTextField prefix = new JTextField(15);
   protected JCheckBox anomalous = new JCheckBox("Enabled", false);
   protected DecimalField minOscillation = new DecimalField(0.0, 8, 1);
   protected DecimalField multiplicity = new DecimalField(0.0, 8, 1);
   protected JCheckBox saveReferenceImages = new JCheckBox("Enabled", true);
   protected JTextField runNumber = new JTextField(5);
   protected DecimalField time = new DecimalField(0.0, 8, 1);
   protected DecimalField oscillation = new DecimalField(0.0, 8, 1);
   protected DecimalField resolution = new DecimalField(0.0, 8, 1);
   protected JButton collect = new JButton("Collect Only");
   protected JButton characterize = new JButton("Collect and Characterize");
   protected BravaisLatticeSelector bravaisLattice = new BravaisLatticeSelector();
   protected int runNum = 1;
   protected ArrayList <JPanel> panels = new ArrayList <JPanel>();
   protected ArrayList <JPanel> leftPanels = new ArrayList <JPanel>();
   protected ArrayList <JPanel> rightPanels = new ArrayList <JPanel>();
   protected ArrayList <String> titles = new ArrayList <String>();
   
   public DNAInitialDataPanel()
   {
   }

   public void setTitles(ArrayList <String> panelTitles)
   {
      for (String title : panelTitles)
      {
         titles.add(title);
         JPanel panel = new JPanel();
         JPanel leftPanel = new JPanel();
         JPanel rightPanel = new JPanel();
        
         panels.add(panel);
         leftPanels.add(leftPanel);
         rightPanels.add(rightPanel);
      }
   }
   
   protected void initialiseSetupPanels()
   {    
      for (int i = 0; i < panels.size(); i++)
      {
         panels.get(i).setBorder(new TitleBorder(
            titles.get(i)));
         panels.get(i).setLayout(new GridBagLayout());
         leftPanels.get(i).setLayout(new GridBagLayout());
         rightPanels.get(i).setLayout(new GridBagLayout());
      }
   }

   protected JPanel parametersPanel()
   {
      JPanel panel = new JPanel();

      GridBagConstraints c = new GridBagConstraints();
      panel.setLayout(new GridBagLayout());
      
      c.insets = new Insets(0, 5, 0, 5); // Top, Left, Bottom, Right
      c.gridx = 0;
      c.gridy = 0;
      c.weightx = 1.0;
      c.weighty = 1.0;
      c.fill = GridBagConstraints.BOTH;
      for (int i = 0; i < panels.size(); i++)
      {
         addLeftAndRightPanels();
         panel.add(panels.get(i), c);
         c.gridx++;
         c.gridy = 0;
      }
      
      return panel;
   }
   
   private void addLeftAndRightPanels()
   {
      GridBagConstraints c = new GridBagConstraints();

      for (int i = 0; i < panels.size(); i++)
      {
         c.gridx = GridBagConstraints.RELATIVE;
         c.gridy = 1;

         c.fill = GridBagConstraints.NONE;
         c.weightx = 0.0;
         c.insets = new Insets(5, 5, 0, 5); // Top, Left, Bottom, Right
         
         panels.get(i).add(leftPanels.get(i), c);

         c.fill = GridBagConstraints.HORIZONTAL;
         c.weightx = 1.0;
         c.insets = new Insets(0, 5, 0, 5); // Top, Left, Bottom, Right
         panels.get(i).add(rightPanels.get(i), c);
      }
   }
   protected void addComponent(int row, String name, String componentPrefix,
      JComponent component, String title)
   {
      GridBagConstraints c = new GridBagConstraints();
      c.insets = new Insets(0, 5, 7, 5); // Top, Left, Bottom, Right
      c.gridx = GridBagConstraints.RELATIVE;
      c.gridy = row;
      c.anchor = GridBagConstraints.EAST;
      c.fill = GridBagConstraints.NONE;
      
      for (int i = 0; i < panels.size(); i++)
      {
         Debug.out("title is " + title + " found " + titles.get(i));
         if (title.equals(titles.get(i)))
         {
            Debug.out("title is " + title + " adding " + name);
            leftPanels.get(i).add(new JLabel(name), c);
            c.anchor = GridBagConstraints.CENTER;
            leftPanels.get(i).add(new JLabel("="), c);

            if (componentPrefix != null)
            {
               c.insets = new Insets(2, 0, 0, 0); // Top, Left, Bottom, Right
               rightPanels.get(i).add(new JLabel(componentPrefix), c);
            }

            c.insets = new Insets(2, 5, 0, 5); // Top, Left, Bottom, Right
            c.anchor = GridBagConstraints.WEST;
            c.fill = GridBagConstraints.HORIZONTAL;
            c.weightx = 1.0;
            rightPanels.get(i).add(component, c);
            break;
         }
      }
   }

}
