package dna;

import java.io.StringReader;
import java.io.StringWriter;

import javax.swing.JComponent;

import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.Unmarshaller;
import org.exolab.castor.xml.ValidationException;

import dna.observable.IObservable;
import dna.observable.IObserver;
import dna.observable.ObservableComponent;
import dna.util.Debug;
import dna.xml.Bcm_parameters_request;
import dna.xml.Bcm_parameters_response;
import dna.xml.Collect_automatically_request;
import dna.xml.Collect_automatically_response;
import dna.xml.Collect_data_request;
import dna.xml.Collect_data_response;
import dna.xml.Collect_reference_request;
import dna.xml.Collect_reference_response;
import dna.xml.Collect_request;
import dna.xml.Collect_response;
import dna.xml.Status;
import dna.xml.types.Status_code;

public class CollectHelper
implements ExpertListener, IObservable
{
   private static CollectHelper collectHelper 	= null;
   private ExpertClientHTTPServer _httpServer = ExpertClientHTTPServer.getGUIServer();
   private ExpertProxy expertProxy = ExpertProxy.getInstance();
   private Bcm_parameters_response bcm_parameters_response = null;
   private Collect_response collect_response = null;
   private Collect_reference_response collect_reference_response = null;
   private Collect_automatically_response collect_automatically_response = null;
   private Collect_data_response collect_data_response = null;
   private String callbackStatus = "ok";
   private ObservableComponent observableComponent = new ObservableComponent();
   private Status status = null;
   private JComponent jc = null;
   private Collect_data_request latest_collect_data_request = null;

   private CollectHelper()
   {
	    _httpServer.addExpertListener(this);
   }
   
   public static synchronized CollectHelper getInstance()
   {
	   if ( collectHelper == null )
	   {
		   CollectHelper.collectHelper = new CollectHelper();
	   }
	   return CollectHelper.collectHelper;	   
   }
   
   public void setJComponent( JComponent jc )
   {
	   this.jc = jc;
   }
   
   public void sendCollect_request(Collect_request collect_request)
      throws CollectException
   {
      StringWriter stringWriter = new StringWriter();
      try
      {
         collect_request.marshal(stringWriter);
         String xml_string = stringWriter.toString();
         expertProxy.sendToExpert("/collect_request", xml_string);
      }
      catch (MarshalException mex)
      {
         throw new CollectException("MarshalException in "
            + "CollectHelper.sendCollect_request: " + mex);
      }
      catch (ValidationException vex)
      {
         throw new CollectException("ValidationException in "
            + "CollectHelper.sendCollect_request: " + vex);
      }
   }

   public void sendBcm_parameters_request(
      Bcm_parameters_request bcm_parameters_request) throws CollectException
   {
      StringWriter stringWriter = new StringWriter();
      try
      {
         bcm_parameters_request.marshal(stringWriter);
         String xml_string = stringWriter.toString();
         expertProxy.sendToExpert("/bcm_parameters_request", xml_string);
      }
      catch (MarshalException mex)
      {
         throw new CollectException("MarshalException in "
            + "CollectHelper.sendBcm_parameters_request: " + mex);
      }
      catch (ValidationException vex)
      {
         throw new CollectException("ValidationException in "
            + "CollectHelper.sendBcm_parameters_request: " + vex);
      }
   }

   public synchronized  Bcm_parameters_response sendBcm_parameters_requestSynchronous(
      Bcm_parameters_request bcm_parameters_request, int timeOut) throws CollectException
   {
         bcm_parameters_response = null;
         callbackStatus = "ok";
         sendBcm_parameters_request(bcm_parameters_request);
         Debug.out("Sending Bcm_parameters request.");
         try
         {
            Debug.out("Bcm_parameters request sent, waiting for collect response.", 2);
            this.wait(timeOut);
         }
         catch (InterruptedException ex)
         {
            throw new CollectException("InterruptedException caught in "
               + "CollectHelper.sendBcm_parameters_requestSynchronous");
         }
         if (collect_response == null)
            if (callbackStatus.equals("ok"))
               throw new CollectException("Time out while waiting for Bcm_parameters "
                  + "response.");
            else
               throw new CollectException(callbackStatus);
         return bcm_parameters_response;
   }


   public void sendCollect_reference_request(
      Collect_reference_request collect_reference_request)
      throws CollectException
   {
      StringWriter stringWriter = new StringWriter();
      try
      {
         collect_reference_request.marshal(stringWriter);
         String xml_string = stringWriter.toString();
         expertProxy.sendToExpert("/collect_reference_request", xml_string);
      }
      catch (MarshalException mex)
      {
         throw new CollectException("MarshalException in "
            + "CollectHelper.sendCollect_reference_request: " + mex);
      }
      catch (ValidationException vex)
      {
         throw new CollectException("ValidationException in "
            + "CollectHelper.sendCollect_reference_request: " + vex);
      }
   }

 
   public void sendCollect_data_request(
      Collect_data_request collect_data_request) throws CollectException
   {
      latest_collect_data_request = collect_data_request;
      StringWriter stringWriter = new StringWriter();
      try
      {
         collect_data_request.marshal(stringWriter);
         String xml_string = stringWriter.toString();
         expertProxy.sendToExpert("/collect_data_request", xml_string);
      }
      catch (MarshalException mex)
      {
         throw new CollectException("MarshalException in "
            + "CollectHelper.sendCollect_data_request: " + mex);
      }
      catch (ValidationException vex)
      {
         throw new CollectException("ValidationException in "
            + "CollectHelper.sendCollect_data_request: " + vex);
      }
   }
   
   public void sendCollect_automatically_request(
		      Collect_automatically_request collect_automatically_request) throws CollectException
		   {
		      StringWriter stringWriter = new StringWriter();
		      try
		      {
		    	 collect_automatically_request.marshal(stringWriter);
		         String xml_string = stringWriter.toString();
		         expertProxy.sendToExpert("/collect_automatically_request", xml_string);
		      }
		      catch (MarshalException mex)
		      {
		         throw new CollectException("MarshalException in "
		            + "CollectHelper.sendCollect_data_request: " + mex);
		      }
		      catch (ValidationException vex)
		      {
		         throw new CollectException("ValidationException in "
		            + "CollectHelper.sendCollect_data_request: " + vex);
		      }
		   }
   
   
   // ExpertListener
   public synchronized void expertMessage(ExpertXMLMessage the_message)
   {
      String path = the_message.getPath();

      if (path.equals("/bcm_parameters_response"))
      {
         String xml_message = the_message.getXMLMessage();
         Debug.out("Bcm_parameters response received " + xml_message);
         StringReader reader = new StringReader(the_message.getXMLMessage());
         try
         {
            bcm_parameters_response = (Bcm_parameters_response) Unmarshaller.unmarshal(
               Bcm_parameters_response.class, reader);
         }
         catch (MarshalException ex)
         {
            callbackStatus = "MasrhalException in "
               + "CollectHelper.expertMessage";
         }
         catch (ValidationException ex)
         {
            callbackStatus = "ValidationException in "
               + "CollectHelper.expertMessage";
         }
         this.notify();
      }
      else if (path.equals("/collect_response"))
      {
         Debug.out("Collect response received", 2);
         String xml_message = the_message.getXMLMessage();
         Debug.out(xml_message, 2);
         StringReader reader = new StringReader(the_message.getXMLMessage());
         try
         {
            collect_response = (Collect_response) Unmarshaller.unmarshal(
               Collect_response.class, reader);
         }
         catch (MarshalException ex)
         {
            callbackStatus = "MasrhalException in "
               + "CollectHelper.expertMessage";
         }
         catch (ValidationException ex)
         {
            callbackStatus = "ValidationException in "
               + "CollectHelper.expertMessage";
         }
         this.notify();
      }
      else if (path.equals("/collect_reference_response"))
      {
         Debug.out("Collect reference response received", 2);
         String xml_message = the_message.getXMLMessage();
         Debug.out(xml_message, 2);
         System.out.println("DEBUG: xml_message = " + xml_message );
         StringReader reader = new StringReader(the_message.getXMLMessage());
         try
         {
            collect_reference_response = (Collect_reference_response) Unmarshaller.unmarshal(
               Collect_reference_response.class, reader);
            Status status = collect_reference_response.getStatus();
            if ( status.getCode().toString().equals( "error" ) )
            {
               ErrorDialog errorDialog = new ErrorDialog( this.jc, status.getMessage() );
            }
         }         
         catch (MarshalException ex)
         {
            callbackStatus = "MasrhalException in "
               + "CollectHelper.expertMessage";
         }
         catch (ValidationException ex)
         {
            callbackStatus = "ValidationException in "
               + "CollectHelper.expertMessage";
         }
         observableComponent.notifyIObservers(this, new ExpertState(
	               ExpertState.IDLE));
         this.notify();
      }
      else if (path.equals("/collect_data_response"))
      {
         Debug.out("Collect response received", 2);
         String xml_message = the_message.getXMLMessage();
         Debug.out(xml_message, 2);
         StringReader reader = new StringReader(the_message.getXMLMessage());
         try
         {
            collect_data_response = (Collect_data_response) Unmarshaller.unmarshal(
               Collect_data_response.class, reader);
         }
         catch (MarshalException ex)
         {
            callbackStatus = "MasrhalException in "
               + "CollectHelper.expertMessage";
         }
         catch (ValidationException ex)
         {
            callbackStatus = "ValidationException in "
               + "CollectHelper.expertMessage";
         }
         status = collect_data_response.getStatus();
         System.out.println("DEBUG: code = " + status.getCode() );
         if ( status.getCode().toString().equals( "warning" ) )
         {
        	if ( jc != null )
        	{
	  		   	WarningDialog dialog = new WarningDialog( jc, status.getMessage(), "Data collection warning" );
	  		   	if (dialog.isOk())
	  		   	{
	  		   		 latest_collect_data_request.getCollect_request().setIgnore_maximum_exposure( true );
	  		         try
	  		         {
	  		            collectHelper.sendCollect_data_request( latest_collect_data_request );
	  		         }
	  		         catch (CollectException ex)
	  		         {
	  		            MessagePanel messagePanel = MessagePanel.getInstance();
	  		            messagePanel.appendText("Error caught in Reference Images");
	  		            messagePanel.appendText(ex.getMessage());
	  		            //new ErrorDialog(this, ex, "ReferenceImages");
	  		         }
	  		   	}
  		   	}

         }
         observableComponent.notifyIObservers(this, new ExpertState(
		               ExpertState.IDLE));
         this.notify();
      } else if (path.equals("/collect_automatically_response"))
      {
          Debug.out("Collect automatcially response received", 2);
          String xml_message = the_message.getXMLMessage();
          Debug.out(xml_message, 2);
          System.out.println("DEBUG: xml_message = " + xml_message );
          StringReader reader = new StringReader(the_message.getXMLMessage());
          try
          {
             collect_automatically_response = (Collect_automatically_response) Unmarshaller.unmarshal(
                Collect_automatically_response.class, reader);
          }         
          catch (MarshalException ex)
          {
             callbackStatus = "MasrhalException in "
                + "CollectHelper.expertMessage";
          }
          catch (ValidationException ex)
          {
             callbackStatus = "ValidationException in "
                + "CollectHelper.expertMessage";
          }
          observableComponent.notifyIObservers(this, new ExpertState(
 	               ExpertState.IDLE));
          this.notify();
       }
   }


   // IObservable

   public void addIObserver(IObserver anIObserver)
   {
      observableComponent.addIObserver(anIObserver);
   }

   public void deleteIObserver(IObserver anIObserver)
   {
      observableComponent.deleteIObserver(anIObserver);
   }

   public void deleteIObservers()
   {
      observableComponent.deleteIObservers();
   }
   
   
   
}
