package dna;

import javax.swing.JComponent;
import javax.swing.JOptionPane;

public class CheckParametersDialog
{
	private int selection;
	
   public CheckParametersDialog( JComponent jc )
   {
      this.selection = JOptionPane.showConfirmDialog(jc.getTopLevelAncestor(),
         "You are just about to start a data collection as a new user.\n\n" +
    	 "Please check the data collection parameters, especially the directory,\n" +
    	 "in order to avoid loss of data and/or saving data in the wrong directory.\n\n" +
    	 "If they are not correct click on cancel and correct them.\n\n" +
    	 "This question will not be asked again for the current user.", 
         "Check collect parameters", 
         JOptionPane.OK_CANCEL_OPTION,
         JOptionPane.WARNING_MESSAGE
         );
   }
   
   public boolean isOk()
   {
	   return ( selection == JOptionPane.OK_OPTION );
   }

}
