package dna;

import java.io.StringReader;

import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.Unmarshaller;
import org.exolab.castor.xml.ValidationException;

import dna.observable.IObservable;
import dna.observable.IObserver;
import dna.observable.ObservableComponent;
import dna.util.Debug;
import dna.xml.Status;
import dna.xml.Gui_message;
import dna.xml.Index_response;
import dna.xml.Strategy_response;
import dna.xml.Characterize_crystal_response;

public class CharacterizeResponsesHandler
   implements ExpertListener, IObservable
{
   private ObservableComponent observableComponent = new ObservableComponent();

   private String _callbackStatus = "ok";
   private AutoIndexPanel autoIndexPanel;
   private StrategyPanel strategyPanel;
   private KappaStrategyPanel kappaStrategyPanel;
   private Index_response index_response = null;
   private Strategy_response strategy_response = null;
   private Characterize_crystal_response characterize_crystal_response = null;

   public CharacterizeResponsesHandler(AutoIndexPanel autoIndexPanel,
      StrategyPanel strategyPanel, KappaStrategyPanel kappaStrategyPanel)
   {
      this.autoIndexPanel = autoIndexPanel;
      this.strategyPanel = strategyPanel;
      this.kappaStrategyPanel = kappaStrategyPanel;
   }

   // ExpertListener

   public synchronized void expertMessage(ExpertXMLMessage the_message)
   {
      Gui_message gui_message;
      String content;
      String path = the_message.getPath();
      String xml_message = the_message.getXMLMessage();
      StringReader reader = new StringReader(the_message.getXMLMessage());

      if (path.equals("/index_response"))
      {
         Debug.out("Index Response received", 1);
         try
         {
            index_response = (Index_response) Unmarshaller.unmarshal(
               Index_response.class, reader);
            autoIndexPanel.updateSolutionPanel(index_response);
            observableComponent.notifyIObservers(this, new ExpertState(
               ExpertState.DISPLAY_INDEXING_SOLUTION));
         }
         catch (MarshalException mex)
         {
            Debug.out("MarshallException: " + mex, 2);
            _callbackStatus = "MarshalException in "
               + "CharacterizeResponsesHandler.expertMessage";
         }
         catch (ValidationException vex)
         {
            Debug.out("ValidationException: " + vex, 2);
            _callbackStatus = "ValidationException in "
               + "CharacterizeResponsesHandler.expertMessage";
         }
      }
      else if (path.equals("/strategy_response"))
      {
         Debug.out("Gui strategy Response received", 1);
         try
         {
            strategy_response = (Strategy_response) Unmarshaller.unmarshal(
               Strategy_response.class, reader);
            strategyPanel.updateStrategyDataPanel(strategy_response);
            observableComponent.notifyIObservers(this, new ExpertState(
               ExpertState.DISPLAY_STRATEGY));
         }
         catch (MarshalException mex)
         {
            Debug.out("MarshallException: " + mex, 2);
            _callbackStatus = "MarshalException in "
               + "CharacterizeResponsesHandler.expertMessage";
         }
         catch (ValidationException vex)
         {
            Debug.out("ValidationException: " + vex, 2);
            _callbackStatus = "ValidationException in "
               + "CharacterizeResponsesHandler.expertMessage";
         }
      }
      else if (path.equals("/characterize_crystal_response"))
      {
         Debug.out("Characterize Response received", 1);
         try
         {
            characterize_crystal_response = (Characterize_crystal_response) Unmarshaller.unmarshal(
               Characterize_crystal_response.class, reader);
            Status status = characterize_crystal_response.getStatus();
            if ( status.getCode().toString().equals( "error" ) )
            {
              ErrorDialog errorDialog = new ErrorDialog( this.strategyPanel, status.getMessage() );
            }
         }
         catch (MarshalException mex)
         {
            Debug.out("MarshallException: " + mex, 2);
            _callbackStatus = "MarshalException in "
               + "CharacterizeResponsesHandler.expertMessage";
         }
         catch (ValidationException vex)
         {
            Debug.out("ValidationException: " + vex, 2);
            _callbackStatus = "ValidationException in "
               + "CharacterizeResponsesHandler.expertMessage";
         }

         observableComponent.notifyIObservers(this, new ExpertState(
            ExpertState.IDLE));

      }
   }

   // IObservable

   public void addIObserver(IObserver anIObserver)
   {
      observableComponent.addIObserver(anIObserver);
   }

   public void deleteIObserver(IObserver anIObserver)
   {
      observableComponent.deleteIObserver(anIObserver);
   }

   public void deleteIObservers()
   {
      observableComponent.deleteIObservers();
   }
}
