package dna;

import java.io.StringReader;
import java.io.StringWriter;

import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.Unmarshaller;
import org.exolab.castor.xml.ValidationException;

import dna.util.Debug;
import dna.xml.Characterize_crystal_request;
import dna.xml.Characterize_crystal_response;

public class CharacterizeCrystalHelper
   implements ExpertListener
{
   private static CharacterizeCrystalHelper characterizeCrystalHelper = null;
   private ExpertClientHTTPServer _httpServer = ExpertClientHTTPServer.getGUIServer();
   private ExpertProxy _expertProxy = ExpertProxy.getInstance();
   private Characterize_crystal_response _characterize_crystal_response = null;
   private String _callbackStatus = "ok";

   private CharacterizeCrystalHelper()
   {
      _httpServer.addExpertListener(this);
   }

   public static synchronized CharacterizeCrystalHelper getInstance()
   {
	   if ( characterizeCrystalHelper == null )
	   {
		   CharacterizeCrystalHelper.characterizeCrystalHelper = new CharacterizeCrystalHelper();
	   }
	   return CharacterizeCrystalHelper.characterizeCrystalHelper;	   
   }   

   public void sendCharacterize_crystal_request(
      Characterize_crystal_request characterize_crystal_request)
      throws CharacterizeCrystalException
   {
      StringWriter stringWriter = new StringWriter();
      try
      {
         characterize_crystal_request.marshal(stringWriter);
         String xml_string = stringWriter.toString();
         _expertProxy.sendToExpert("/characterize_crystal_request", xml_string);
      }
      catch (MarshalException mex)
      {
         throw new CharacterizeCrystalException("MarshalException in "
            + "CharacterizeCrystalHelper.sendCharacterize_crystal_request: "
            + mex);
      }
      catch (ValidationException vex)
      {
         throw new CharacterizeCrystalException("ValidationException in "
            + "CharacterizeCrystalHelper.sendCharacterize_crystal_request: "
            + vex);
      }
   }

   public synchronized Characterize_crystal_response sendCharacterize_crystal_requestSynchronous(
      Characterize_crystal_request characterize_crystal_request, int timeOut)
      throws CharacterizeCrystalException
   {
      _characterize_crystal_response = null;
      _callbackStatus = "ok";
      this.sendCharacterize_crystal_request(characterize_crystal_request);
      Debug.out("Sending characterize_crystal request.", 2);
      try
      {
         Debug.out(
            "Characterize_crystal request sent, waiting for characterizeCrystal response.",
            2);
         this.wait(timeOut);
      }
      catch (InterruptedException ex)
      {
         throw new CharacterizeCrystalException(
            "InterruptedException caught in "
               + "CharacterizeCrystalHelper.sendCharacterize_crystal_requestSynchronous");
      }
      if (_characterize_crystal_response == null)
         if (_callbackStatus.equals("ok"))
            throw new CharacterizeCrystalException(
               "Time out while waiting for characterizeCrystal " + "response.");
         else
            throw new CharacterizeCrystalException(_callbackStatus);
      return _characterize_crystal_response;
   }

   public synchronized void expertMessage(ExpertXMLMessage the_message)
   {
      String path = the_message.getPath();

      if (path.equals("/characterize_crystal_response"))
      {
         Debug.out("CharacterizeCrystal response received", 2);
         String xml_message = the_message.getXMLMessage();
         Debug.out(xml_message, 2);
         StringReader reader = new StringReader(the_message.getXMLMessage());
         try
         {
            _characterize_crystal_response = (Characterize_crystal_response) Unmarshaller.unmarshal(
               Characterize_crystal_response.class, reader);
         }
         catch (MarshalException ex)
         {
            _callbackStatus = "MasrhalException in "
               + "CharacterizeCrystalHelper.expertMessage";
         }
         catch (ValidationException ex)
         {
            _callbackStatus = "ValidationException in "
               + "CharacterizeCrystalHelper.expertMessage";
         }
         this.notify();
      }
   }
}
