package dna;

import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;

import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

import dna.util.Debug;
import dna.util.TitleBorder;

public class BasicFileData
   extends JPanel
   implements ActionListener
{
   private ExpertDataModel edm = ExpertDataModel.getInstance();

   private GridBagConstraints c = new GridBagConstraints();
   private JTextField directory = new JTextField(30);
   private JTextField prefix = new JTextField(20);
   private JTextField runNumber = new JTextField(5);
   private JButton browseButton = new JButton("Browse");
   private File selectedFile;
   private JPanel filePanel = new JPanel();
   private JPanel buttonPanel = new JPanel();
   private String suffix = null;

   public BasicFileData(String title, boolean active)
   {
      GridBagConstraints c1 = new GridBagConstraints();
      if (title != null)
         setBorder(new TitleBorder(title));
      setLayout(new GridBagLayout());
      filePanel.setLayout(new GridBagLayout());
      if (!active)
      {
         directory.setEnabled(false);
         prefix.setEnabled(false);
         runNumber.setEnabled(false);
         browseButton.setEnabled(false);
      }
      populateFilePanel();

      c1.insets = new Insets(0, 5, 0, 5); // Top, Left, Bottom, Right
      c1.gridx = GridBagConstraints.RELATIVE;
      c1.gridy = 1;
      c1.weightx = 1.0;
      c1.fill = GridBagConstraints.BOTH;
      add(filePanel, c1);
      c1.weightx = 0.0;
      c1.fill = GridBagConstraints.NONE;
      browseButton.setActionCommand("Browse");
      browseButton.addActionListener(this);
      buttonPanel.add(browseButton);
      add(buttonPanel, c1);
      update();
   }

   private void populateFilePanel()
   {
      c.insets = new Insets(2, 5, 2, 5); // Top, Left, Bottom, Right
      c.gridx = GridBagConstraints.RELATIVE;
      c.gridy = 1;

      addElement("Directory", directory);
      c.gridy++;
      addElement("Prefix", prefix);

      if (edm.isRunNumberOn())
      {
         c.gridy++;
         addElement("Start Run Number", runNumber);
      }
   }

   private void addElement(String label, JTextField element)
   {
      c.fill = GridBagConstraints.NONE;
      c.weightx = 0.0;
      c.anchor = GridBagConstraints.EAST;
      filePanel.add(new JLabel(label), c);
      c.anchor = GridBagConstraints.CENTER;
      filePanel.add(new JLabel("="), c);
      c.fill = GridBagConstraints.HORIZONTAL;
      c.weightx = 1.0;
      c.anchor = GridBagConstraints.WEST;
      filePanel.add(element, c);
   }

   public void setEditable(boolean editable)
   {
      directory.setEnabled(editable);
      prefix.setEnabled(editable);
      runNumber.setEnabled(editable);
      browseButton.setEnabled(editable);
   }

   public void update()
   {
      directory.setText(edm.getDirectory());
      prefix.setText(edm.getPrefix());
      runNumber.setText(edm.getRunNumber());
   }

   public String getDirectory()
   {
      return directory.getText();
   }

   public void setDirectory(String directory)
   {
      this.directory.setText(directory);
   }

   public String getPrefix()
   {
      return prefix.getText();
   }

   public void setPrefix(String prefix)
   {
      this.prefix.setText(prefix);
   }

   public String getRunNumber()
   {
      return runNumber.getText();
   }

   public void setRunNumber(String runNumber)
   {
      this.runNumber.setText(runNumber);
   }

   public String getSuffix()
   {
      return this.suffix;
   }

   public void setSuffix(String the_suffix)
   {
      this.suffix = the_suffix;
   }

   private void setFileData(File filePath)
   {
      //
      // First separate the directory from the filename
      //
      String filename = filePath.getName();
      String filedirectory = filePath.getParentFile().getPath();
      //
      // Then find the last "." - what's after the dot is the suffix
      //
      int index = filename.lastIndexOf(".");
      if (index < 1)
         throw new RuntimeException(
            "Illegal file name - no dot in file name so it's not possible to determine the suffix");
      String filesuffix = filename.substring(index + 1, filename.length());
      filename = filename.substring(0, index);
      //
      // If there's still a dot in the filename throw an error
      //
      index = filename.indexOf(".");
      if (index > 1)
         throw new RuntimeException("Illegal file name - too many dots");
      //
      // Then find the last "_" - what's after the underscore is the image
      // number
      //
      index = filename.lastIndexOf("_");
      if (index < 1)
         throw new RuntimeException(
            "Illegal file name - no underscore in file name so it's not possible to determine the image number");
      String imageNumberString = filename.substring(index + 1,
         filename.length());
      filename = filename.substring(0, index);
      //
      // Then find the last "_" - what's after the underscore is the run number
      //
      index = filename.lastIndexOf("_");
      if (index < 1)
         throw new RuntimeException(
            "Illegal file name - no underscore in file name so it's not possible to determine the image number");
      String runNumberString = filename.substring(index + 1, filename.length());
      filename = filename.substring(0, index);
      //
      // What's left is the prefix!
      //
      String fileprefix = filename;
      //
      // Set the relevant text fields.
      //
      directory.setText(filedirectory);
      Debug.out("BasicFileData directory = " + filedirectory, 2);
      prefix.setText(fileprefix);
      Debug.out("BasicFileData prefix = " + fileprefix, 2);
      runNumber.setText(runNumberString);
      Debug.out("BasicFileData runNumber = " + runNumberString, 2);
      this.setSuffix(filesuffix);
      Debug.out("BasicFileData suffix = " + filesuffix, 2);
   }

   public void actionPerformed(ActionEvent ae)
   {
      if (ae.getActionCommand().equals("Browse"))
      {
         ReferenceFileChooser referenceFileChooser = new ReferenceFileChooser(
            true);

         referenceFileChooser.setCurrentDirectory(new File(edm.getDirectory()));

         if (referenceFileChooser.showDialog(getRootPane(), "Select") == JFileChooser.APPROVE_OPTION)
         {
            if ((selectedFile = referenceFileChooser.getSelectedFile()) != null)
            {
               setFileData(selectedFile);
            }
         }

      }
   }

}
