package dna;

import dna.xml.Bcm_parameters_response;
import dna.xml.Collect_request;
import dna.xml.Collect_response;

public abstract class BCM
{
   protected static BCM bcm;
   private String detector;
   private double beamX = 96.45;
   private double beamY = 97.12;
   private double wavelength = 1.93;

   public abstract Collect_response collect(Collect_request collect_request);

   public abstract Bcm_parameters_response getBCMParameters();

   public static BCM getInstance()
   {
      return bcm;
   }

   public String getDetector()
   {
      return detector;
   }

   public void setDetector(String detector)
   {
      this.detector = detector;
   }

   public double getBeamX()
   {
      return beamX;
   }

   public double getBeamY()
   {
      return beamY;
   }

   public double getWavelength()
   {
      return wavelength;
   }
}
