package dna;

import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.text.DecimalFormat;

import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

import dna.observable.IObserver;
import dna.util.BravaisLatticeSelector;
import dna.util.TitleBorder;
import dna.xml.Cell;
import dna.xml.Index_response;
import dna.xml.Solution;

public class AutoIndexSolution
   extends JPanel
   implements IObserver
{
   public static int ALL = 0;
   public static int CELL = 1;
   public static int SYMETRY = 2;

   private ExpertDataModel edm = ExpertDataModel.getInstance();

   private JTextField spaceGroup = new JTextField(10);
   // private BravaisLatticeComboBox combo = new BravaisLatticeComboBox();
   private BravaisLatticeSelector combo = new BravaisLatticeSelector();
   private JTextField cellA = new JTextField(6);
   private JTextField cellB = new JTextField(6);
   private JTextField cellC = new JTextField(6);
   private JTextField cellAlpha = new JTextField(6);
   private JTextField cellBeta = new JTextField(6);
   private JTextField cellGamma = new JTextField(6);
   private DecimalFormat format = new DecimalFormat();
   private static AutoIndexSolution autoIndexSolution = null;
   private Solution solution = null;
   private boolean changed = false;

   private AutoIndexSolution()
   {
      autoIndexSolution = this;
      setBorder(new TitleBorder("Expert System auto-indexed solution"));
      setLayout(new GridBagLayout());
      combo.addIObserver(edm);
      combo.addIObserver(this);
      populateSolutionPanel();
   }

   public static AutoIndexSolution getReference()
   {
      if (autoIndexSolution == null)
         new AutoIndexSolution();
      return autoIndexSolution;
   }

   private void populateSolutionPanel()
   {
      GridBagConstraints c = new GridBagConstraints();
      c.insets = new Insets(5, 5, 5, 5); // Top, Left, Bottom, Right
      c.gridx = GridBagConstraints.RELATIVE;
      c.gridy = 1;

      c.gridwidth = 3;
      c.anchor = GridBagConstraints.EAST;
      add(new JLabel("Space Group = "), c);
      c.anchor = GridBagConstraints.WEST;
      // add(spaceGroup, c);
      add(combo, c);

      c.anchor = GridBagConstraints.CENTER;
      c.gridwidth = 1;

      c.gridy++;

      c.fill = GridBagConstraints.NONE;
      c.weightx = 0.0;
      add(new JLabel("a = "), c);
      c.fill = GridBagConstraints.HORIZONTAL;
      c.weightx = 1.0;
      cellA.setEditable(false);
      add(cellA, c);

      c.fill = GridBagConstraints.NONE;
      c.weightx = 0.0;
      add(new JLabel("b = "), c);
      c.fill = GridBagConstraints.HORIZONTAL;
      c.weightx = 1.0;
      cellB.setEditable(false);
      add(cellB, c);

      c.fill = GridBagConstraints.NONE;
      c.weightx = 0.0;
      add(new JLabel("c = "), c);
      c.fill = GridBagConstraints.HORIZONTAL;
      c.weightx = 1.0;
      cellC.setEditable(false);
      add(cellC, c);

      c.gridy++;
      c.fill = GridBagConstraints.NONE;
      c.weightx = 0.0;
      add(new JLabel("alpha = "), c);
      c.fill = GridBagConstraints.HORIZONTAL;
      c.weightx = 1.0;
      cellAlpha.setEditable(false);
      add(cellAlpha, c);

      c.fill = GridBagConstraints.NONE;
      c.weightx = 0.0;
      add(new JLabel("beta = "), c);
      c.fill = GridBagConstraints.HORIZONTAL;
      c.weightx = 1.0;
      cellBeta.setEditable(false);
      add(cellBeta, c);

      c.fill = GridBagConstraints.NONE;
      c.weightx = 0.0;
      add(new JLabel("gamma = "), c);
      c.fill = GridBagConstraints.HORIZONTAL;
      c.weightx = 1.0;
      cellGamma.setEditable(false);
      add(cellGamma, c);

      format.setMaximumFractionDigits(2);
   }

   public void update(Index_response index_response)
   {
      if (index_response != null)
      {
         solution = index_response.getSolution();
         if (solution != null)
         {
            Cell cell = solution.getOrientation().getCell();

            combo.setText(solution.getSymmetry().toString());
            cellA.setText(format.format(cell.getA()));
            cellB.setText(format.format(cell.getB()));
            cellC.setText(format.format(cell.getC()));
            cellAlpha.setText(format.format(cell.getAlpha()));
            cellBeta.setText(format.format(cell.getBeta()));
            cellGamma.setText(format.format(cell.getGamma()));
         }
      }
      else
      {
         clear();
      }
   }

   public boolean hasSymetryChanged()
   {
      return changed;
   }

   public void clear()
   {
      clear(ALL);
   }

   public void clearSymetry()
   {
      combo.setText("unknown");
      edm.setSpaceGroup("unknown");
   }

   public void clearCell()
   {
      cellA.setText("");
      cellB.setText("");
      cellC.setText("");
      cellAlpha.setText("");
      cellBeta.setText("");
      cellGamma.setText("");
   }

   public void clear(int action)
   {
      if (action == ALL)
      {
         clearSymetry();
         clearCell();
      }
      else if (action == CELL)
      {
         clearCell();
      }
      else if (action == SYMETRY)
      {
         clearSymetry();
      }
   }

   // IObserver

   public void update(Object theObserved, Object changeCode)
   {
      if (changeCode instanceof ExpertState)
      {
         ExpertState expertState = (ExpertState) changeCode;
         if (expertState.getState() == ExpertState.COLLECTING_REFERENCE_IMAGES
            || expertState.getState() == ExpertState.CHARACTERIZING)
            update((Index_response) null);
      }
      else if (changeCode instanceof String)
      {
         // JMenuItem jmi = (JMenuItem) ae.getSource();
         edm.setSpaceGroup((String) changeCode);
         System.out.println("edm set to " + (String) changeCode);
         changed = true;
      }
   }
}