package dna;

import java.io.StringReader;
import java.io.StringWriter;

import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.Unmarshaller;
import org.exolab.castor.xml.ValidationException;

import dna.util.Debug;
import dna.xml.Index_request;
import dna.xml.Index_response;
import dna.xml.Resolution;

public class AutoIndexHelper
   implements ExpertListener
{
   private static AutoIndexHelper autoIndexHelper = null;
   private ExpertClientHTTPServer _httpServer = ExpertClientHTTPServer.getGUIServer();
   private ExpertProxy _expertProxy = ExpertProxy.getInstance();
   private Index_response _index_response = null;
   private String _callbackStatus = "ok";
   private ExpertDataModel edm = ExpertDataModel.getInstance();

   private AutoIndexHelper()
   {
      _httpServer.addExpertListener(this);
   }

   public static synchronized AutoIndexHelper getInstance()
   {
	   if ( autoIndexHelper == null )
	   {
		   AutoIndexHelper.autoIndexHelper = new AutoIndexHelper();
	   }
	   return AutoIndexHelper.autoIndexHelper;	   
   }   
   
   
   public void sendIndex_request(Index_request index_request)
      throws IndexException
   {
      StringWriter stringWriter = new StringWriter();
      try
      {
         index_request.marshal(stringWriter);
         String xml_string = stringWriter.toString();
         Debug.out(xml_string, 2);
         _expertProxy.sendToExpert("/index_request", xml_string);
      }
      catch (MarshalException mex)
      {
         throw new IndexException(
            "MarshalException in AutoIndexHelper.sendIndex_request:" + mex);
      }
      catch (ValidationException vex)
      {
         throw new IndexException(
            "ValidationException in AutoIndexHelper.sendIndex_request:" + vex);
      }
   }

   public synchronized Index_response sendIndex_requestSynchronous(
      Index_request index_request, int timeOut) throws IndexException
   {
      _index_response = null;
      _callbackStatus = "ok";
      this.sendIndex_request(index_request);
      Debug.out("Sending index request.", 2);
      try
      {
         Debug.out("Index request sent, waiting for index response.", 2);
         this.wait(timeOut);
      }
      catch (InterruptedException ex)
      {
         throw new IndexException("InterruptedException caught in "
            + "AutoIndexHelper.sendIndex_requestSynchronous");
      }

      if (_index_response == null)
      {
         if (_callbackStatus.equals("ok"))
         {
            throw new IndexException(
               "Time out while waiting for index response.");
         }
         else
            throw new IndexException(_callbackStatus);
      }

      return _index_response;
   }

   public synchronized void expertMessage(ExpertXMLMessage the_message)
   {
      String path = the_message.getPath();

      if (path.equals("/index_response"))
      {
         String xml_message = the_message.getXMLMessage();
         Debug.out("xml_message = " + xml_message, 2);
         StringReader reader = new StringReader(the_message.getXMLMessage());

         try
         {
            _index_response = (Index_response) Unmarshaller.unmarshal(
               Index_response.class, reader);
            Resolution resolution = _index_response.getCalculated_resolution();
            if (resolution != null)
               edm.setCalculatedResolution(resolution);
         }
         catch (MarshalException mex)
         {
            Debug.out("MarshallException: " + mex, 2);
            _callbackStatus = "MarshalException in "
               + "AutoIndexHelper.expertMessage";
         }
         catch (ValidationException vex)
         {
            Debug.out("ValidationException: " + vex, 2);
            _callbackStatus = "ValidationException in "
               + "AutoIndexHelper.expertMessage";
         }

         this.notify();
      }
   }
}
