#################################################################
#
# ResultWebPages.py
#
# Authors: The DNA team, http://www.dna.ac.uk
#
#################################################################


class ResultWebPages:
  

  def write_index_result_web_page(self, log_dir, index_request, index_response_1, index_response_2, index_response):
    #
    # First create directory
    #
    directory = "%s/index" % log_dir
    os.system("mkdir -p %s" % directory)
    #
    # Move the jpegs with the diffraction pattern
    #
    self.es.logwrite("Making jpeg images in %s" % directory)
    image_file_name_image1 = "%s_%d_%03d" % (index_request.getFileinfo().getPrefix(), \
                                             index_request.getFileinfo().getRun_number(), 1)
    image_file_path_image1 = "%s/%s.%s" % (index_request.getFileinfo().getDirectory(), \
                                           image_file_name_image1, \
                                           index_request.getFileinfo().getSuffix())
    image_file_name_image2 = "%s_%d_%03d" % (index_request.getFileinfo().getPrefix(), \
                                             index_request.getFileinfo().getRun_number(), \
                                             91)
    image_file_path_image2 = "%s/%s.%s" % (index_request.getFileinfo().getDirectory(), \
                                           image_file_name_image2,
                                           index_request.getFileinfo().getSuffix())
    dnatmpdir = None
    if "DNATMPDIR" in os.environ.keys():
      dnatmpdir = os.environ["DNATMPDIR"]
    else:
      dnatmpdir = "."
    os.system("mv %s/%s_pred.jpg %s/%s_pred.jpg" % (dnatmpdir, image_file_name_image1, \
                                                    directory, image_file_name_image1))
    os.system("mv %s/%s_pred.jpg %s/%s_pred.jpg" % (dnatmpdir, image_file_name_image2, \
                                                    directory, image_file_name_image2))
    os.system("mv %s/%s_pred_small.jpg %s/%s_pred_small.jpg" % (dnatmpdir, image_file_name_image1, \
                                                                directory, image_file_name_image1))
    os.system("mv %s/%s_pred_small.jpg %s/%s_pred_small.jpg" % (dnatmpdir, image_file_name_image2, \
                                                                directory, image_file_name_image2))
    os.system("mv %s/%s.jpg %s/%s.jpg" % (dnatmpdir, image_file_name_image1, \
                                          directory, image_file_name_image1))
    os.system("mv %s/%s.jpg %s/%s.jpg" % (dnatmpdir, image_file_name_image2, \
                                          directory, image_file_name_image2))
    os.system("mv %s/%s_small.jpg %s/%s_small.jpg" % (dnatmpdir, image_file_name_image1, \
                                                      directory, image_file_name_image1))
    os.system("mv %s/%s_small.jpg %s/%s_small.jpg" % (dnatmpdir, image_file_name_image2, \
                                                      directory, image_file_name_image2))
    #
    # Start writing the web page
    #
    webpage = open("%s/index.html" % directory, "w")
    webpage.write("<HTML>\n")
    webpage.write("<HEAD>\n")
    webpage.write("<TITLE>Index results</TITLE>\n")
    webpage.write("</HEAD>\n")
    webpage.write("<BODY BGCOLOR=\"#FFFFFF\">\n")
    webpage.write("<CENTER><H1>Index results</H1></CENTER>\n")
    webpage.write("<H3>Symmetry and refined cell parameters</H3>\n")
    webpage.write("<TABLE WIDTH=100% BORDER=2>\n")
    webpage.write("<TR ALIGN=CENTER>\n")
    webpage.write("  <TD>Image</TD>\n")
    webpage.write("  <TD>Symmetry</TD>\n")
    webpage.write("  <TD>a</TD>\n")
    webpage.write("  <TD>b</TD>\n")
    webpage.write("  <TD>c</TD>\n")
    webpage.write("  <TD>alpha</TD>\n")
    webpage.write("  <TD>beta</TD>\n")
    webpage.write("  <TD>gamma</TD>\n")
    webpage.write("</TR>\n")
    self.write_html_table_symmetry_cell(webpage, "1", index_response_1)
    self.write_html_table_symmetry_cell(webpage, "2", index_response_2)
    self.write_html_table_symmetry_cell(webpage, "1+2", index_response)
    webpage.write("</TABLE>\n")
    webpage.write("<H3>Spots found, rejected, RMS spot deviation, beamcentre shift</H3>\n")
    webpage.write("<TABLE WIDTH=100% BORDER=2>\n")
    webpage.write("<TR ALIGN=CENTER>\n")
    webpage.write("  <TD>Image</TD>\n")
    webpage.write("  <TD>Spots used in refinement</TD>\n")
    webpage.write("  <TD>Spots used in indexing</TD>\n")
    webpage.write("  <TD>Fraction rejected from refinement</TD>\n")
    webpage.write("  <TD>RMS spot deviation</TD>\n")
    webpage.write("  <TD>Beam shift x</TD>\n")
    webpage.write("  <TD>Beam shift y</TD>\n")
    webpage.write("</TR>\n")
    self.write_html_table_spots(webpage, "1", index_response_1)
    self.write_html_table_spots(webpage, "2", index_response_2)
    self.write_html_table_spots(webpage, "1+2", index_response)
    webpage.write("</TABLE>\n")
    webpage.write("<H3>Image 1: %s</H3>\n" % image_file_path_image1)
    webpage.write("<A HREF=\"image1.html\"><IMG SRC=\"%s_small.jpg\"></A>\n" % 
                  image_file_name_image1 )
    webpage.write("<H3>Image 2: %s</H3>\n" % image_file_path_image2)
    webpage.write("<A HREF=\"image2.html\"><IMG SRC=\"%s_small.jpg\"></A>\n" % \
                  image_file_name_image2 )
    webpage.write("<H3>Image 1 with predictions</H3>\n")
    webpage.write("<A HREF=\"image1_pred.html\"><IMG SRC=\"%s_pred_small.jpg\"></A>\n" % \
                  image_file_name_image1 )
    webpage.write("<H3>Image 2 with predictions</H3>\n")
    webpage.write("<A HREF=\"image2_pred.html\"><IMG SRC=\"%s_pred_small.jpg\"></A>\n" % \
                  image_file_name_image2 )
    webpage.write("<A HREF=\"dpm_log.html\"><H3>Data Processing Module Log</H3></A>\n")    
    webpage.close()
    #
    #
    #
    webpage = open("%s/dpm_log.html" % directory, "w")    
    webpage.write("<HTML>\n")
    webpage.write("<HEAD>\n")
    webpage.write("<TITLE>Data Processing Module Log</TITLE>\n")
    webpage.write("</HEAD>\n")
    webpage.write("<BODY BGCOLOR=\"#FFFFFF\">\n")
    webpage.write("<H3>Data Processing Module Log  - <A HREF=\"index.html\">Back to the index result page</A></H3>\n")
    webpage.write("<PRE>\n")
    dpm_log = self.getLog()
    webpage.write(dpm_log)
    webpage.write("</PRE>/n")
    webpage.write("<CENTER><H3><A HREF=\"index.html\">Back to the index result page</A></H3></CENTER>\n")
    webpage.write("</BODY>/n")    
    webpage.write("</HTML>")
    webpage.close()
    #
    #
    #
    self.write_full_image_page(directory, "image1.html", image_file_name_image1, "")
    self.write_full_image_page(directory, "image2.html", image_file_name_image2, "")
    self.write_full_image_page(directory, "image1_pred.html", image_file_name_image1, "_pred")
    self.write_full_image_page(directory, "image2_pred.html", image_file_name_image2, "_pred")
    #
    # Test of sending the URL to the GUI
    #
    gui_display_url_request = XSD.Gui_display_url_request()
    gui_display_url_request.setUrl("file://%s/index.html" % directory)
    self.es.gui_send_message( "/gui_display_url_request", gui_display_url_request)


  def write_full_image_page(self, directory, page_name, image_file_name, suffix):
    webpage = open("%s/%s" % (directory, page_name), "w")
    webpage.write("<HTML>\n")
    webpage.write("<HEAD>\n")
    webpage.write("<TITLE>Image %s </TITLE>\n" % image_file_name)
    webpage.write("</HEAD>\n")
    webpage.write("<BODY BGCOLOR=\"#FFFFFF\">\n")
    webpage.write("<CENTER><H1>Image %s</H1></CENTER>\n" % image_file_name)
    webpage.write("<IMG SRC=\"%s%s.jpg\">\n" % (image_file_name, suffix) )
    webpage.write("<CENTER><H3><A HREF=\"index.html\">Back to the index result page</A></H3></CENTER>\n")
    webpage.write("</BODY>/n")    
    webpage.write("</HTML>")    
    webpage.close()


  def write_html_table_symmetry_cell(self, fileobject, image, index_response):
    solution = index_response.getSolution()
    cell = solution.getOrientation().getCell()
    fileobject.write("<TR ALIGN=CENTER>\n")
    fileobject.write("  <TD>%s</TD>\n" % (image))
    fileobject.write("  <TD>%s</TD>\n" % (solution.getSymmetry()))
    fileobject.write("  <TD>%8.3f</TD>\n" % (cell.getA()))
    fileobject.write("  <TD>%8.3f</TD>\n" % (cell.getB()))
    fileobject.write("  <TD>%8.3f</TD>\n" % (cell.getC()))
    fileobject.write("  <TD>%8.3f</TD>\n" % (cell.getAlpha()))
    fileobject.write("  <TD>%8.3f</TD>\n" % (cell.getBeta()))
    fileobject.write("  <TD>%8.3f</TD>\n" % (cell.getGamma()))
    fileobject.write("</TR>\n")
    
  def write_html_table_spots(self, fileobject, image, index_response):
    solution = index_response.getSolution()
    refinement = solution.getRefinement()
    reflections = refinement.getReflections()
    spots = index_response.getSpot_search_response()
    deltabeam = solution.getRefinement().getBeam_shift().getShift()
    fileobject.write("<TR ALIGN=CENTER>\n")
    fileobject.write("  <TD>%s</TD>\n" % image )
    fileobject.write("  <TD>%d</TD>\n" % reflections.getUsed() )
    fileobject.write("  <TD>%d</TD>\n" % reflections.getUsed_in_indexing())
    fileobject.write("  <TD>%8.3f</TD>\n" % (1.0 - 1.0* reflections.getUsed()/reflections.getUsed_in_indexing()) )
    fileobject.write("  <TD>%8.3f</TD>\n" % (solution.getSpot_deviation()))
    fileobject.write("  <TD>%8.3f</TD>\n" % (deltabeam.getX()))
    fileobject.write("  <TD>%8.3f</TD>\n" % (deltabeam.getY()))
    fileobject.write("</TR>\n")
