#!/usr/bin/env python
# Vector.py
# Maintained by G.Winter
# 11th February 2004
# A few vectorially orientated odds and ends - like constructors for 
# matrices implemented as lists and so on...
# 
# This is implemented in MATHS not in C.
# M[i][j] = Row i, Column j
# 
# $Id: Vector.py,v 1.2 2004/05/18 11:32:14 svensson Exp $

import math, copy

def Vector(length = 3):
    list = []
    for i in range(length):
        list.append(0.0)

    return list

def Add(a, b):
    result = Vector()
    for i in range(len(a)):
        result[i] = a[i] + b[i]

    return result

def Subtract(a, b):
    result = Vector()
    for i in range(len(a)):
        result[i] = a[i] - b[i]

    return result

def Unit(vector):
    magnitude = math.sqrt(Dot(vector, vector))
    return MultiplyScalarVector(1.0 / magnitude, vector)

def Magnitude(vector):
    return math.sqrt(Dot(vector, vector))

def Dot(a, b):
    sum = 0.0
    for i in range(len(a)):
        sum += a[i] * b[i]

    return sum

def Cross(a, b):
    result = Vector()
    result[0] = a[1] * b[2] - a[2] * b[1]
    result[1] = a[2] * b[0] - a[0] * b[2]
    result[2] = a[0] * b[1] - a[1] * b[0]
    return result

def MultiplyScalarVector(scalar, vector):
    result = []
    for v in vector:
        result.append(scalar * v)

    return result

def Matrix(rows = 3, columns = 3):
    matrix = []
    for i in range(rows):
        matrix.append([])
        for j in range(columns):
            matrix[i].append(0.0)

    return matrix

def PrintMatrix(matrix):
    return '(%3.3f, %3.3f, %3.3f), (%3.3f, %3.3f, %3.3f), (%3.3f, %3.3f, %3.3f)' % \
           (matrix[0][0], matrix[0][1], matrix[0][2],
            matrix[1][0], matrix[1][1], matrix[1][2],
            matrix[2][0], matrix[2][1], matrix[2][2])
            

def MultiplyMatrix(A, B):
    C = Matrix()
    for i in range(3):
        for j in range(3):
            dot = 0.0
            for k in range(3):
                dot += A[i][k] * B[k][j]
            C[i][j] = dot

    return C

def Transpose(matrix):
    transpose = Matrix()
    for i in range(3):
        for j in range(3):
            transpose[j][i] = matrix[i][j]

    return transpose


def Invert(matrix):
    '''This will invert a 3x3 matrix based on Numerical Recipe gaussj'''
    indxc = [0, 0, 0]
    indxr = [0, 0, 0]
    ipiv = [0, 0, 0]

    a = copy.deepcopy(matrix)
    
    for i in range(3):
        big = 0.0
        for j in range(3):
            if ipiv[j] != 1:
                for k in range(3):
                    if ipiv[k] == 0:
                        if math.fabs(a[j][k]) > big:
                            big = math.fabs(a[j][k])
                            irow = j
                            icol = k

        ipiv[icol] += 1
        if irow != icol:
            for l in range(3):
                a[irow][l], a[icol][l] = a[icol][l], a[irow][l]
        indxr[i] = irow
        indxc[i] = icol

        if a[icol][icol] == 0.0:
            raise RuntimeError, 'Singular matrix'

        pivinv = 1.0 / a[icol][icol]
        a[icol][icol] = 1.0
        for l in range(3):
            a[icol][l] *= pivinv
        for ll in range(3):
            if ll != icol:
                dum = a[ll][icol]
                a[ll][icol] = 0.0
                for l in range(3):
                    a[ll][l] -= a[icol][l] * dum

    for i in range(3):
        l = 2 - i
        if indxr[l] != indxc[l]:
            for k in range(3):
                a[k][indxr[l]], a[k][indxc[l]] = a[k][indxc[l]], a[k][indxr[l]]

    return a

if __name__ == '__main__':
    v = Vector()
    m = Matrix()

    for i in range(3):
        print v[i]
        for j in range(3):
            m[i][j] = (1.0) * ((2 + i * j) % 5)

    print m

    i = Invert(m)

    print i


    for a in range(3):
        for b in range(3):
            total = 0.0
            for c in range(3):
                total += m[a][c] * i[c][b]

            print total
